/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.datamodel.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.mservice.EPDMCUDRequest;
import kd.epm.epbs.business.mservice.EPDMDataRequest;
import kd.epm.epbs.business.mservice.EPDMRequest;
import kd.epm.epbs.common.util.D;
import kd.epm.epbs.common.util.DateTimeUtils;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epdm.business.etl.helper.MainModelServiceHelper;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.CUDWrapper;
import kd.epm.epdm.common.database.DbQueryUtils;
import kd.epm.epdm.common.enums.DBTypeEnum;
import kd.epm.epdm.common.enums.ResourceTypeEnum;
import kd.epm.epdm.common.enums.form.EpdmDataQueryTaskEnum;
import kd.epm.epdm.common.enums.form.EpdmDatamodelEnum;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;
import kd.epm.epdm.common.util.MetadataUtil;

public class DataModelCURDServiceHelper {
    private static final Log log = LogFactory.getLog(DataModelCURDServiceHelper.class);
    private static final long EXPIRE = 1800000L;
    private static final int MAX_RUNNING_TASK = 50;

    public static void updateQueryTaskStatus(long id, String status, EPDMRequest request, boolean upHistory) {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)id, (String)EpdmDataQueryTaskEnum.getFormId());
        task.set("status", (Object)status);
        if (null != request && request instanceof EPDMDataRequest) {
            EPDMDataRequest req = (EPDMDataRequest)request;
            task.set("total", (Object)req.getTotal());
            task.set("last_page", (Object)req.getLastPage());
            task.set("page", (Object)req.getPage());
        }
        SaveServiceHelper.update((DynamicObject)task);
        if (upHistory) {
            String update = "update t_epdm_query_task set fstatus='2' where (fstatus='0' or  fstatus='1') and fcreatetime<'" + DateTimeUtils.format((Date)new Date(System.currentTimeMillis() - 54000000L)) + "'";
            DB.execute((DBRoute)MetadataUtil.getDBRoute((String)EpdmDataQueryTaskEnum.getFormId()), (String)update);
        }
    }

    public static <T extends EPDMRequest> List<T> toRequest(long queryId, Class<T> clazz) {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)queryId, (String)EpdmDataQueryTaskEnum.getFormId());
        if ("1".equals(task.getString("status")) || "2".equals(task.getString("status"))) {
            if (task.getDate("createtime").getTime() < System.currentTimeMillis() - 1800000L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"DataModelCURDServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
        } else {
            if ("3".equals(task.getString("status"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u5df2\u7ecf\u6267\u884c\u5b8c\u6bd5\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", (String)"DataModelCURDServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            String sql = "select count(1) from t_epdm_query_task where fstatus='1' and fcreatetime>'" + DateTimeUtils.format((Date)new Date(System.currentTimeMillis() - 1800000L)) + "'";
            int count = (Integer)DB.query((DBRoute)MetadataUtil.getDBRoute((String)EpdmDataQueryTaskEnum.getFormId()), (String)sql, rs -> {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            });
            if (count > 50) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u8bf7\u6c42\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DataModelCURDServiceHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
        }
        String json = task.getString("params");
        try {
            ArrayList<EPDMRequest> requests;
            if (json.startsWith("[")) {
                requests = JSON.parseArray((String)json, clazz);
                for (EPDMRequest request : requests) {
                    request.setTotal(task.getInt("total"));
                    request.setPage(task.getInt("page") + 1);
                    request.setLastPage(task.getInt("last_page"));
                }
            } else {
                requests = new ArrayList<EPDMRequest>();
                EPDMRequest request = (EPDMRequest)JSON.parseObject((String)json, clazz);
                request.setTotal(task.getInt("total"));
                request.setPage(task.getInt("page") + 1);
                request.setLastPage(task.getInt("last_page"));
                request.status("3");
                requests.add(request);
            }
            if (requests.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8bf7\u6c42\uff0c\u83b7\u53d6\u8be5\u8bf7\u6c42\u5df2\u88ab\u5220\u9664\u3002", (String)"DataModelCURDServiceHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            DataModelCURDServiceHelper.updateQueryTaskStatus(queryId, "1", null, false);
            return requests;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u67e5\u8be2\u8bf7\u6c42\u3002", (String)"DataModelCURDServiceHelper_5", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
    }

    public static long createCUDid(EPDMCUDRequest request) {
        return DataModelCURDServiceHelper.saveCUDid(JSON.toJSONString((Object)request), request);
    }

    public static long createMultCUDid(List<EPDMCUDRequest> requests) {
        return DataModelCURDServiceHelper.saveCUDid(JSON.toJSONString(requests), requests.get(0));
    }

    private static long saveCUDid(String paramsJson, EPDMCUDRequest request) {
        DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)EpdmDataQueryTaskEnum.getFormId());
        long id = GlobalIdUtil.genGlobalLongId();
        task.set(EpdmDataQueryTaskEnum.id.name(), (Object)id);
        task.set(EpdmDataQueryTaskEnum.number.name(), (Object)GlobalIdUtil.genStringId());
        task.set(EpdmDataQueryTaskEnum.status.name(), (Object)"0");
        task.set(EpdmDataQueryTaskEnum.action.name(), (Object)request.getAction());
        task.set(EpdmDataQueryTaskEnum.app.name(), (Object)request.getApp());
        task.set(EpdmDataQueryTaskEnum.params.name(), (Object)paramsJson);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        return id;
    }

    public static Map<String, Object> update(EPDMCUDRequest request, long CUDid, Map<String, Object> params) {
        long t = System.currentTimeMillis();
        String status = request.status();
        try {
            ValidityResult result = DataModelCURDServiceHelper.validity(request);
            String where = request.where();
            if (request.getDefWhere().equalsIgnoreCase(where)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u66f4\u65b0\u6761\u4ef6\uff0c\u5f71\u54cd\u6570\u636e\u8303\u56f4\u8fc7\u5927\u3002", (String)"DataModelCURDServiceHelper_6", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter(EpdmDmPresetEnum.mainmodel.name(), "=", (Object)EpdmDatamodelEnum.id.getLong(result.getModelObject()));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)EpdmDmPresetEnum.getFormId(), (String)EpdmDmPresetEnum.get().selectFields(), (QFilter[])new QFilter[]{qFilter});
            result.getDs().setDbRoute(MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()));
            CUDWrapper wrapper = CUDWrapper.factory((AbsDataSource)result.getDs());
            int count = wrapper.update(result.getDs(), result.getTable(), dynamicObjects, params, where);
            HashMap<String, Object> res = new HashMap<String, Object>(2);
            res.put("count", count);
            res.put("time", System.currentTimeMillis() - t);
            res.put("where", where);
            HashMap<String, Object> hashMap = res;
            return hashMap;
        }
        catch (Exception e) {
            status = "2";
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (!"0".equals(request.status())) {
                DataModelCURDServiceHelper.updateQueryTaskStatus(CUDid, status, null, true);
            }
        }
    }

    public static Map<String, Object> create(EPDMCUDRequest request, long CUDid, List<Map<String, Object>> params) {
        long t = System.currentTimeMillis();
        String status = request.status();
        try {
            ValidityResult result = DataModelCURDServiceHelper.validity(request);
            QFilter qFilter = new QFilter(EpdmDmPresetEnum.mainmodel.name(), "=", (Object)EpdmDatamodelEnum.id.getLong(result.getModelObject()));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)EpdmDmPresetEnum.getFormId(), (String)EpdmDmPresetEnum.get().selectFields(), (QFilter[])new QFilter[]{qFilter});
            result.getDs().setDbRoute(MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()));
            CUDWrapper wrapper = CUDWrapper.factory((AbsDataSource)result.getDs());
            int count = wrapper.create(result.getDs(), result.getTable(), dynamicObjects, params);
            HashMap<String, Object> res = new HashMap<String, Object>(2);
            res.put("count", count);
            res.put("time", System.currentTimeMillis() - t);
            HashMap<String, Object> hashMap = res;
            return hashMap;
        }
        catch (Exception e) {
            status = "2";
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (!"0".equals(request.status())) {
                DataModelCURDServiceHelper.updateQueryTaskStatus(CUDid, status, null, true);
            }
        }
    }

    public static Map<String, Object> delete(EPDMCUDRequest request, long CUDid) {
        long t = System.currentTimeMillis();
        String status = request.status();
        try {
            ValidityResult result = DataModelCURDServiceHelper.validity(request);
            String where = request.where();
            if (request.getDefWhere().equalsIgnoreCase(where)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u66f4\u65b0\u6761\u4ef6\uff0c\u5f71\u54cd\u6570\u636e\u8303\u56f4\u8fc7\u5927\u3002", (String)"DataModelCURDServiceHelper_6", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            result.getDs().setDbRoute(MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()));
            CUDWrapper wrapper = CUDWrapper.factory((AbsDataSource)result.getDs());
            int count = wrapper.delete(result.getDs(), result.getTable(), where);
            HashMap<String, Object> res = new HashMap<String, Object>(2);
            res.put("count", count);
            res.put("time", System.currentTimeMillis() - t);
            res.put("where", where);
            HashMap<String, Object> hashMap = res;
            return hashMap;
        }
        catch (Exception e) {
            status = "2";
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (!"0".equals(request.status())) {
                DataModelCURDServiceHelper.updateQueryTaskStatus(CUDid, status, null, true);
            }
        }
    }

    public static ValidityResult validity(EPDMCUDRequest request) {
        AbsDataSource ds;
        ValidityResult res = new ValidityResult();
        String modelNumber = request.getModel();
        QFilter qFilter = new QFilter("id", "=", (Object)D.l((Object)modelNumber));
        String selectFields = EpdmDatamodelEnum.id + "," + EpdmDatamodelEnum.number + "," + EpdmDatamodelEnum.type + "," + EpdmDatamodelEnum.table;
        DynamicObject modelObject = QueryServiceHelper.queryOne((String)EpdmDatamodelEnum.getFormId(), (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (modelObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"DataModelCURDServiceHelper_7", (String)"epm-epbs-business", (Object[])new Object[0]), modelNumber));
        }
        res.setModelObject(modelObject);
        String type = EpdmDatamodelEnum.type.getString(modelObject);
        if (!ResourceTypeEnum.DataTable.getNumber().equalsIgnoreCase(type)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\uff08%2$s\uff09\u4e0d\u652f\u6301\u5199\u5165\u6570\u636e\u3002", (String)"DataModelCURDServiceHelper_8", (String)"epm-epbs-business", (Object[])new Object[0]), modelObject.get("number"), type));
        }
        String linkNumber = request.getLink();
        DynamicObject cfg = MainModelServiceHelper.getLink(linkNumber);
        String dbRoute = request.getDbRoute();
        if (StringUtils.isEmpty((String)dbRoute)) {
            dbRoute = MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()).getRouteKey();
        }
        if (null == (ds = DbQueryUtils.getDataSource((DynamicObject)cfg, (String)dbRoute))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s\u201d\uff08%2$s\uff09\uff0c\u83b7\u53d6\u6570\u636e\u94fe\u63a5\u5931\u8d25\u3002", (String)"DataModelCURDServiceHelper_9", (String)"epm-epbs-business", (Object[])new Object[0]), cfg.get("name"), cfg.get("number")));
        }
        res.setDs(ds);
        request.setOraLike(DBTypeEnum.ORACLE.name().equalsIgnoreCase(ds.getType().name()));
        String table = EpdmDatamodelEnum.table.getString(modelObject);
        if (StringUtils.isEmpty((String)table)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u5bf9\u5e94\u7684\u8868\u540d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8be5\u6a21\u578b\u662f\u5426\u6210\u529f\u5efa\u8868\u3002", (String)"DataModelCURDServiceHelper_10", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        res.setTable(table);
        return res;
    }

    public static class ValidityResult {
        private DynamicObject modelObject;
        private AbsDataSource ds;
        private String table;

        public DynamicObject getModelObject() {
            return this.modelObject;
        }

        public void setModelObject(DynamicObject modelObject) {
            this.modelObject = modelObject;
        }

        public AbsDataSource getDs() {
            return this.ds;
        }

        public void setDs(AbsDataSource ds) {
            this.ds = ds;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }
    }
}

