/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.datamodel.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.isc.util.misc.Json;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.common.constant.EPDMPresetFieldConstant;
import kd.epm.epdm.common.enums.DataModelPresetEnum;

public class DataModelPresetFormHepler {
    private static final String EPDM_DATAMODEL_PRESET = "epdm_dm_preset";

    public static Map<String, Object> updateTableModel(long dataModelId) {
        QFilter filter = new QFilter("datamodel", "=", (Object)dataModelId);
        String selectFields = "id,field,content,datatype";
        List<Object> dynamicObjects = new ArrayList();
        List<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)EPDM_DATAMODEL_PRESET, (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (objects != null && objects.length > 0) {
            dynamicObjects = Arrays.asList(objects);
        }
        if (!dynamicObjects.isEmpty()) {
            fields = dynamicObjects.stream().map(o -> {
                HashMap<String, String> field = new HashMap<String, String>(16);
                field.put("is_private", "0");
                field.put("is_primary_key", "0");
                field.put("field", o.getString("field"));
                field.put("label", o.getString("content"));
                field.put("is_required", "0");
                field.put("data_type", o.getString("datatype"));
                return field;
            }).collect(Collectors.toList());
        }
        return DataModelPresetFormHepler.updateTableModel(dataModelId, fields);
    }

    public static Map<String, Object> updateTableModel(long id, List<Map<String, Object>> fields) {
        if (fields.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"fields\u4e3a\u7a7a,\u5fc5\u987b\u4f20\u5165\u5b57\u6bb5\u5185\u5bb9\u3002", (String)"DataModelPresetFormHepler_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        fields.add(0, EPDMPresetFieldConstant.FID);
        if (DataModelPresetEnum.T_EPM_VOUCHER.getId().equals(id)) {
            fields.add(EPDMPresetFieldConstant.VOUCHER_FPKEYID);
        } else if (DataModelPresetEnum.T_EPM_BALANCE.getId().equals(id)) {
            fields.add(EPDMPresetFieldConstant.BALANCE_FCURRENCYID);
        }
        QFilter filter = new QFilter("id", "=", (Object)id).and("type", "=", (Object)"DataModel.Table");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (String)"id,modifier,modifytime,details_tag", (QFilter[])new QFilter[]{filter});
        if (object == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"id\u4e3a%s\u7684\u8d44\u6e90\u4e0d\u5b58\u5728\u3002", (String)"DataModelPresetFormHepler_2", (String)"epm-epbs-business", (Object[])new Object[0]), id));
        }
        HashMap<String, Object> details = (HashMap<String, Object>)Json.toObject((String)object.getString("details_tag"));
        if (details == null) {
            details = new HashMap<String, Object>();
        }
        ArrayList fields_new = new ArrayList(fields.size());
        for (Map<String, Object> field : fields) {
            HashMap<String, Object> temp = new HashMap<String, Object>(16);
            temp.put("is_private", D.x((Object)field.get("is_private")));
            boolean is_primary_key = D.x((Object)field.get("is_primary_key"));
            temp.put("is_primary_key", is_primary_key);
            temp.put("field", D.s((Object)field.get("field")));
            temp.put("is_required", D.x((Object)field.get("is_required")));
            temp.put("label", D.s((Object)field.get("label")));
            temp.put("data_type", D.s((Object)field.get("data_type")));
            temp.put("id", D.s((Object)IDService.get().genLongId()));
            fields_new.add(temp);
        }
        details.put("fields", fields_new);
        details.put("digest_format", "");
        DataModelPresetFormHepler.setDigestFormatForEntity(details);
        if (D.s(details.get("digest_format")) == null) {
            details.put("digest_format", ResManager.loadKDString((String)"\u65e0", (String)"DataModelPresetFormHepler_3", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        object.set("details_tag", (Object)Json.toString(details));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        String type = object.getDataEntityType().getName();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)type, (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            HashMap<String, Object> temp = new HashMap<String, Object>(2);
            temp.put("id", id);
            temp.put("msg", "success");
            return temp;
        }
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (!allErrorOrValidateInfo.isEmpty()) {
            throw new KDBizException(((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage());
        }
        throw new KDBizException(operationResult.getMessage());
    }

    public static void setDigestFormatForEntity(Map<String, Object> details) {
        Object f = details.get("fields");
        if (f instanceof List) {
            List fields = (List)f;
            HashSet<String> df = new HashSet<String>();
            for (Map field : fields) {
                String prop_name = D.s(field.get("field"));
                if (!"number".equalsIgnoreCase(prop_name) && !"name".equalsIgnoreCase(prop_name) && !"billno".equalsIgnoreCase(prop_name) && !"FNumber".equalsIgnoreCase(prop_name) && !"FName".equalsIgnoreCase(prop_name) && !"FBillNo".equalsIgnoreCase(prop_name)) continue;
                df.add(prop_name);
            }
            DataModelPresetFormHepler.innerSetDigestFormat(details, df);
        }
    }

    private static void innerSetDigestFormat(Map<String, Object> details, Set<String> df) {
        if (!df.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String[] array = df.toArray(new String[0]);
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append('(');
                }
                sb.append("#{");
                sb.append(array[i]);
                sb.append('}');
                if (i <= 0) continue;
                sb.append(')');
            }
            details.put("digest_format", sb.toString());
        }
    }
}

