/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.datamodel.helper;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.thread.EpbsFuture;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epdm.common.entity.EPDMDataModelPreset;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.enums.DataModelPresetFieldTypeEnum;
import kd.epm.epdm.common.enums.DataModelPresetLabelEnum;
import kd.epm.epdm.common.enums.DataModelRefTypeEnum;
import kd.epm.epdm.common.util.ListColumnEditUtil;
import kd.epm.epdm.common.util.LongUtil;
import kd.epm.epdm.common.util.MetadataUtil;

public class DataModelPresetHelper {
    public static DynamicObjectCollection queryVoucherDim() {
        QFBuilder qfBuilder = new QFBuilder("type", "=", (Object)DataModelPresetFieldTypeEnum.Line.name()).and("ispreset", "=", (Object)false).and("datamodel", "=", (Object)DataModelPresetEnum.T_EPM_VOUCHER.getId()).and("label", "=", (Object)DataModelPresetLabelEnum.DIM.getValue());
        String selectFields = String.join((CharSequence)",", "content", "datatype", "reftype", "ref", "reffield", "showfields", "remark", "field");
        return QueryServiceHelper.query((String)"epdm_dm_preset", (String)selectFields, (QFilter[])qfBuilder.toArray());
    }

    public static Set<String> getDimSetting() {
        EpbsFuture aliasToPropertyFuture = EpbsFuture.supplyAsync(() -> {
            String formId = "epdm_voucherdesc";
            return MetadataUtil.getAliasToProperty((String)formId);
        });
        EpbsFuture lineFieldFuture = EpbsFuture.supplyAsync(() -> {
            Multimap<String, EPDMDataModelPreset> presetMultimap = DataModelPresetHelper.queryPresetByEnum(DataModelPresetEnum.T_EPM_VOUCHER);
            return presetMultimap.get((Object)DataModelPresetFieldTypeEnum.Line.name());
        });
        EpbsFuture bothFuture = lineFieldFuture.thenCombine((CompletionStage)aliasToPropertyFuture, (lineField, aliasToProperty) -> lineField.stream().map(EPDMDataModelPreset::getField).map(String::toUpperCase).map(aliasToProperty::get).filter(pro -> pro.getPropertyType() == String.class).map(IMetadata::getName).collect(Collectors.toSet()));
        return (Set)bothFuture.join();
    }

    public static void queryPresetAccNumberNameMapThenDoAction(DataModelPresetEnum presetEnum, Map<String, String> accountNumberNameMap, List<String> accList, List<Runnable> setAccNameFunc) {
        String targetField = "faccount";
        DataModelPresetHelper.queryPresetFieldNumberNameMapThenDoAction(presetEnum, accountNumberNameMap, accList, setAccNameFunc, targetField);
    }

    public static void queryPresetFieldNumberNameMapThenDoAction(DataModelPresetEnum presetEnum, Map<String, String> numberNameMap, Collection<String> numberList, Collection<Runnable> setFieldNameFunc, String targetField) {
        Multimap<String, EPDMDataModelPreset> preset = DataModelPresetHelper.queryPresetByFilter(qFilter -> qFilter.and("field", "=", (Object)targetField).and("datamodel.number", "=", (Object)presetEnum.getNumber()));
        preset.forEach((k, v) -> {
            String ref = v.getRef();
            String refType = v.getRefType();
            String dataEntityNumber = ref;
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            if (DataModelRefTypeEnum.Assistantdata.name().equals(refType)) {
                dataEntityNumber = "bos_assistantdata_detail";
                qFilter.and("group", "=", (Object)LongUtil.toLong((String)ref));
            } else if (DataModelRefTypeEnum.Enum.name().equals(refType)) {
                dataEntityNumber = "epdm_datamodelenumf7";
                qFilter.and("ref", "=", (Object)LongUtil.toLong((String)ref));
            } else if (!DataModelRefTypeEnum.Entityobject.name().equals(refType)) {
                return;
            }
            BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)dataEntityNumber);
            String number = dataEntityType.getNumberProperty();
            String name = dataEntityType.getNameProperty();
            Map<String, String> collect = QueryServiceHelper.query((String)dataEntityNumber, (String)String.join((CharSequence)",", number, name), (QFilter[])new QFilter[]{qFilter, new QFilter(number, "in", (Object)numberList)}).stream().collect(Collectors.toMap(dy -> dy.getString(number), dy -> dy.getString(name), (v1, v2) -> v1));
            if (!collect.isEmpty()) {
                numberNameMap.putAll(collect);
                setFieldNameFunc.forEach(Runnable::run);
            }
        });
    }

    public static void queryPresetFieldNumberDynThenDoAction(DataModelPresetEnum presetEnum, Map<String, DynamicObject> numberNameMap, Collection<String> numberList, Collection<Runnable> setFieldNameFunc, String targetField) {
        Multimap<String, EPDMDataModelPreset> preset = DataModelPresetHelper.queryPresetByFilter(qFilter -> qFilter.and("field", "=", (Object)targetField).and("datamodel.number", "=", (Object)presetEnum.getNumber()));
        preset.forEach((k, v) -> {
            String ref = v.getRef();
            String refType = v.getRefType();
            String dataEntityNumber = ref;
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            if (DataModelRefTypeEnum.Assistantdata.name().equals(refType)) {
                dataEntityNumber = "bos_assistantdata_detail";
                qFilter.and("group", "=", (Object)LongUtil.toLong((String)ref));
            } else if (DataModelRefTypeEnum.Enum.name().equals(refType)) {
                dataEntityNumber = "epdm_datamodelenumf7";
                qFilter.and("ref", "=", (Object)LongUtil.toLong((String)ref));
            } else if (!DataModelRefTypeEnum.Entityobject.name().equals(refType)) {
                return;
            }
            BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)dataEntityNumber);
            List allProp = dataEntityType.getProperties().stream().filter(p -> StringUtils.isNotEmpty((String)p.getAlias())).map(IMetadata::getName).collect(Collectors.toList());
            String number = dataEntityType.getNumberProperty();
            Map<String, DynamicObject> collect = QueryServiceHelper.query((String)dataEntityNumber, (String)String.join((CharSequence)",", allProp), (QFilter[])new QFilter[]{qFilter, new QFilter(number, "in", (Object)numberList)}).stream().collect(Collectors.toMap(dy -> dy.getString(number), dy -> dy, (v1, v2) -> v1));
            if (!collect.isEmpty()) {
                numberNameMap.putAll(collect);
                setFieldNameFunc.forEach(Runnable::run);
            }
        });
    }

    public static Map<String, Object> queryDimConfigIdMap(String[] selectedDims, DataModelPresetEnum dataModelPresetEnum) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"epdm_voucherbase");
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        EntryProp property = (EntryProp)properties.get((Object)"voucherrows");
        DynamicObjectType itemPropertyType = property.getDynamicCollectionItemPropertyType();
        DataEntityPropertyCollection typeProperties = itemPropertyType.getProperties();
        Map<String, String> fieldAliasMap = Arrays.stream(selectedDims).filter(dim -> !"".equals(((IDataEntityProperty)typeProperties.get(dim)).getAlias())).collect(Collectors.toMap(dim -> ((IDataEntityProperty)typeProperties.get(dim)).getAlias(), dim -> dim, (v1, v2) -> v1));
        QFBuilder qfBuilder = new QFBuilder("field", "in", fieldAliasMap.keySet()).and("type", "=", (Object)DataModelPresetFieldTypeEnum.Line.name()).and("datamodel.number", "=", (Object)dataModelPresetEnum.getNumber());
        String selectFields = String.join((CharSequence)",", "field", "id");
        return QueryServiceHelper.query((String)"epdm_dm_preset", (String)selectFields, (QFilter[])qfBuilder.toArray()).stream().collect(Collectors.toMap(dy -> (String)fieldAliasMap.get(dy.getString("field")), dy -> dy.get("id"), (v1, v2) -> v1));
    }

    public static Multimap<String, EPDMDataModelPreset> queryPresetByEnum(DataModelPresetEnum presetEnum) {
        return DataModelPresetHelper.queryPresetByFilter(qFilter -> qFilter.and("datamodel.number", "=", (Object)presetEnum.getNumber()).and("ispreset", "=", (Object)false));
    }

    public static Multimap<String, EPDMDataModelPreset> queryPresetByFilter(UnaryOperator<QFilter> qFilterFunc) {
        ArrayListMultimap map = ArrayListMultimap.create();
        QFilter qFilter = (QFilter)qFilterFunc.apply(new QFilter("datamodel.catalog.long_number", "like", (Object)"INDUSTRY/EPM_759F7B55%"));
        String selectFields = new StringJoiner(",").add("type").add("field").add("content").add("ref").add("datatype").add("reftype").add("reffield").add("ispreset").toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epdm_dm_preset", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"dseq");
        for (DynamicObject dynamicObject : query) {
            String type = dynamicObject.getString("type");
            String field = dynamicObject.getString("field");
            String content = dynamicObject.getString("content");
            String refType = dynamicObject.getString("reftype");
            String refField = dynamicObject.getString("reffield");
            String ref = dynamicObject.getString("ref");
            String dataType = dynamicObject.getString("datatype");
            boolean isPreSet = dynamicObject.getBoolean("ispreset");
            Collection typeCollection = map.get((Object)type);
            typeCollection.add(new EPDMDataModelPreset(field, content, refType, refField, ref, dataType, isPreSet));
        }
        return map;
    }

    public static Collection<EPDMDataModelPreset> getDataModelPresetsLineDim() {
        Multimap<String, EPDMDataModelPreset> presetByEnum = DataModelPresetHelper.queryPresetByEnum(DataModelPresetEnum.T_EPM_VOUCHER);
        Collection dataModelPresets = presetByEnum.get((Object)DataModelPresetFieldTypeEnum.Line.name());
        String prefix = "fdim";
        dataModelPresets.removeIf(data -> data.getField() == null || !data.getField().toUpperCase(Locale.ROOT).startsWith(prefix.toUpperCase(Locale.ROOT)));
        return dataModelPresets;
    }

    public static Map<String, EPDMDataModelPreset> getDimToConfig(Multimap<String, EPDMDataModelPreset> presets, Map<String, IDataEntityProperty> aliasToProperty) {
        Collection dataModelPresets = presets.get((Object)DataModelPresetFieldTypeEnum.Line.name());
        FieldProp fieldProp = new FieldProp();
        fieldProp.setName("");
        return dataModelPresets.stream().collect(Collectors.toMap(preset -> ((IDataEntityProperty)aliasToProperty.getOrDefault(preset.getField().toUpperCase(Locale.ROOT), (IDataEntityProperty)fieldProp)).getName(), preset -> preset, (v1, v2) -> v1));
    }

    public static void userSettingToFilterColumn(DataModelPresetEnum dataModelPresetEnum, Consumer<FilterColumn> consumer) {
        Multimap<String, EPDMDataModelPreset> multimap = DataModelPresetHelper.queryPresetByFilter(qFilter -> qFilter.and("datamodel.number", "=", (Object)dataModelPresetEnum.getNumber()).and("ispreset", "=", (Object)false));
        Map map = MetadataUtil.getAliasToPropertyName((String)dataModelPresetEnum.getFormId());
        multimap.forEach((k, preset) -> {
            String field = preset.getField();
            String dim = (String)map.get(field.toUpperCase(Locale.ROOT));
            if (dim == null) {
                return;
            }
            String content = preset.getContent();
            SchemeFilterColumn col = new SchemeFilterColumn(dim);
            col.setCaption(new LocaleString(content));
            consumer.accept((FilterColumn)col);
        });
    }

    public static void addUserPresetToCol(List<IListColumn> listColumns, DataModelPresetEnum presetEnum, int index) {
        Multimap<String, EPDMDataModelPreset> userSettingFields = DataModelPresetHelper.queryPresetByEnum(presetEnum);
        Collection titleField = userSettingFields.get((Object)DataModelPresetFieldTypeEnum.Title.name());
        Collection itField = userSettingFields.get((Object)DataModelPresetFieldTypeEnum.IT.name());
        Collection lineField = userSettingFields.get((Object)DataModelPresetFieldTypeEnum.Line.name());
        Map map = MetadataUtil.getAliasToPropertyName((String)presetEnum.getFormId());
        ObjIntConsumer addListColumn = ListColumnEditUtil.addListColumnFunc((Map)map, listColumns);
        for (EPDMDataModelPreset setting : titleField) {
            addListColumn.accept(setting, index);
            ++index;
        }
        for (EPDMDataModelPreset setting : itField) {
            addListColumn.accept(setting, index);
            ++index;
        }
        for (EPDMDataModelPreset setting : lineField) {
            addListColumn.accept(setting, listColumns.size());
        }
    }

    public static void addUserPresetToCol(List<IListColumn> listColumns, DataModelPresetEnum presetEnum) {
        Multimap<String, EPDMDataModelPreset> userSettingFields = DataModelPresetHelper.queryPresetByFilter(qFilter -> qFilter.and("datamodel", "=", (Object)presetEnum.getId()));
        Collection titleField = userSettingFields.get((Object)DataModelPresetFieldTypeEnum.Title.name());
        Collection itField = userSettingFields.get((Object)DataModelPresetFieldTypeEnum.IT.name());
        Collection lineField = userSettingFields.get((Object)DataModelPresetFieldTypeEnum.Line.name());
        Set titleSet = titleField.stream().map(EPDMDataModelPreset::getField).map(String::toUpperCase).collect(Collectors.toSet());
        Set lineSet = lineField.stream().map(EPDMDataModelPreset::getField).map(String::toUpperCase).collect(Collectors.toSet());
        Map propertyToAlias = MetadataUtil.getPropertyToAlias((String)presetEnum.getFormId());
        HashMap aliasFieldMap = new HashMap(16);
        propertyToAlias.forEach((k, v) -> aliasFieldMap.put(v.toUpperCase(Locale.ROOT), k));
        List colList = listColumns.stream().map(ListColumn.class::cast).map(ListColumn::getFieldKey).map(propertyToAlias::get).filter(Objects::nonNull).map(String::toUpperCase).collect(Collectors.toList());
        int startTitle = 0;
        int startLine = 0;
        for (int i = 0; i < colList.size(); ++i) {
            String colField = (String)colList.get(i);
            if (titleSet.contains(colField)) {
                startTitle = i;
            }
            if (!lineSet.contains(colField)) continue;
            startLine = i;
        }
        ObjIntConsumer addListColumn = ListColumnEditUtil.addListColumnFunc(aliasFieldMap, listColumns);
        for (EPDMDataModelPreset setting : itField) {
            if (colList.contains(setting.getField().toUpperCase(Locale.ROOT))) continue;
            addListColumn.accept(setting, listColumns.size());
        }
        if (startTitle > startLine) {
            for (EPDMDataModelPreset setting : titleField) {
                if (colList.contains(setting.getField().toUpperCase(Locale.ROOT))) continue;
                addListColumn.accept(setting, ++startTitle);
            }
            for (EPDMDataModelPreset setting : lineField) {
                if (colList.contains(setting.getField().toUpperCase(Locale.ROOT))) continue;
                addListColumn.accept(setting, ++startLine);
            }
        } else {
            for (EPDMDataModelPreset setting : lineField) {
                if (colList.contains(setting.getField().toUpperCase(Locale.ROOT))) continue;
                addListColumn.accept(setting, ++startLine);
            }
            for (EPDMDataModelPreset setting : titleField) {
                if (colList.contains(setting.getField().toUpperCase(Locale.ROOT))) continue;
                addListColumn.accept(setting, ++startTitle);
            }
        }
    }

    private DataModelPresetHelper() {
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"DataModelPresetHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), this.getClass().getName());
        throw new IllegalStateException(msg);
    }
}

