/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.epbs.common.form.FormOpener;
import kd.epm.epdm.business.datamodel.helper.DataModelServiceHelper;
import kd.epm.epdm.common.constant.EPDMETLTaskConstant;
import kd.epm.epdm.common.util.IDataModelUtils;

public class EtlFieldSelectFormPluginHelper {
    private static void buildRow(List<Map<String, Object>> list, JSONArray dataModelFields, Long pid, String parentFullNumber, Map<String, Object> presetFixMap, List<String> selectedList, List<String> filterList) {
        if (dataModelFields == null) {
            return;
        }
        for (Object dataModelField : dataModelFields) {
            JSONObject field = (JSONObject)dataModelField;
            Long id = field.getLong("id");
            String fullNumber = field.getString("field");
            String dataType = field.getString("data_type");
            if (parentFullNumber != null) {
                fullNumber = parentFullNumber + "." + fullNumber;
            }
            if (!"REF".equals(dataType) && filterList != null && !filterList.contains(fullNumber) || !"REF".equals(dataType) && selectedList != null && selectedList.contains(fullNumber)) continue;
            field.put("pid", (Object)pid);
            field.put("fullnumber", (Object)fullNumber);
            if (presetFixMap != null && presetFixMap.containsKey(fullNumber)) continue;
            list.add((Map<String, Object>)field);
            JSONArray fields = field.getJSONArray("fields");
            if (fields != null) {
                EtlFieldSelectFormPluginHelper.buildRow(list, fields, id, fullNumber, presetFixMap, selectedList, filterList);
                field.put("isLeaf", (Object)false);
                continue;
            }
            field.put("isLeaf", (Object)true);
        }
    }

    public static List<Map<String, Object>> getFieldsByDataModel(Long dataModelId, List<String> selectedList, List<String> filterList) {
        Map presetFixMap = (Map)EPDMETLTaskConstant.PRESET_DM_FIX_MAPPING.get(dataModelId);
        JSONArray dataModelFields = DataModelServiceHelper.get().getDataModelFields(dataModelId);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        EtlFieldSelectFormPluginHelper.buildRow(list, dataModelFields, 0L, null, presetFixMap, selectedList, filterList);
        return list;
    }

    public static void fillData(List<Map<String, Object>> list, DynamicObjectCollection entryEntity) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            Map<String, Object> field = list.get(i);
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            dynamicObject.set("id", field.get("id"));
            dynamicObject.set("pid", field.get("pid"));
            dynamicObject.set("fullnumber", field.get("fullnumber"));
            dynamicObject.set("field", field.get("field"));
            dynamicObject.set("data_type", field.get("data_type"));
            dynamicObject.set("label", field.get("label"));
            dynamicObject.set("is_multiple", field.get("is_multiple"));
            dynamicObject.set("is_required", field.get("is_required"));
            dynamicObject.set("is_primary_key", field.get("is_primary_key"));
            dynamicObject.set("is_private", field.get("is_private"));
            dynamicObject.set("is_leaf", field.get("isLeaf"));
        }
    }

    public static void showFieldSelectorForm(AbstractFormPlugin form, IDataModel model, String modelName, String fieldKey, String entryName, int row) {
        IFormView view = form.getView();
        long modelId = IDataModelUtils.getDynamicObjectId((String)modelName, (IDataModel)model);
        if (modelId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6a21\u578b\u3002", (String)"EtlFieldSelectFormPluginHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            DynamicObjectCollection entryEntity;
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            HashMap<String, Integer> customData = new HashMap<String, Integer>(16);
            customData.put("$row", row);
            param.put("customData", customData);
            param.put("resourceId", modelId);
            if (null != fieldKey && null != (entryEntity = model.getEntryEntity(entryName)) && !entryEntity.isEmpty()) {
                List selectList = entryEntity.stream().map(o -> o.getString(fieldKey)).collect(Collectors.toList());
                param.put("selectList", selectList);
            }
            FormOpener.showForm((AbstractFormPlugin)form, (String)"epdm_etl_field_select", (String)"", param, (String)entryName);
        }
    }
}

