/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epdm.business.etl.IscxService;
import kd.epm.epdm.business.etl.vo.RunningConfig;
import kd.epm.epdm.business.etl.vo.RunningStatus;
import kd.epm.epdm.common.enums.ETLStatusEnum;

public class EtlRunningConfigService {
    public RunningStatus setRunningParams(RunningConfig conf) {
        if (null == conf) {
            return RunningStatus.build(500, null).setMessage(ResManager.loadKDString((String)"\u8fd0\u884c\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EtlRunningConfigService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        if (0L == conf.getTaskId()) {
            return RunningStatus.build(500, null).setMessage(ResManager.loadKDString((String)"\u8fd0\u884c\u914d\u7f6e\u53c2\u6570\u3010\u4efb\u52a1ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EtlRunningConfigService_2", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        try {
            QFilter filter = new QFilter("id", "=", (Object)conf.getTaskId());
            String select = "id, status, params.id, params.id, params.param_number, params.param_name, params.param_type, params.param_value, params.param_desc, params.ismultiple";
            DynamicObject update = BusinessDataServiceHelper.loadSingle((String)"epdm_etl_task", (String)select, (QFilter[])new QFilter[]{filter});
            if (null == update) {
                String message = String.format(ResManager.loadKDString((String)"ID\u4e3a\u3010%1$s\u3011\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"EtlRunningConfigService_3", (String)"epm-epbs-business", (Object[])new Object[0]), conf.getTaskId());
                return RunningStatus.build(500, null).setMessage(message);
            }
            String status = update.getString("status");
            if (ETLStatusEnum.Deployed.getNumber().equals(status) || ETLStatusEnum.Stopped.getNumber().equals(status)) {
                long id;
                IscxService iscxService;
                long deployId;
                DynamicObjectCollection dynamicObjects = this.setEntry("params", update, conf);
                if (!dynamicObjects.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{update});
                }
                if ((deployId = (iscxService = new IscxService()).start(id = update.getLong("id"))) > 0L) {
                    DynamicObject oState = BusinessDataServiceHelper.newDynamicObject((String)"epdm_etl_running_status");
                    oState.set("task", (Object)id);
                    oState.set("deployid", (Object)deployId);
                    oState.set("status", (Object)ETLStatusEnum.Running.getNumber());
                    oState.set("creater", (Object)UserUtils.getUserId());
                    oState.set("modifier", (Object)UserUtils.getUserId());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oState});
                }
                return RunningStatus.build(200, ETLStatusEnum.ToBeRunning);
            }
            String message = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u4e3a\u3010%1$s\u3011 \u4e0d\u53ef\u4fee\u6539\u3002", (String)"EtlRunningConfigService_4", (String)"epm-epbs-business", (Object[])new Object[0]), ETLStatusEnum.getName((String)status));
            return RunningStatus.build(400, null).setMessage(message);
        }
        catch (Exception e) {
            return RunningStatus.build(500, null, e.getMessage());
        }
    }

    private DynamicObjectCollection setEntry(String entryId, DynamicObject update, RunningConfig conf) {
        DynamicObjectCollection dynamicObjectCollection = update.getDynamicObjectCollection(entryId);
        ArrayList<DynamicObject> tmpList = new ArrayList<DynamicObject>();
        Map<String, RunningConfig.Param> paramMap = this.toMapParam(conf);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject sub = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            String number = dynamicObject.getString("param_number");
            if (paramMap.containsKey(number)) {
                sub.set("param_number", (Object)paramMap.get(number).getNumber());
                sub.set("param_name", (Object)paramMap.get(number).getName());
                sub.set("param_type", (Object)paramMap.get(number).getType());
                sub.set("param_value", paramMap.get(number).getValue());
                sub.set("param_desc", (Object)paramMap.get(number).getDesc());
                sub.set("ismultiple", (Object)dynamicObject.getString("ismultiple"));
            }
            tmpList.add(sub);
        }
        dynamicObjectCollection.clear();
        dynamicObjectCollection.addAll(tmpList);
        return dynamicObjectCollection;
    }

    private Map<String, RunningConfig.Param> toMapParam(RunningConfig conf) {
        HashMap<String, RunningConfig.Param> rs = new HashMap<String, RunningConfig.Param>(16);
        if (null == conf || null == conf.getParams()) {
            return rs;
        }
        conf.getParams().forEach(p -> rs.put(p.getNumber(), (RunningConfig.Param)p));
        return rs;
    }
}

