/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epdm.business.etl.vo.iscx.ConnectorItem;
import kd.epm.epdm.business.etl.vo.iscx.DataFlow;
import kd.epm.epdm.business.etl.vo.iscx.IscxRequest;
import kd.epm.epdm.business.etl.vo.iscx.field.FilterField;
import kd.epm.epdm.business.etl.vo.iscx.field.MappingEntry;
import kd.epm.epdm.business.etl.vo.iscx.field.OrderField;
import kd.epm.epdm.business.etl.vo.iscx.field.Param;
import kd.epm.epdm.business.etl.vo.iscx.field.QueryField;
import kd.epm.epdm.business.etl.vo.iscx.field.ResultField;
import kd.epm.epdm.business.etl.vo.iscx.flow.CatalogEnum;
import kd.epm.epdm.business.etl.vo.iscx.flow.DataLoadType;
import kd.epm.epdm.business.etl.vo.iscx.flow.EventModel;
import kd.epm.epdm.business.etl.vo.iscx.flow.FlowType;
import kd.epm.epdm.business.etl.vo.iscx.node.DataQuery;
import kd.epm.epdm.business.etl.vo.iscx.node.EntityAction;
import kd.epm.epdm.business.etl.vo.iscx.node.FieldMapping;
import kd.epm.epdm.business.etl.vo.iscx.node.InputParam;
import kd.epm.epdm.business.etl.vo.iscx.node.Manual;
import kd.epm.epdm.business.etl.vo.iscx.node.Node;
import kd.epm.epdm.business.etl.vo.iscx.node.NodeUtil;
import kd.epm.epdm.business.etl.vo.iscx.node.Notice;
import kd.epm.epdm.business.etl.vo.iscx.node.ScriptMapping;
import kd.epm.epdm.business.etl.vo.iscx.node.StatusCallback;
import kd.epm.epdm.business.etl.vo.iscx.node.TableAction;
import kd.epm.epdm.business.etl.vo.iscx.node.Timer;
import kd.epm.epdm.common.database.ModelUtils;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.enums.ETLStatusEnum;
import kd.epm.epdm.common.util.EtlUtil;
import kd.epm.epdm.common.util.LongUtil;
import kd.epm.epdm.common.util.MetadataUtil;

public class IscxService {
    private static final Log log = LogFactory.getLog(IscxService.class);
    private static final String EPM_ETL_QUEUE = "1959480839792249856";
    private static final String EPM_ETL_TOPIC_ID = "1959480839792249856";
    private final String remoteIscxMsService = "IscResourceBuildService";
    private final String remoteIscDataFlowService = "IscDataFlowService";
    private final String cloudId = "isc";
    private final String appId = "iscx";
    private static final Map<String, ETLStatusEnum> STATUS_MAP = new HashMap<String, ETLStatusEnum>(16);

    public static String getTrigger(String number) {
        if (number.startsWith("EPM_")) {
            return number;
        }
        return "EPM_" + number;
    }

    public Map<String, Object> callback(Map<String, Object> req) {
        HashMap<String, Object> res = new HashMap<String, Object>(2);
        res.put("message", "");
        res.put("code", 500);
        String opDesc = null != req ? JSON.toJSONString(req) : "{}";
        try {
            if (null != req && null != req.get("stream_id")) {
                long procInstId = LongUtil.toLong((String)req.get("stream_id").toString());
                QFilter filter = new QFilter("deployid", "=", (Object)procInstId);
                Map propertyToAlias = MetadataUtil.getAllProperties((String)"epdm_etl_running_status");
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"epdm_etl_running_status", (String)String.join((CharSequence)",", propertyToAlias.keySet()), (QFilter[])new QFilter[]{filter});
                DynamicObject obj = null;
                if (load.length > 0 && null != (obj = load[0]) && null != obj.getDynamicObject("task")) {
                    this.update(req, obj);
                    opDesc = opDesc + " - update";
                } else {
                    this.create(req);
                    opDesc = opDesc + " - create";
                }
                res.put("code", 200);
                if (null != obj) {
                    opDesc = opDesc + " - " + procInstId;
                }
            }
        }
        catch (Exception e) {
            res.put("message", e.getMessage());
            opDesc = opDesc + " - " + e.getMessage();
        }
        log.info(opDesc);
        return res;
    }

    private void update(Map<String, Object> req, DynamicObject obj) throws JsonProcessingException {
        obj.set("endtime", (Object)new Date());
        Date created = obj.getDate("createtime");
        long runtime = System.currentTimeMillis() - created.getTime();
        obj.set("runtime", (Object)EtlUtil.formatDuring((long)runtime));
        obj.set("status", (Object)STATUS_MAP.getOrDefault((String)req.get("state"), ETLStatusEnum.Error).getNumber());
        obj.set("state", req.get("state"));
        ObjectMapper mapper = new ObjectMapper();
        obj.set("statustext_tag", (Object)mapper.writeValueAsString(req));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    private void create(Map<String, Object> req) throws JsonProcessingException {
        DynamicObject oState = BusinessDataServiceHelper.newDynamicObject((String)"epdm_etl_running_status");
        oState.set("task", (Object)LongUtil.toLong((String)req.get("trigger_id").toString()));
        oState.set("deployid", (Object)LongUtil.toLong((String)req.get("stream_id").toString()));
        Date date = new Date();
        oState.set("createtime", (Object)date);
        oState.set("endtime", (Object)date);
        oState.set("runtime", (Object)EtlUtil.formatDuring((long)0L));
        oState.set("status", (Object)STATUS_MAP.getOrDefault((String)req.get("state"), ETLStatusEnum.Error).getNumber());
        oState.set("state", req.get("state"));
        ObjectMapper mapper = new ObjectMapper();
        oState.set("statustext_tag", (Object)mapper.writeValueAsString(req));
        oState.set("creater", (Object)UserUtils.getUserId());
        oState.set("modifier", (Object)UserUtils.getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oState});
    }

    public Map<String, Object> deploy(long taskId, FlowType flowType) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        IscxRequest request = this.buildRequest(taskId, flowType);
        String json = mapper.writeValueAsString((Object)request);
        Map req = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (Map)this.invokeBizService("IscResourceBuildService", "buildIscxDataTrigger", req);
    }

    public void tryTerminate(long procInstId) {
        this.invokeBizService("IscDataFlowService", "tryTerminate", procInstId);
    }

    public void enable(long taskId) {
        String triggerNumber = this.getTriggerNumber(taskId);
        if (StringUtils.isEmpty((String)triggerNumber)) {
            return;
        }
        if (QueryServiceHelper.exists((String)"iscx_data_flow_trigger", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)triggerNumber)})) {
            this.invokeBizService("IscDataFlowService", "enable", triggerNumber);
        }
    }

    public void disable(long taskId) {
        String triggerNumber = this.getTriggerNumber(taskId);
        if (StringUtils.isEmpty((String)triggerNumber)) {
            return;
        }
        if (QueryServiceHelper.exists((String)"iscx_data_flow_trigger", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)triggerNumber)})) {
            this.invokeBizService("IscDataFlowService", "disable", triggerNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAnyway(long taskId, int retry) {
        while (retry > 0) {
            try {
                this.disable(taskId);
                break;
            }
            catch (Exception e) {
                log.warn("[ISCX]" + e.getMessage());
                if (retry < 2) {
                    throw new KDBizException(e.getMessage());
                }
                try {
                    Thread.sleep(300L);
                }
                catch (Exception ex) {
                    throw new KDBizException(ex.getMessage());
                }
            }
            finally {
                --retry;
            }
        }
    }

    public long start(long taskId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        DynamicObject taskInfo = this.getTask(taskId);
        if (null == taskInfo) {
            return 0L;
        }
        DynamicObjectCollection paramObjects = taskInfo.getDynamicObjectCollection("params");
        if (!paramObjects.isEmpty()) {
            for (DynamicObject row : paramObjects) {
                params.put(row.getString("param_number"), row.get("param_value"));
            }
        }
        String number = this.getTriggerNumber(taskInfo);
        try {
            return (Long)this.invokeBizService("IscDataFlowService", "start", number, params);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u4fee\u6b63\u540e\u518d\u6267\u884c\u6570\u636e\u91c7\u96c6\u3002", (String)"IscxService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
    }

    public Map<String, Object> getState(long procInstId) {
        return (Map)this.invokeBizService("IscDataFlowService", "getState", procInstId);
    }

    public boolean retry(long procInstId) {
        return (Boolean)this.invokeBizService("IscDataFlowService", "retry", procInstId);
    }

    private <T> T invokeBizService(String serviceName, String methodName, Object ... paras) {
        return (T)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscx", (String)serviceName, (String)methodName, (Object[])paras);
    }

    private String getTriggerNumber(long taskId) {
        DynamicObject taskInfo = this.getTask(taskId);
        if (null == taskInfo) {
            return null;
        }
        return this.getTriggerNumber(taskInfo);
    }

    private String getTriggerNumber(DynamicObject taskInfo) {
        String number = taskInfo.getString("number");
        return IscxService.getTrigger(number);
    }

    public void updateNotice(long id) {
        DynamicObject noticeObj = this.getDynamicObjectById(id, "epdm_etl_notice_send");
        if (null != noticeObj) {
            QFilter filter = new QFilter("number", "like", (Object)("%_" + noticeObj.getString("number") + "_%"));
            filter.and(new QFilter("source_app", "=", (Object)"epm"));
            DynamicObject[] iscxResources = BusinessDataServiceHelper.load((String)"iscx_resource", (String)"id,number,name,details_tag", (QFilter[])new QFilter[]{filter});
            if (null != iscxResources && iscxResources.length > 0) {
                for (DynamicObject res : iscxResources) {
                    String number = res.getString("number");
                    if (!number.startsWith("EPM_")) continue;
                    JSONObject details = ModelUtils.getDataModelDetails((DynamicObject)res);
                    details.put("ierp_user_list", (Object)noticeObj.getString("ierp_user_list"));
                    String json = noticeObj.getString("ierp_user_json");
                    if (null != json && json.startsWith("{")) {
                        details.put("ierp_user_json", (Object)EtlUtil.toJSONObject((String)json));
                    } else if (null != json && json.startsWith("[")) {
                        details.put("ierp_user_json", (Object)EtlUtil.toJSONArray((String)json));
                    } else {
                        details.put("ierp_user_json", (Object)json);
                    }
                    details.put("ierp_user_expr", (Object)noticeObj.getString("ierp_user_expr"));
                    details.put("header", (Object)noticeObj.getString("header"));
                    details.put("content", (Object)noticeObj.getString("content"));
                    res.set("details_tag", (Object)("(" + details.toJSONString() + ")"));
                }
                SaveServiceHelper.update((DynamicObject[])iscxResources);
            }
        }
    }

    public IscxRequest buildRequest(long taskId, FlowType flowType) {
        this.initMqPublisher();
        DynamicObject taskInfo = this.getTask(taskId);
        this.addDefaultScript(taskInfo);
        IscxRequest request = new IscxRequest();
        NodeUtil.setBase(request, taskInfo, false);
        request.setEventType(flowType.getModel().getName());
        request.setMaxThreads(taskInfo.getInt("max_threads"));
        request.setWorkAreaSize(taskInfo.getInt("work_area_size"));
        request.setCheckpoint(taskInfo.getInt("checkpoint"));
        request.setMaxRetryTimes(taskInfo.getInt("max_retry_times"));
        request.setRetryInterval(taskInfo.getString("retry_interval"));
        request.setLogLevel(taskInfo.getString("log_level"));
        request.setStartNoticeMq("1959480839792249856");
        request.setEndNoticeMq("1959480839792249856");
        request.setStartMqTopic("1959480839792249856");
        request.setEndMqTopic("1959480839792249856");
        DynamicObject noticeObj = taskInfo.getDynamicObject("success_notice");
        if (null != noticeObj) {
            Notice successNotice = new Notice(CatalogEnum.NoticeSuccess);
            request.setSuccessNotice(successNotice);
            noticeObj = this.getDynamicObjectById(noticeObj.getLong("id"), "epdm_etl_notice_send");
            NodeUtil.setNotice(successNotice, noticeObj, request.getNumber());
        }
        if (null != (noticeObj = taskInfo.getDynamicObject("failed_notice"))) {
            Notice errorNotice = new Notice(CatalogEnum.NoticeError);
            request.setErrorNotice(errorNotice);
            noticeObj = this.getDynamicObjectById(noticeObj.getLong("id"), "epdm_etl_notice_send");
            NodeUtil.setNotice(errorNotice, noticeObj, request.getNumber());
        }
        request.setConnectorRef(new HashMap<String, String>(16));
        request.getConnectorRef().put("src", this.getConnectorItem(taskInfo, "linksrc", "src").getRef());
        request.getConnectorRef().put("tar", this.getConnectorItem(taskInfo, "linktar", "tar").getRef());
        request.setCallback(new StatusCallback());
        request.setCallbackFunction(new HashMap<String, String>(16));
        request.getCallbackFunction().put("id", "1944899105729920000");
        request.getCallbackFunction().put("is_referenced", "true");
        this.setDataFlow(request, taskInfo, flowType);
        return request;
    }

    private void addDefaultScript(DynamicObject taskInfo) {
        HashSet batchNoScriptDefault = Sets.newHashSet((Object[])new Long[]{DataModelPresetEnum.T_EPM_BALANCE.getId(), DataModelPresetEnum.T_EPM_VOUCHER.getId(), DataModelPresetEnum.T_EPM_CASHFLOW.getId()});
        Optional.ofNullable(taskInfo.getDynamicObject("datamodetar")).map(DataEntityBase::getPkValue).filter(batchNoScriptDefault::contains).ifPresent(tarDataModeId -> {
            String defaultScript = taskInfo.getString("default_script");
            if (StringUtils.isEmpty((String)defaultScript)) {
                taskInfo.set("default_script", (Object)"streamId_is_batchNo");
            }
            String defaultScriptTag = taskInfo.getString("default_script_tag");
            String newDefaultScriptTag = String.join((CharSequence)";", defaultScriptTag, "\ntar.fbatchno=$stream.stream_id;");
            taskInfo.set("default_script_tag", (Object)newDefaultScriptTag);
        });
    }

    private DynamicObject getTask(long id) {
        return this.getDynamicObjectById(id, "epdm_etl_task");
    }

    private DynamicObject getDynamicObjectById(long id, String entityName) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
    }

    private void setDataFlow(IscxRequest request, DynamicObject taskInfo, FlowType flowType) {
        DataFlow dataFlow = new DataFlow(CatalogEnum.FlowType);
        request.setDataFlow(dataFlow);
        NodeUtil.setBase(dataFlow, taskInfo, true);
        dataFlow.setConnectorItems(new ArrayList<ConnectorItem>());
        this.setConnectorItems(dataFlow.getConnectorItems(), taskInfo);
        HashMap<String, Map<String, String>> connSetting = new HashMap<String, Map<String, String>>(16);
        dataFlow.setConnectorSetting(connSetting);
        connSetting.put(flowType.getModel().getName(), new HashMap(16));
        ((Map)connSetting.get(flowType.getModel().getName())).put("$src", this.getConnectorItem(taskInfo, "linksrc", "src").getNumber());
        connSetting.put(flowType.getFieldMapping().getName(), new HashMap(16));
        ((Map)connSetting.get(flowType.getFieldMapping().getName())).put("$src", this.getConnectorItem(taskInfo, "linksrc", "src").getNumber());
        ((Map)connSetting.get(flowType.getFieldMapping().getName())).put("$tar", this.getConnectorItem(taskInfo, "linktar", "tar").getNumber());
        connSetting.put(flowType.getScriptMapping().getName(), new HashMap(16));
        ((Map)connSetting.get(flowType.getScriptMapping().getName())).put("$src", this.getConnectorItem(taskInfo, "linksrc", "src").getNumber());
        ((Map)connSetting.get(flowType.getScriptMapping().getName())).put("$tar", this.getConnectorItem(taskInfo, "linktar", "tar").getNumber());
        connSetting.put(flowType.getDataLoadType().getName(), new HashMap(16));
        ((Map)connSetting.get(flowType.getDataLoadType().getName())).put("$tar", this.getConnectorItem(taskInfo, "linktar", "tar").getNumber());
        dataFlow.setNodes(new HashMap<String, Node>(16));
        DataQuery dataQuery = new DataQuery(CatalogEnum.DataQuery);
        if (EventModel.EventModelManual == flowType.getModel()) {
            Manual manual = new Manual(CatalogEnum.EventModel);
            dataFlow.getNodes().put(flowType.getModel().getName(), manual);
            NodeUtil.setBase(manual, taskInfo, true);
            manual.setDataQuery(dataQuery);
        } else {
            Timer timer = new Timer(CatalogEnum.EventModel);
            dataFlow.getNodes().put(flowType.getModel().getName(), timer);
            NodeUtil.setBase(timer, taskInfo, true);
            timer.setDataQuery(dataQuery);
            timer.setSchedule(taskInfo.getString("schedule"));
        }
        NodeUtil.setDataBase(dataQuery, taskInfo);
        InputParam param = new InputParam(CatalogEnum.InputParam);
        param.setFields(new ArrayList<Param>(16));
        dataQuery.setParam(param);
        NodeUtil.setBase(param, taskInfo, true);
        DynamicObjectCollection objects = taskInfo.getDynamicObjectCollection("params");
        request.setParam(new HashMap<String, String>(8));
        if (null != objects && !objects.isEmpty()) {
            objects.forEach(obj -> {
                param.getFields().add(new Param().init((DynamicObject)obj));
                request.getParam().put(obj.getString("param_number"), obj.getString("param_value"));
            });
        }
        dataQuery.setQueryFields(new ArrayList<QueryField>(16));
        objects = taskInfo.getDynamicObjectCollection("result_fields");
        if (null != objects && !objects.isEmpty()) {
            objects.forEach(obj -> dataQuery.getQueryFields().add(new QueryField().init((DynamicObject)obj)));
        }
        objects = taskInfo.getDynamicObjectCollection("filters");
        dataQuery.setFilterFields(new ArrayList<FilterField>(16));
        if (null != objects && !objects.isEmpty()) {
            objects.forEach(obj -> dataQuery.getFilterFields().add(new FilterField().init((DynamicObject)obj)));
        }
        dataQuery.setOrderFields(new ArrayList<OrderField>(16));
        objects = taskInfo.getDynamicObjectCollection("order_by_fields");
        if (null != objects && !objects.isEmpty()) {
            objects.forEach(obj -> dataQuery.getOrderFields().add(new OrderField().init((DynamicObject)obj)));
        }
        FieldMapping fieldMapping = new FieldMapping(CatalogEnum.DataMapping);
        dataFlow.getNodes().put(flowType.getFieldMapping().getName(), fieldMapping);
        NodeUtil.setDataBase(fieldMapping, taskInfo);
        fieldMapping.setMappingEntries(new ArrayList<MappingEntry>(16));
        objects = taskInfo.getDynamicObjectCollection("mapping_entries");
        if (null != objects && !objects.isEmpty()) {
            QFilter filter = null;
            for (DynamicObject obj2 : objects) {
                if (null == filter) {
                    filter = new QFilter("number", "=", obj2.get("vc_rule"));
                } else {
                    filter.or(new QFilter("number", "=", obj2.get("vc_rule")));
                }
                fieldMapping.getMappingEntries().add(new MappingEntry().init(obj2));
            }
            String selectFields = "number,name,info,src_field,tar_field,def_value,type,script_remark,script,script_tag,class_name,constant_entity.src,constant_entity.tar,constant_entity.desc,fields_mapping.tar_column,fields_mapping.tar_desc,fields_mapping.fixed_value,fields_mapping.src_column,fields_mapping.src_desc";
            DynamicObject[] vcObjects = BusinessDataServiceHelper.load((String)"epdm_etl_vc_form", (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (null != vcObjects) {
                HashMap<String, DynamicObject> objectMap = new HashMap<String, DynamicObject>(vcObjects.length);
                for (DynamicObject obj3 : vcObjects) {
                    objectMap.put(obj3.getString("number"), obj3);
                }
                fieldMapping.getMappingEntries().forEach(entry -> entry.initVcRule(taskInfo, objectMap));
            }
        }
        ScriptMapping scriptMapping = new ScriptMapping(CatalogEnum.DataMapping);
        dataFlow.getNodes().put(flowType.getScriptMapping().getName(), scriptMapping);
        NodeUtil.setDataBase(scriptMapping, taskInfo);
        scriptMapping.setTimeout(taskInfo.getInt("timeout"));
        scriptMapping.setScriptTitle(taskInfo.getString("default_script"));
        scriptMapping.setScript(taskInfo.getString("default_script_tag"));
        if (flowType.getDataLoadType().getName().equals(DataLoadType.TableAction.getName())) {
            dataFlow.getNodes().put(flowType.getDataLoadType().getName(), this.getTableAction(taskInfo));
        } else if (flowType.getDataLoadType().getName().equals(DataLoadType.EntityAction.getName())) {
            dataFlow.getNodes().put(flowType.getDataLoadType().getName(), this.getEntityAction(taskInfo));
        }
        dataFlow.sort();
    }

    private TableAction getTableAction(DynamicObject taskInfo) {
        TableAction tAction = new TableAction(CatalogEnum.DataLoad);
        NodeUtil.setDataBase(tAction, taskInfo);
        if (null == taskInfo.getString("data_action")) {
            tAction.setDataAction("_SAVE");
        } else {
            tAction.setDataAction(taskInfo.getString("data_action"));
        }
        tAction.setBatchSize(Math.max(taskInfo.getInt("batch_size"), 1));
        tAction.setResultFields(new ArrayList<ResultField>());
        DynamicObjectCollection objects = taskInfo.getDynamicObjectCollection("tar_fields");
        if (null != objects && !objects.isEmpty()) {
            objects.forEach(obj -> tAction.getResultFields().add(new ResultField().init((DynamicObject)obj)));
        }
        return tAction;
    }

    private EntityAction getEntityAction(DynamicObject taskInfo) {
        EntityAction action = new EntityAction(CatalogEnum.DataLoad);
        NodeUtil.setDataBase(action, taskInfo);
        action.setAction("save");
        action.setResultFields(new ArrayList<ResultField>(16));
        DynamicObjectCollection objects = taskInfo.getDynamicObjectCollection("tar_fields");
        if (null != objects && !objects.isEmpty()) {
            objects.forEach(obj -> action.getResultFields().add(new ResultField().init((DynamicObject)obj)));
        }
        return action;
    }

    private void setConnectorItems(List<ConnectorItem> connectorItems, DynamicObject taskInfo) {
        connectorItems.add(this.getConnectorItem(taskInfo, "linksrc", "src"));
        connectorItems.add(this.getConnectorItem(taskInfo, "linktar", "tar"));
    }

    private ConnectorItem getConnectorItem(DynamicObject taskInfo, String linkId, String type) {
        ConnectorItem cItem = new ConnectorItem();
        DynamicObject subObj = taskInfo.getDynamicObject(linkId);
        cItem.setNumber(type);
        cItem.setName(subObj.getString("name"));
        cItem.setRef(subObj.getString("id"));
        cItem.setType(subObj.getDynamicObject("dum_link").getString("number"));
        return cItem;
    }

    public DynamicObject newMqServer() {
        DynamicObject mq_server = BusinessDataServiceHelper.newDynamicObject((String)"isc_mq_server");
        mq_server.set("id", (Object)9999L);
        mq_server.set("number", (Object)"InternalMQ");
        mq_server.set("name", (Object)ResManager.loadKDString((String)"\u5185\u90e8MQ", (String)"IscxService_2", (String)"epm-epbs-business", (Object[])new Object[0]));
        mq_server.set("type", (Object)"InternalRabbit");
        mq_server.set("status", (Object)"A");
        mq_server.set("enable", (Object)"1");
        mq_server.set("current_account", (Object)RequestContext.get().getAccountId());
        mq_server.set("creator", (Object)RequestContext.get().getCurrUserId());
        mq_server.set("modifier", (Object)RequestContext.get().getCurrUserId());
        return mq_server;
    }

    public DynamicObject newMqPublisher() {
        long mqPublisherId = LongUtil.toLong((String)"1959480839792249856");
        DynamicObject mqPublisher = BusinessDataServiceHelper.newDynamicObject((String)"isc_mq_publisher");
        mqPublisher.set("id", (Object)mqPublisherId);
        mqPublisher.set("group", (Object)9999L);
        mqPublisher.set("number", (Object)"fi.di");
        mqPublisher.set("name", (Object)ResManager.loadKDString((String)"EPM\u53cd\u5199", (String)"IscxService_3", (String)"epm-epbs-business", (Object[])new Object[0]));
        mqPublisher.set("isv", (Object)String.format(ResManager.loadKDString((String)"%1$s.\u7ee9\u6548\u670d\u52a1\u4e91", (String)"IscxService_4", (String)"epm-epbs-business", (Object[])new Object[0]), "kingdee"));
        mqPublisher.set("protect_level", (Object)"READ_ONLY");
        mqPublisher.set("format_script", (Object)ResManager.loadKDString((String)"\u7528\u4e8e\u7ee9\u6548\u670d\u52a1\u4e91\u91c7\u96c6\u4efb\u52a1\u56de\u8c03", (String)"IscxService_5", (String)"epm-epbs-business", (Object[])new Object[0]));
        mqPublisher.set("format_script_tag", (Object)"var data={\n\"consumerType\":\"msService\",\n\"cloudId\": \"epm\",\n\"appId\": \"epdm\",\n\"serviceName\":\"EtlCallbackService\",\n\"methodName\":\"iscxRunningStatus\",\n\"paras\":\n\t\t\t{\n\t\t\t\t\"ommitted\":$data.ommitted ,\n\t\t\t\t\"total\":$data.total ,\n\t\t\t\t\"trigger_number\":$data.trigger_number,\n\t\t\t\t\"stream_id\":$data.stream_id,\n\t\t\t\t\"success\":$data.success ,\n\t\t\t\t\"trigger_id\":$data.trigger_id,\n\t\t\t\t\"stream_number\":$data.stream_number,\n\t\t\t\t\"state\":$data.state,\n\t\t\t\t\"type\":$data.type,\n\t\t\t\t\"terminated\":$data.terminated\n\t\t\t}\n};\nreturn String.FormatJson(data);");
        mqPublisher.set("msg_digest", (Object)ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u7f16\u7801\uff1a#{$data.paras.trigger_number},\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\uff1a#{$data.paras.stream_number}", (String)"IscxService_6", (String)"epm-epbs-business", (Object[])new Object[0]));
        mqPublisher.set("charset", (Object)"UTF-8");
        mqPublisher.set("status", (Object)"C");
        mqPublisher.set("enable", (Object)0);
        mqPublisher.set("creator", (Object)RequestContext.get().getCurrUserId());
        mqPublisher.set("modifier", (Object)RequestContext.get().getCurrUserId());
        return mqPublisher;
    }

    private void initMqPublisher() {
        long mqPublisherId = LongUtil.toLong((String)"1959480839792249856");
        if (!QueryServiceHelper.exists((String)"isc_mq_publisher", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mqPublisherId)})) {
            if (!QueryServiceHelper.exists((String)"isc_mq_server", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)9999L)})) {
                DynamicObject mq_server = this.newMqServer();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mq_server});
            }
            DynamicObject mqPublisher = this.newMqPublisher();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mqPublisher});
            OperateOption option = OperateOption.create();
            OperationResult result = OperationServiceHelper.executeOperate((String)"enable", (String)"isc_mq_publisher", (Object[])new Object[]{mqPublisher.getLong("id")}, (OperateOption)option);
            if (!result.isSuccess()) {
                throw new KDBizException(result.getMessage());
            }
        }
    }

    static {
        STATUS_MAP.put("R", ETLStatusEnum.Running);
        STATUS_MAP.put("F", ETLStatusEnum.Error);
        STATUS_MAP.put("S", ETLStatusEnum.RUN_COMPLETE);
        STATUS_MAP.put("X", ETLStatusEnum.Stopped);
        STATUS_MAP.put("U", ETLStatusEnum.Error);
    }
}

