/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epdm.business.datamodel.helper.DataModelServiceHelper;
import kd.epm.epdm.common.constant.EPDMETLTaskConstant;
import kd.epm.epdm.common.enums.DataModelPresetEnum;

public class EPDMETLTaskHelper {
    public static final String NUMBER = "number";
    public static final String VALUE = "value";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String DESC = "desc";

    public static Map<String, String> getNumberNameMapById(Object pkValue) {
        QFilter qFilter = new QFilter("id", "=", pkValue);
        String number = "params.param_number";
        String name = "params.param_name";
        String selectFields = String.join((CharSequence)",", number, name);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epdm_etl_task", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return query.stream().filter(dy -> dy.getString(number) != null).collect(Collectors.toMap(dy -> dy.getString(number), dy -> dy.getString(name), (v1, v2) -> v1));
    }

    public static List<Map<String, Object>> getParamConfigById(long id, Consumer<Map<String, Object>> changeValueFunc) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        String number = "params.param_number";
        String name = "params.param_name";
        String type = "params.param_type";
        String desc = "params.param_desc";
        String value = "params.param_value";
        String selectFields = String.join((CharSequence)",", number, name, type, desc, value);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epdm_etl_task", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dynamicObject : query) {
            HashMap<String, String> fieldMap = new HashMap<String, String>(16);
            fieldMap.put(NUMBER, dynamicObject.getString(number));
            fieldMap.put(VALUE, dynamicObject.getString(value));
            fieldMap.put(NAME, dynamicObject.getString(name));
            fieldMap.put(TYPE, dynamicObject.getString(type));
            fieldMap.put(DESC, dynamicObject.getString(desc));
            changeValueFunc.accept(fieldMap);
            list.add(fieldMap);
        }
        return list;
    }

    private EPDMETLTaskHelper() {
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"EPDMETLTaskHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), this.getClass().getName());
        throw new IllegalStateException(msg);
    }

    public static List<JSONObject> getTarFields(DynamicObject dataModel) {
        long dataModelId = dataModel.getLong("id");
        DataModelPresetEnum dataModelPreset = DataModelPresetEnum.getDataModelPreset((Long)dataModelId);
        JSONArray dataModelFields = DataModelServiceHelper.get().getDataModelFields(dataModel);
        Map presetDmFixmap = (Map)EPDMETLTaskConstant.PRESET_DM_FIX_MAPPING.get(dataModelId);
        return EPDMETLTaskHelper.getTarFields(dataModelFields, presetDmFixmap, dataModelPreset != null, null);
    }

    public static List<JSONObject> getTarFields(JSONArray dataModelFields, Map<String, Object> presetDmFixmap, boolean isPreset, String parentFullNumber) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(10);
        for (Object dataModelField : dataModelFields) {
            JSONArray fields;
            JSONObject fieldObj = (JSONObject)dataModelField;
            String fullNumber = fieldObj.getString("field");
            if (parentFullNumber != null) {
                fullNumber = parentFullNumber + "." + fullNumber;
                fieldObj.put("field", (Object)fullNumber);
            }
            if ((fields = fieldObj.getJSONArray("fields")) != null) {
                list.addAll(EPDMETLTaskHelper.getTarFields(fields, presetDmFixmap, isPreset, fullNumber));
                continue;
            }
            if (isPreset) {
                if (presetDmFixmap != null && presetDmFixmap.containsKey(fullNumber)) continue;
                list.add(fieldObj);
                continue;
            }
            if (fieldObj.getBoolean("is_required") == null || !fieldObj.getBoolean("is_required").booleanValue()) continue;
            list.add(fieldObj);
        }
        return list;
    }
}

