/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl.helper;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.business.vo.FilterEntityKey;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.DbQueryUtils;
import kd.epm.epdm.common.database.IDataSource;
import kd.epm.epdm.common.database.ModelUtils;
import kd.epm.epdm.common.enums.CompareTypeEnum;
import kd.epm.epdm.common.enums.DBTypeEnum;
import kd.epm.epdm.common.enums.ResourceTypeEnum;
import kd.epm.epdm.common.util.IDataModelUtils;
import kd.epm.epdm.common.util.MetadataUtil;

public class EtlDataViewHelper {
    private static final Log log = LogFactory.getLog(EtlDataViewHelper.class);

    public static List<Map<String, Object>> select(long dblink, long model, Map<String, Integer> fieldMap, String where, String order) {
        AbsDataSource ds;
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)dblink, (String)"isc_database_link");
        if (null == cfg) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u94fe\u63a5\u65e0\u6548\u3002", (String)"EtlDataViewHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        if (!"S".equalsIgnoreCase(cfg.getString("state"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u94fe\u63a5[%1$s]\u72b6\u6001\u4e0d\u53ef\u7528\u3002", (String)"MainModelServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), cfg.getString("number")));
        }
        DynamicObject modelObject = BusinessDataServiceHelper.loadSingle((Object)model, (String)"epdm_dm");
        if (null == modelObject) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728\u3002", (String)"EtlDataViewHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        String type = null;
        DynamicObject typeObject = modelObject.getDynamicObject("type");
        if (null != typeObject) {
            type = typeObject.getString("number");
            if (!ResourceTypeEnum.DataTable.getNumber().equalsIgnoreCase(type) && !ResourceTypeEnum.DataView.getNumber().equalsIgnoreCase(type)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\uff08%2$s\uff09\u4e0d\u652f\u6301\u6570\u636e\u9884\u89c8\u3002", (String)"EtlDataViewHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]), modelObject.get("number"), type));
            }
        }
        if (!DBTypeEnum.exists((String)cfg.getString("database_type"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s\u201d\uff08%2$s\uff09\u4e0d\u652f\u6301\u6570\u636e\u9884\u89c8\u3002", (String)"EtlDataViewHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), cfg.get("database_type"), cfg.get("number")));
        }
        String dbRoute = null;
        if (StringUtils.isEmpty(dbRoute)) {
            dbRoute = MetadataUtil.getDBRoute((DynamicObject)modelObject).getRouteKey();
        }
        if (null == (ds = DbQueryUtils.getDataSource((DynamicObject)cfg, dbRoute))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s\u201d\uff08%2$s\uff09\uff0c\u83b7\u53d6\u6570\u636e\u94fe\u63a5\u5931\u8d25\u3002", (String)"EtlDataViewHelper_5", (String)"epm-epbs-business", (Object[])new Object[0]), cfg.get("name"), cfg.get("number")));
        }
        String table = modelObject.getString("number");
        if (StringUtils.isEmpty((String)table)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u65e0\u6548\u3002", (String)"EtlDataViewHelper_6", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        boolean isDataView = false;
        try {
            if (ResourceTypeEnum.DataView.getNumber().equalsIgnoreCase(type)) {
                isDataView = true;
                String sql = ModelUtils.getDataModelSql((DynamicObject)modelObject);
                int pos = sql.indexOf("@");
                if (pos > 1) {
                    String dbRout = EtlDataViewHelper.getString(sql, pos);
                    if (!StringUtils.isEmpty((String)dbRout)) {
                        ds.setDbRoute(new DBRoute(dbRout));
                    }
                    sql = sql.replace("@" + dbRout, "");
                }
                sql = "SELECT * FROM (" + sql + ") TV " + where + " " + order;
                return DbQueryUtils.select((IDataSource)ds, (String)sql, (boolean)true);
            }
            table = ModelUtils.getTableFormModel((DynamicObject)modelObject, (AbsDataSource)ds);
            if (!ds.tableExists(table, null)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201d%s\u201d\u8868/\u89c6\u56fe\u5728\u5f53\u524d\u8fde\u63a5\u914d\u7f6e\u4e2d\u4e0d\u5b58\u5728", (String)"DataModelServiceImpl_12", (String)"epm-epbs-mservice", (Object[])new Object[0]), table));
            }
            String sql = DbQueryUtils.buildSelectSQl((IDataSource)ds, (String)table, (String)ModelUtils.getSelectFields((DynamicObject)modelObject, null, fieldMap, null, (boolean)true), (String)where, null, (String)order, (int)100, (int)1);
            return DbQueryUtils.select((IDataSource)ds, (String)sql, (boolean)true);
        }
        catch (Exception e) {
            String message = isDataView ? String.format(ResManager.loadKDString((String)"\u89c6\u56fe[%s]\u5728\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e0d\u88ab\u517c\u5bb9\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"EtlDataViewHelper_12", (String)"epm-epbs-business", (Object[])new Object[0]), modelObject.getString("number")) : e.getMessage();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u9884\u89c8\u5931\u8d25\uff1a%s", (String)"EtlDataViewHelper_7", (String)"epm-epbs-business", (Object[])new Object[0]), message));
        }
    }

    private static String getString(String sql, int pos) {
        char c;
        String charSequence;
        String sqlEnd = sql.substring(pos + 1);
        int len = sqlEnd.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len && !" ".contentEquals(charSequence = String.valueOf(c = sqlEnd.charAt(i))) && !"\n".contentEquals(charSequence); ++i) {
            builder.append((CharSequence)charSequence);
        }
        return builder.toString();
    }

    public static String getOrderFromFilterEntity(DynamicObjectCollection orderEntity) {
        if (null != orderEntity && !orderEntity.isEmpty()) {
            StringBuilder orderBy = new StringBuilder();
            for (DynamicObject dy : orderEntity) {
                String sortField = dy.getString("sort_field");
                if (StringUtils.isEmpty((String)sortField)) continue;
                String sortMode = dy.getString("sort_mode");
                if (StringUtils.isEmpty((String)sortMode)) {
                    sortMode = "ASC";
                }
                if (orderBy.length() > 1) {
                    orderBy.append(",").append(sortField).append(" ").append(sortMode);
                    continue;
                }
                orderBy.append(" order by ").append(sortField).append(" ").append(sortMode);
            }
            return orderBy.toString();
        }
        return "";
    }

    public static String getWhereFromFilterEntity(DynamicObjectCollection filterEntity, FilterEntityKey entityKey) {
        if (null == entityKey) {
            entityKey = new FilterEntityKey("filter_column", "filter_compare", "filter_left_bracket", "filter_value_fixed", "filter_type", "filter_right_bracket", "filter_link", "isvar");
        }
        if (null != filterEntity && !filterEntity.isEmpty()) {
            StringBuilder where = new StringBuilder();
            String link = "";
            int size = filterEntity.size() - 1;
            block21: for (int idx = 0; idx <= size; ++idx) {
                String leftBracket;
                DynamicObject dy = (DynamicObject)filterEntity.get(idx);
                String field = dy.getString(entityKey.getField());
                String value = dy.getString(entityKey.getValue());
                if ("_blank()".equalsIgnoreCase(value)) {
                    value = " ";
                }
                if (!EtlDataViewHelper.isSafeFromSqlInjection(value)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u5b57\u7b26\u4e32\uff1a%s\u3002", (String)"EtlDataViewHelper_11", (String)"epm-epbs-business", (Object[])new Object[0]), value));
                }
                String valueType = dy.getString(entityKey.getValueType());
                String compare = dy.getString(entityKey.getCompare());
                CompareTypeEnum cType = CompareTypeEnum.get((String)compare);
                if (StringUtils.isEmpty((String)field) || D.x((Object)IDataModelUtils.getObjectValue((Object)dy, (String)entityKey.getIsVar())) || value.startsWith("<%") || value.endsWith("%>")) continue;
                switch (cType) {
                    case IS_NULL: 
                    case IS_NOT_NULL: {
                        break;
                    }
                    default: {
                        if (value.isEmpty()) continue block21;
                    }
                }
                if (where.length() < 1) {
                    where.append(" where ");
                }
                if (StringUtils.isEmpty((String)(leftBracket = dy.getString(entityKey.getLeftBracket())))) {
                    leftBracket = "";
                }
                where.append(leftBracket);
                if (StringUtils.isEmpty((String)valueType) || StringUtils.isEmpty((String)compare)) continue;
                if (link.equalsIgnoreCase("and") || link.equalsIgnoreCase("or")) {
                    where.append(" ").append(link).append(" ");
                    link = "";
                }
                switch (cType) {
                    case EQ: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) {
                            where.append(field).append("=").append(value);
                            break;
                        }
                        where.append(field).append("='").append(value).append("'");
                        break;
                    }
                    case GT: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) {
                            where.append(field).append(">").append(value);
                            break;
                        }
                        where.append(field).append(">'").append(value).append("'");
                        break;
                    }
                    case GTE: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) {
                            where.append(field).append(">=").append(value);
                            break;
                        }
                        where.append(field).append(">='").append(value).append("'");
                        break;
                    }
                    case LE: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) {
                            where.append(field).append("<").append(value);
                            break;
                        }
                        where.append(field).append("<'").append(value).append("'");
                        break;
                    }
                    case LTE: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) {
                            where.append(field).append("<=").append(value);
                            break;
                        }
                        where.append(field).append("<='").append(value).append("'");
                        break;
                    }
                    case NEQ: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) {
                            where.append(field).append("<>").append(value);
                            break;
                        }
                        where.append(field).append("<>'").append(value).append("'");
                        break;
                    }
                    case IN: {
                        int i;
                        if (EtlDataViewHelper.likeNumber(valueType, value)) {
                            where.append(field).append(" in (").append(value).append(")");
                            break;
                        }
                        String[] array = value.split(",");
                        for (i = 0; i < array.length; ++i) {
                            if (0 == i) {
                                where.append(field).append(" in ('").append(array[i]).append("'");
                                continue;
                            }
                            where.append(",'").append(array[i]).append("'");
                        }
                        where.append(")");
                        break;
                    }
                    case NOT_IN: {
                        int i;
                        if (EtlDataViewHelper.likeNumber(valueType, value)) {
                            where.append(field).append(" not in (").append(value).append(")");
                            break;
                        }
                        String[] array = value.split(",");
                        for (i = 0; i < array.length; ++i) {
                            if (0 == i) {
                                where.append(field).append(" not in ('").append(array[i]).append("'");
                                continue;
                            }
                            where.append(",'").append(array[i]).append("'");
                        }
                        where.append(")");
                        break;
                    }
                    case CONTAINS: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) break;
                        where.append(field).append(" like '%").append(value).append("%'");
                        break;
                    }
                    case IS_NULL: {
                        where.append(field).append(" is null ");
                        break;
                    }
                    case ENDS_WITH: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) break;
                        where.append(field).append(" like '%").append(value).append("'");
                        break;
                    }
                    case IS_NOT_NULL: {
                        where.append(field).append(" is not null ");
                        break;
                    }
                    case STARTS_WITH: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) break;
                        where.append(field).append(" like '").append(value).append("%'");
                        break;
                    }
                    case NOT_CONTAINS: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) break;
                        where.append(field).append(" not like '%").append(value).append("%'");
                        break;
                    }
                    case NOT_ENDS_WITH: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) break;
                        where.append(field).append(" not like '%").append(value).append("'");
                        break;
                    }
                    case NOT_STARTS_WITH: {
                        if (EtlDataViewHelper.likeNumber(valueType, value)) break;
                        where.append(field).append(" not like '").append(value).append("%'");
                    }
                }
                String rightBracket = dy.getString(entityKey.getRightBracket());
                if (StringUtils.isEmpty((String)rightBracket)) {
                    rightBracket = "";
                }
                where.append(rightBracket);
                link = dy.getString(entityKey.getLink());
                if (!StringUtils.isEmpty((String)link)) continue;
                link = "AND";
            }
            return where.toString();
        }
        return "";
    }

    public static boolean isSafeFromSqlInjection(String input) {
        if (input == null) {
            return true;
        }
        String sqlInjectionPattern = "(--)|(/\\*.*\\*/)|(\\b(SELECT|UPDATE|DELETE|INSERT|DROP|GRANT|ALTER|UNION|CREATE|EXEC|EXECUTE)\\b)|(\\b(OR|AND)\\b.*?\\b(\\W*?(=|<|>|LIKE|IN|IS)\\W*?)+)|(;)";
        Pattern pattern = Pattern.compile(sqlInjectionPattern, 2);
        return !pattern.matcher(input).find();
    }

    private static boolean likeNumber(String valueType, String value) {
        boolean flag;
        boolean bl = flag = valueType.equalsIgnoreCase("long") || valueType.equalsIgnoreCase("int") || valueType.equalsIgnoreCase("integer") || valueType.equalsIgnoreCase("double") || valueType.equalsIgnoreCase("float") || valueType.equalsIgnoreCase("number") || valueType.equalsIgnoreCase("bigint") || valueType.equalsIgnoreCase("bigdecimal") || valueType.equalsIgnoreCase("decimal");
        if (null == value) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EtlDataViewHelper_8", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        if (flag) {
            String[] array;
            if (StringUtils.isEmpty((String)value)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EtlDataViewHelper_8", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            int pos = value.indexOf(",");
            if (pos < 1 && !StringUtils.isNumeric((String)value)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6bd4\u8f83\u503c\u5fc5\u987b\u662f\u6570\u5b57\u7c7b\u578b\u7684\uff0c\u65e0\u6548\u503c\u4e3a\uff1a%s\u3002", (String)"EtlDataViewHelper_9", (String)"epm-epbs-business", (Object[])new Object[0]), value));
            }
            for (String s : array = value.split(",")) {
                if (!StringUtils.isEmpty((String)s) && StringUtils.isNumeric((String)s)) continue;
                if (StringUtils.isEmpty((String)s)) {
                    s = "NULL";
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6bd4\u8f83\u503c\u5fc5\u987b\u662f\u6570\u5b57\u7c7b\u578b\u7684\uff0c\u4f20\u5165\u503c\uff1a%1$s\uff0c \u65e0\u6548\u503c\u4e3a\uff1a%2$s\u3002", (String)"EtlDataViewHelper_10", (String)"epm-epbs-business", (Object[])new Object[0]), value, s));
            }
        }
        return flag;
    }
}

