/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epdm.business.etl.helper.MainModelServiceHelper;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.DDLWrapper;
import kd.epm.epdm.common.database.DbQueryUtils;
import kd.epm.epdm.common.enums.form.EpdmDatamodelEnum;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;
import kd.epm.epdm.common.enums.form.FromField;
import kd.epm.epdm.common.util.MetadataUtil;

public class MainModelCreateServiceHelper {
    private static final Log log = LogFactory.getLog(MainModelCreateServiceHelper.class);

    public static DynamicObject saveModel(Map<String, Object> params) {
        String tableName;
        DynamicObject dmObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)EpdmDatamodelEnum.getFormId()));
        List fields = EpdmDatamodelEnum.get().fields();
        for (FromField field : fields) {
            if (!params.containsKey(field.getName())) continue;
            dmObject.set(field.getName(), params.get(field.getName()));
        }
        if (!params.containsKey(EpdmDatamodelEnum.status.name())) {
            dmObject.set(EpdmDatamodelEnum.status.name(), (Object)"2");
        }
        if (!(StringUtils.isEmpty((String)(tableName = EpdmDatamodelEnum.table.getString(dmObject))) || tableName.startsWith("t_") || tableName.startsWith("T_"))) {
            dmObject.set(EpdmDatamodelEnum.table.name(), (Object)("t_" + tableName));
        }
        long modelId = IDService.get().genLongId();
        dmObject.set("id", (Object)modelId);
        List details = (List)params.get("details");
        DynamicObject[] dyFields = new DynamicObject[details.size()];
        fields = EpdmDmPresetEnum.get().fields();
        int i = 0;
        for (Map detail : details) {
            DynamicObject fieldObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)EpdmDmPresetEnum.getFormId()));
            for (FromField field : fields) {
                if (!detail.containsKey(field.getName())) continue;
                fieldObject.set(field.getName(), detail.get(field.getName()));
            }
            fieldObject.set(EpdmDmPresetEnum.mainmodel.name(), (Object)modelId);
            fieldObject.set(EpdmDmPresetEnum.modeltype.name(), (Object)"epdm");
            dyFields[i++] = fieldObject;
        }
        TXUtils.required(tx -> {
            DeleteServiceHelper.delete((String)EpdmDmPresetEnum.getFormId(), (QFilter[])new QFilter[]{new QFilter(EpdmDmPresetEnum.mainmodel.name(), "=", (Object)modelId)});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dmObject});
            SaveServiceHelper.save((DynamicObject[])dyFields);
        });
        return dmObject;
    }

    public static void createTable(long modelId, String linkNumber, String dbRoute) {
        String table;
        DynamicObject cfg = MainModelServiceHelper.getLink(linkNumber);
        AbsDataSource ds = DbQueryUtils.getDataSource((DynamicObject)cfg, (String)dbRoute);
        if (null == ds) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s\u201d\uff08%2$s\uff09\uff0c\u83b7\u53d6\u6570\u636e\u94fe\u63a5\u5931\u8d25\u3002", (String)"MainModelCreateServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), cfg.get("name"), cfg.get("number")));
        }
        ds.setDbRoute(MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()));
        DynamicObject dmObject = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)EpdmDatamodelEnum.getFormId());
        QFilter filter = new QFilter(EpdmDmPresetEnum.mainmodel.name(), "=", (Object)modelId);
        String selectFields = EpdmDmPresetEnum.get().selectFields();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)EpdmDmPresetEnum.getFormId(), (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (dynamicObjects.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b[%s]\u672a\u627e\u5230\u5b57\u6bb5\u5b9a\u4e49", (String)"MainModelCreateServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), EpdmDatamodelEnum.number.getString(dmObject)));
        }
        DDLWrapper ddlWrapper = DDLWrapper.factory((AbsDataSource)ds);
        if (ddlWrapper.tableExists(ds, table = dmObject.getString(EpdmDatamodelEnum.table.name()))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b[%s]\u5bf9\u5e94\u7684\u6570\u636e\u8868\u5df2\u7ecf\u5b58\u5728\u3002", (String)"MainModelCreateServiceHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]), EpdmDatamodelEnum.number.getString(dmObject)));
        }
        TXUtils.required(tx -> {
            String createSql = ddlWrapper.createTable(ds, table, dynamicObjects);
            log.info("Exec Success:" + createSql);
            dmObject.set(EpdmDatamodelEnum.tableexists.name(), (Object)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dmObject});
        });
        for (DynamicObject dy : dynamicObjects) {
            if (!EpdmDmPresetEnum.isprimary.getBoolean(dy).booleanValue()) continue;
            String createSql = ddlWrapper.createPk(ds, table, EpdmDmPresetEnum.field.getString(dy));
            log.info("Exec Success:" + createSql);
            break;
        }
        HashMap<String, List> idxFields = new HashMap<String, List>();
        for (DynamicObject dy : dynamicObjects) {
            String key = EpdmDmPresetEnum.idxname.getString(dy);
            if (StringUtils.isEmpty((String)key)) continue;
            if (!idxFields.containsKey(key)) {
                idxFields.put(key, new ArrayList());
            }
            ((List)idxFields.get(key)).add(dy);
        }
        if (!idxFields.isEmpty()) {
            idxFields.forEach((name, fields) -> {
                String createSql = ddlWrapper.createIndex(ds, dmObject.getString(EpdmDatamodelEnum.table.name()), fields, name);
                log.info("Exec Success:" + createSql);
            });
        }
    }

    public static boolean exists(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)EpdmDatamodelEnum.getFormId(), (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getDataModel(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.queryOne((String)EpdmDatamodelEnum.getFormId(), (String)EpdmDatamodelEnum.get().selectFields(), (QFilter[])new QFilter[]{filter});
    }
}

