/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl.mapping;

import kd.bos.dataentity.resource.ResManager;
import kd.epm.epdm.business.etl.mapping.IStringSimilarity;
import kd.epm.epdm.business.etl.mapping.JaccardSimilarity;
import kd.epm.epdm.business.etl.mapping.LongestCommonSubsquenceSimilarity;

public class StringSimilarityUtil {
    public static double calculateSimilarity(String algorithm, CharSequence left, CharSequence right) {
        IStringSimilarity similarity = StringSimilarityUtil.findSimilarityAlgorithm(algorithm);
        return similarity.calculate(left, right);
    }

    public static IStringSimilarity findSimilarityAlgorithm(String algorithm) {
        if (algorithm == null) {
            return LongestCommonSubsquenceSimilarity.INSTANCE;
        }
        return StringSimilarityUtil.innerFindSimilarityAlgorithm(algorithm);
    }

    private static IStringSimilarity innerFindSimilarityAlgorithm(String algorithm) {
        if ("Jaccard".equals(algorithm)) {
            return JaccardSimilarity.INSTANCE;
        }
        if ("LongestCommonSubsquence".equals(algorithm)) {
            return LongestCommonSubsquenceSimilarity.INSTANCE;
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u4e32\u76f8\u4f3c\u5ea6\u7b97\u6cd5\uff1a%1$s\u3002", (String)"StringSimilarityUtil_1", (String)"epm-epbs-business", (Object[])new Object[0]), algorithm));
    }
}

