/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl.vo.iscx.field;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.epm.epdm.business.etl.vo.iscx.field.IField;
import kd.epm.epdm.common.enums.CompareTypeEnum;

public class FilterField
implements IField {
    private String id;
    @JsonProperty(value="filter_link")
    private String link;
    @JsonProperty(value="filter_label")
    private String label;
    @JsonProperty(value="filter_value_fixed")
    private String valueFixed;
    @JsonProperty(value="filter_column")
    private String column;
    @JsonProperty(value="filter_compare")
    private String compare;
    @JsonProperty(value="filter_left_bracket")
    private String leftBracket;
    @JsonProperty(value="filter_right_bracket")
    private String rightBracket;

    @Override
    public FilterField init(DynamicObject obj) {
        this.setId(obj.getString("id"));
        this.setLink(obj.getString("filter_link"));
        this.setLabel(obj.getString("filter_label"));
        this.setColumn(obj.getString("filter_column"));
        if (obj.getBoolean("isvar")) {
            if (StringUtils.isEmpty((String)obj.getString("filter_value_fixed")) || !obj.getString("filter_value_fixed").startsWith("<%")) {
                CompareTypeEnum compareType = CompareTypeEnum.get((String)obj.getString("filter_compare"));
                String value = (obj.getString("filter_column") + "_" + compareType.name()).toLowerCase(Locale.ROOT);
                if (!StringUtils.isEmpty((String)value)) {
                    value = value.replace(".", "_");
                }
                value = "<%" + value + "%>";
                this.setValueFixed(value);
            } else {
                this.setValueFixed(obj.getString("filter_value_fixed"));
            }
        } else {
            this.setValueFixed(obj.getString("filter_value_fixed"));
        }
        this.setCompare(obj.getString("filter_compare"));
        this.setLeftBracket(obj.getString("filter_left_bracket"));
        this.setRightBracket(obj.getString("filter_right_bracket"));
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValueFixed() {
        return this.valueFixed;
    }

    public void setValueFixed(String valueFixed) {
        this.valueFixed = valueFixed;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getCompare() {
        return this.compare;
    }

    public void setCompare(String compare) {
        this.compare = compare;
    }

    public String getLeftBracket() {
        return this.leftBracket;
    }

    public void setLeftBracket(String leftBracket) {
        this.leftBracket = leftBracket;
    }

    public String getRightBracket() {
        return this.rightBracket;
    }

    public void setRightBracket(String rightBracket) {
        this.rightBracket = rightBracket;
    }
}

