/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl.vo.iscx.field;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.epdm.business.etl.vo.iscx.field.IField;
import kd.epm.epdm.business.etl.vo.iscx.flow.CatalogEnum;
import kd.epm.epdm.business.etl.vo.iscx.flow.VcRuleType;
import kd.epm.epdm.business.etl.vo.iscx.node.ConstLookupTable;
import kd.epm.epdm.business.etl.vo.iscx.node.JavaRule;
import kd.epm.epdm.business.etl.vo.iscx.node.NodeUtil;
import kd.epm.epdm.business.etl.vo.iscx.node.ScriptRule;
import kd.epm.epdm.business.etl.vo.iscx.node.SqlRule;
import kd.epm.epdm.business.etl.vo.iscx.node.ValueConvertRule;

public class MappingEntry
implements IField {
    @JsonProperty(value="vc_number")
    private String vcNumber;
    @JsonProperty(value="vc_rule")
    private ValueConvertRule vcRule;
    @JsonProperty(value="aggr_fn")
    private String aggrFn;
    @JsonProperty(value="fixed_value")
    private String fixedValue;
    @JsonProperty(value="tar_column")
    private String tarColumn;
    @JsonProperty(value="tar_desc")
    private String tarDesc;
    @JsonProperty(value="src_column")
    private String srcColumn;
    @JsonProperty(value="src_desc")
    private String srcDesc;
    @JsonProperty(value="vc_rule_type")
    private String ruleType;

    @Override
    public MappingEntry init(DynamicObject obj) {
        this.setTarColumn(obj.getString("tar_column"));
        this.setTarDesc(obj.getString("tar_desc"));
        this.setFixedValue(obj.getString("fixed_value"));
        this.setSrcColumn(obj.getString("src_column"));
        this.setSrcDesc(obj.getString("src_desc"));
        this.setAggrFn(obj.getString("aggr_fn"));
        this.setVcNumber(obj.getString("vc_rule"));
        return this;
    }

    public void initVcRule(DynamicObject task, Map<String, DynamicObject> ruleMap) {
        String number = this.getVcNumber();
        if (ruleMap.containsKey(number)) {
            String type;
            DynamicObject obj = ruleMap.get(number);
            switch (type = obj.getString("type")) {
                case "constant": {
                    this.setRuleType(VcRuleType.ConstLookupTable.getName());
                    ConstLookupTable constLookupTable = new ConstLookupTable(CatalogEnum.DataMapping);
                    this.setVcRule(constLookupTable);
                    NodeUtil.setValueConvertRule(this.getVcRule(), task, obj);
                    DynamicObjectCollection tlbs = obj.getDynamicObjectCollection("constant_entity");
                    if (null == tlbs || tlbs.isEmpty()) break;
                    StringBuilder tlb_tag = new StringBuilder();
                    for (DynamicObject tlb : tlbs) {
                        if (tlb_tag.length() < 2) {
                            tlb_tag.append(tlb.getString("src")).append(':').append(tlb.getString("tar"));
                            continue;
                        }
                        tlb_tag.append("\n").append(tlb.getString("src")).append(':').append(tlb.getString("tar"));
                    }
                    constLookupTable.setTlbTag(tlb_tag.toString());
                    break;
                }
                case "SQL": {
                    this.setRuleType(VcRuleType.SQLRule.getName());
                    SqlRule sqlRule = new SqlRule(CatalogEnum.DataMapping);
                    this.setVcRule(sqlRule);
                    NodeUtil.setValueConvertRule(this.getVcRule(), task, obj);
                    sqlRule.setSql(obj.getString("script_tag"));
                    sqlRule.setSqlTitle(obj.getString("script"));
                    break;
                }
                case "script": {
                    this.setRuleType(VcRuleType.ScriptRule.getName());
                    ScriptRule scriptRule = new ScriptRule(CatalogEnum.DataMapping);
                    this.setVcRule(scriptRule);
                    NodeUtil.setValueConvertRule(this.getVcRule(), task, obj);
                    scriptRule.setScript(obj.getString("script_tag"));
                    scriptRule.setScriptTitle(obj.getString("script"));
                    break;
                }
                case "java": {
                    this.setRuleType(VcRuleType.JavaRule.getName());
                    JavaRule javaRule = new JavaRule(CatalogEnum.DataMapping);
                    this.setVcRule(javaRule);
                    NodeUtil.setValueConvertRule(this.getVcRule(), task, obj);
                    javaRule.setClassName(obj.getString("class_name"));
                    break;
                }
            }
        }
    }

    public String getVcNumber() {
        return this.vcNumber;
    }

    public void setVcNumber(String vcNumber) {
        this.vcNumber = vcNumber;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public ValueConvertRule getVcRule() {
        return this.vcRule;
    }

    public void setVcRule(ValueConvertRule vcRule) {
        this.vcRule = vcRule;
    }

    public String getAggrFn() {
        return this.aggrFn;
    }

    public void setAggrFn(String aggrFn) {
        this.aggrFn = aggrFn;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public String getTarColumn() {
        return this.tarColumn;
    }

    public void setTarColumn(String tarColumn) {
        this.tarColumn = tarColumn;
    }

    public String getTarDesc() {
        return this.tarDesc;
    }

    public void setTarDesc(String tarDesc) {
        this.tarDesc = tarDesc;
    }

    public String getSrcColumn() {
        return this.srcColumn;
    }

    public void setSrcColumn(String srcColumn) {
        this.srcColumn = srcColumn;
    }

    public String getSrcDesc() {
        return this.srcDesc;
    }

    public void setSrcDesc(String srcDesc) {
        this.srcDesc = srcDesc;
    }
}

