/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.etl.vo.iscx.node;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.Pair;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epdm.business.etl.vo.iscx.Base;
import kd.epm.epdm.business.etl.vo.iscx.node.DataBase;
import kd.epm.epdm.business.etl.vo.iscx.node.Notice;
import kd.epm.epdm.business.etl.vo.iscx.node.ValueConvertRule;

public class NodeUtil {
    public static final String NUMBER_PRE = "EPM_";

    public static void setNotice(Notice notice, DynamicObject noticeObj, String etlNumber) {
        notice.setSourceApp("epm");
        String number = etlNumber + "_" + noticeObj.getString("number") + "_" + notice.getCatalogType().name();
        if (!number.startsWith(NUMBER_PRE)) {
            number = NUMBER_PRE + number;
        }
        notice.setNumber(number);
        notice.setName(noticeObj.getString("name"));
        DynamicObject object = noticeObj.getDynamicObject("data_model");
        if (null != object) {
            notice.setDataModel(object.getLong("id") + "");
        }
        notice.setUserExpr(noticeObj.getString("ierp_user_expr"));
        notice.setHeader(noticeObj.getString("header"));
        notice.setContent(noticeObj.getString("content"));
        String json = noticeObj.getString("ierp_user_json");
        notice.setUsers(new HashMap<String, String>(16));
        List users = JSON.parseArray((String)json, Pair.class);
        if (null != users) {
            for (Pair pair : users) {
                notice.getUsers().put(pair.getKey() + "", (String)pair.getValue());
            }
        }
    }

    public static void setBase(Base base, DynamicObject taskInfo, boolean newId) {
        if (newId) {
            base.setId(GlobalIdUtil.genGlobalLongId() + "");
        } else {
            base.setId(taskInfo.getLong("id") + "");
        }
        base.setSourceApp("epm");
        String number = taskInfo.getString("number");
        if (!number.startsWith(NUMBER_PRE)) {
            number = NUMBER_PRE + number;
        }
        if (!StringUtils.isEmpty((String)base.getCatalogType().getNumber())) {
            base.setNumber(number + "_" + base.getCatalogType().name() + "_" + base.getNodeClassType());
        } else {
            base.setNumber(number);
        }
        base.setStep(base.getCatalogType().getStep());
        base.setName(taskInfo.getString("name"));
        base.setRemark(taskInfo.getString("remark"));
    }

    public static void setDataBase(DataBase dataBase, DynamicObject taskInfo) {
        NodeUtil.setBase(dataBase, taskInfo, true);
        if (dataBase.getCatalogType().name().equals("DataLoad")) {
            DynamicObject subObj = taskInfo.getDynamicObject("datamodetar");
            dataBase.setInput(subObj.getLong("id") + "");
            dataBase.setOutput("0");
        } else if (dataBase.getCatalogType().name().equals("DataQuery")) {
            DynamicObject subObj = taskInfo.getDynamicObject("datamodesrc");
            dataBase.setInput("0");
            dataBase.setOutput(subObj.getLong("id") + "");
        } else {
            DynamicObject subObj = taskInfo.getDynamicObject("datamodesrc");
            dataBase.setInput(subObj.getLong("id") + "");
            subObj = taskInfo.getDynamicObject("datamodetar");
            dataBase.setOutput(subObj.getLong("id") + "");
        }
    }

    public static void setValueConvertRule(ValueConvertRule vcRule, DynamicObject task, DynamicObject vcObj) {
        NodeUtil.setDataBase(vcRule, task);
        vcRule.setSrcField(vcObj.getString("src_field"));
        vcRule.setTarField(vcObj.getString("tar_field"));
        vcRule.setDefValue(vcObj.getString("def_value"));
        vcRule.setNumber(NUMBER_PRE + task.getString("number") + "_" + vcObj.getString("number"));
    }
}

