/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.importscheme;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.thread.EpbsFuture;
import kd.epm.epbs.common.util.ThrowableHelper;
import kd.epm.epdm.business.importscheme.EPDMImportData;
import kd.epm.epdm.business.importscheme.EPDMImportException;
import kd.epm.epdm.business.importscheme.EPDMImportField;
import kd.epm.epdm.business.importscheme.EPDMImportFieldGroup;
import kd.epm.epdm.business.importscheme.EPDMImportInfo;
import kd.epm.epdm.business.importscheme.EPDMImportSchemeHelper;
import kd.epm.epdm.common.constant.EPDMConstant;
import kd.epm.epdm.common.constant.EPDMImportLogConstant;
import kd.epm.epdm.common.constant.EPMDBalanceConstant;
import kd.epm.epdm.common.constant.EPMDVoucherDescConstant;
import kd.epm.epdm.common.enums.DataModelFieldDataTypeEnum;
import kd.epm.epdm.common.enums.DataModelPresetEnum;

public abstract class EPDMAbstractImportService {
    private static final Log LOG = LogFactory.getLog(EPDMAbstractImportService.class);
    private String insertSql;
    private String updateSql;
    private String querySql;
    private final List<Object[]> insertParams = new ArrayList<Object[]>(16);
    private final List<Object[]> updateParams = new ArrayList<Object[]>(16);
    private final Object schemeId;
    private final long logId;
    private final IAppCache appCache;
    private final EPDMImportInfo info = new EPDMImportInfo();
    private final LinkedBlockingQueue<EPDMImportData> dataQueue = new LinkedBlockingQueue();
    private final Map<Integer, Collection<String>> logDesc = new HashMap<Integer, Collection<String>>(16);
    public static final Map<Long, Map<String, Supplier<String>>> DEFAULT_FIELD = new HashMap<Long, Map<String, Supplier<String>>>();

    public abstract void resolveFile(String var1, String var2, Consumer<EPDMImportData> var3);

    public void doImport(EPDMImportFieldGroup fieldGroup, String importType) {
        ArrayList<EPDMImportData> c = new ArrayList<EPDMImportData>();
        while (this.checkoutData(c, 1) && c.isEmpty()) {
        }
        if (c.isEmpty()) {
            throw new EPDMImportException(ResManager.loadKDString((String)"\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bfb\u53d6\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a\u3002", (String)"EPDMAbstractImportService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
        }
        EPDMImportData headData = c.get(0);
        Map<Integer, String> data = headData.getData();
        List<EPDMImportField> allField = fieldGroup.getAllField();
        UniqueCheck uniqueKeyCheck = new UniqueCheck();
        UniqueCheck uniqueCandidateCheck = new UniqueCheck();
        while (this.checkoutData(c, 1000)) {
            for (EPDMImportData importData : c) {
                String string;
                String format;
                int sqlIndex;
                Map<Integer, String> map = importData.getData();
                LinkedHashSet<String> msg = new LinkedHashSet<String>(map.size());
                String[] paramString = new String[allField.size()];
                for (EPDMImportField ePDMImportField : allField) {
                    String valueStr = ePDMImportField.getValue(map);
                    sqlIndex = ePDMImportField.getSqlIndex();
                    paramString[sqlIndex] = valueStr;
                }
                if (fieldGroup.isPrKeyInCandidateFieldList() || fieldGroup.isPkInField()) {
                    format = ResManager.loadKDString((String)"\u4e3b\u952e\u4e0e\u7b2c%1$s\u884c\u76f8\u540c\uff0c\u5df2\u5ffd\u7565\u3002", (String)"EPDMAbstractImportService_2", (String)"epm-epbs-business", (Object[])new Object[0]);
                    uniqueKeyCheck.check(importData, msg, paramString, format, fieldGroup.getPkFieldList());
                }
                if (!fieldGroup.isPrKeyInCandidateFieldList()) {
                    format = ResManager.loadKDString((String)"\u5019\u9009\u952e\u4e0e\u7b2c%1$s\u884c\u76f8\u540c\uff0c\u5df2\u5ffd\u7565\u3002", (String)"EPDMAbstractImportService_3", (String)"epm-epbs-business", (Object[])new Object[0]);
                    uniqueCandidateCheck.check(importData, msg, paramString, format, fieldGroup.getCandidateFieldList());
                }
                Object[] param = new Object[allField.size()];
                for (EPDMImportField importField3 : allField) {
                    sqlIndex = importField3.getSqlIndex();
                    String valueStr = paramString[sqlIndex];
                    Object value = importField3.conversionValue(valueStr);
                    if (valueStr != null && value == null) {
                        String field = importField3.getField();
                        String colIndex = importField3.getFieldColIndex();
                        String caption = data.get(importField3.getColIndex() - 1);
                        msg.add(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u5217\u6620\u5c04%1$s\u5bf9\u5e94\u6587\u4ef6\u4e2d\u7b2c%2$s\u5217\uff08\u5217\u540d%3$s\uff09[\u503c%4$s]\u4e0e\u6570\u636e\u8868\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"EPDMAbstractImportService_4", (String)"epm-epbs-business", (Object[])new Object[0]), field, colIndex, caption, valueStr));
                    }
                    param[sqlIndex] = value;
                }
                if (msg.isEmpty() && (string = this.checkDBData(fieldGroup, param, importType)) != null) {
                    msg.add(string);
                }
                if (msg.isEmpty()) continue;
                this.logFail(importData.getRowIndex() + 1, msg);
            }
        }
        this.doUpdate(!this.updateParams.isEmpty());
        this.doInsert(!this.insertParams.isEmpty());
    }

    private String checkDBData(EPDMImportFieldGroup fieldGroup, Object[] param, String importType) {
        block35: {
            List<EPDMImportField> candidateFieldList = fieldGroup.getCandidateFieldList();
            List<EPDMImportField> pkFieldList = fieldGroup.getPkFieldList();
            List<EPDMImportField> qfFieldList = candidateFieldList.isEmpty() ? pkFieldList : candidateFieldList;
            Object[] queryParam = new Object[qfFieldList.size()];
            for (int i = 0; i < qfFieldList.size(); ++i) {
                EPDMImportField importField = qfFieldList.get(i);
                queryParam[i] = param[importField.getSqlIndex()];
            }
            boolean pkInField = fieldGroup.isPkInField();
            try (DataSet rows = DB.queryDataSet((String)this.querySql, (DBRoute)EPDMConstant.DB_ROUTE, (String)this.querySql, (Object[])queryParam);){
                Row row2;
                if (EPDMImportLogConstant.ImportTypeEnum.OVERRIDE.getNumber().equals(importType)) {
                    if (rows.hasNext()) {
                        row2 = rows.next();
                        for (EPDMImportField importField : pkFieldList) {
                            String field = importField.getField();
                            int sqlIndex = importField.getSqlIndex();
                            Object oldKey = param[sqlIndex];
                            Object newKey = row2.get(field);
                            if (!pkInField) {
                                param[sqlIndex] = newKey;
                                continue;
                            }
                            if (String.valueOf(oldKey).equals(String.valueOf(newKey))) continue;
                            String string = String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5019\u9009\u952e\u5728\u6570\u636e\u8868\u4e2d\u67e5\u5f97\u7684\u6570\u636e%1$s\uff0c\u4e0e\u4e3b\u952e%2$s\u5728\u6587\u4ef6\u4e2d\u6620\u5c04\u7684\u7b2c%3$s\u5217\u503c\u3010%4$s\u3011\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"EPDMAbstractImportService_5", (String)"epm-epbs-business", (Object[])new Object[0]), newKey, field, importField.getFieldColIndex(), oldKey);
                            return string;
                        }
                        this.updateParams.add(param);
                        break block35;
                    }
                    String row2 = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6ee1\u8db3\u5019\u9009\u952e\u7684\u6570\u636e\uff0c\u8986\u76d6\u5931\u8d25\u3002", (String)"EPDMAbstractImportService_6", (String)"epm-epbs-business", (Object[])new Object[0]);
                    return row2;
                }
                if (EPDMImportLogConstant.ImportTypeEnum.OVERRIDE_NEW.getNumber().equals(importType)) {
                    if (rows.hasNext()) {
                        row2 = rows.next();
                        for (EPDMImportField importField : pkFieldList) {
                            String field = importField.getField();
                            int sqlIndex = importField.getSqlIndex();
                            Object oldKey = param[sqlIndex];
                            Object newKey = row2.get(field);
                            if (!pkInField) {
                                param[sqlIndex] = newKey;
                                continue;
                            }
                            if (oldKey.equals(newKey)) continue;
                            String string = String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5019\u9009\u952e\u5728\u6570\u636e\u8868\u4e2d\u67e5\u5f97\u7684\u6570\u636e%1$s\uff0c\u4e0e\u4e3b\u952e%2$s\u5728\u6587\u4ef6\u4e2d\u6620\u5c04\u7684\u7b2c%3$s\u5217\u503c\u3010%4$s\u3011\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"EPDMAbstractImportService_5", (String)"epm-epbs-business", (Object[])new Object[0]), newKey, field, importField.getFieldColIndex(), oldKey);
                            return string;
                        }
                        this.updateParams.add(param);
                        break block35;
                    }
                    this.insertParams.add(param);
                    break block35;
                }
                if (EPDMImportLogConstant.ImportTypeEnum.NEW_ADD.getNumber().equals(importType)) {
                    if (rows.hasNext()) {
                        String string = ResManager.loadKDString((String)"\u5b58\u5728\u6ee1\u8db3\u5019\u9009\u952e\u7684\u6570\u636e\uff0c\u65b0\u589e\u5931\u8d25\u3002", (String)"EPDMAbstractImportService_7", (String)"epm-epbs-business", (Object[])new Object[0]);
                        return string;
                    }
                    this.insertParams.add(param);
                }
            }
        }
        this.doUpdate(this.updateParams.size() > 1000);
        this.doInsert(this.insertParams.size() > 1000);
        return null;
    }

    private void doUpdate(boolean isSave) {
        if (isSave) {
            DB.executeBatch((DBRoute)EPDMConstant.DB_ROUTE, (String)this.updateSql, this.updateParams);
            this.updateParams.clear();
        }
    }

    private void doInsert(boolean isSave) {
        if (isSave) {
            DB.executeBatch((DBRoute)EPDMConstant.DB_ROUTE, (String)this.insertSql, this.insertParams);
            this.insertParams.clear();
        }
    }

    public static String getSuspendKey(Object schemeId, String logId) {
        return "IMPT_SUSPEND_" + schemeId + "_" + logId;
    }

    protected EPDMAbstractImportService(IAppCache appCache, Object schemeId, long logId) {
        this.appCache = appCache;
        this.schemeId = schemeId;
        this.logId = logId;
    }

    public void doImport(String filePath, String importType) {
        EpbsFuture queryConfigFuture = EpbsFuture.supplyAsync(() -> EPDMImportSchemeHelper.queryConfigById(this.schemeId));
        queryConfigFuture.exceptionally(ex -> {
            LOG.error(ex.getMessage(), ex);
            try {
                this.afterException((Throwable)ex);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.info.setHasException(true);
            this.importComplete();
            this.clearCache();
            return null;
        });
        EpbsFuture resolveFuture = queryConfigFuture.thenAcceptAsync(schemeObject -> {
            String sheet = schemeObject.getString("sheet");
            int startRowIndex = schemeObject.getInt("startrow");
            int startRowFromZero = startRowIndex - 1;
            Consumer consumerRow = data -> {
                if (this.info.isStopResolve()) {
                    return;
                }
                if (data.getRowIndex() > startRowFromZero) {
                    this.info.setTotal(this.info.getTotal() + 1);
                }
                if (data.getRowIndex() >= startRowFromZero) {
                    data.setDataIndex(data.getRowIndex() - startRowFromZero - 1);
                    this.pull((EPDMImportData)data);
                }
            };
            this.resolveFile(filePath, sheet, (Consumer<EPDMImportData>)consumerRow);
            this.info.setResolveComplete(true);
        });
        resolveFuture.exceptionally(ex -> {
            LOG.error(ex.getMessage(), ex);
            try {
                this.afterException((Throwable)ex);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.info.setHasException(true);
            this.importComplete();
            this.clearCache();
            return null;
        });
        EpbsFuture importFuture = queryConfigFuture.thenAcceptAsync(schemeObject -> {
            EPDMImportFieldGroup config = this.buildImportConfig((DynamicObject)schemeObject);
            this.doImport(config, importType);
            this.importComplete();
        });
        importFuture.exceptionally(ex -> {
            LOG.error(ex.getMessage(), ex);
            try {
                this.afterException((Throwable)ex);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.info.setHasException(true);
            this.importComplete();
            this.clearCache();
            return null;
        });
        EpbsFuture.allOf((EpbsFuture[])new EpbsFuture[]{resolveFuture, importFuture}).thenRun(() -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.logId, (String)"epdm_importlog");
            EPDMImportLogConstant.ProcessEnum processEnum = this.info.getTotal() == 0 || this.info.getTotal() - this.info.getFail() == 0 ? EPDMImportLogConstant.ProcessEnum.FAIL : (this.info.getFail() == 0 ? EPDMImportLogConstant.ProcessEnum.SUCCESS : EPDMImportLogConstant.ProcessEnum.PARTIAL_SUCCESS);
            dynamicObject.set("process", (Object)processEnum.getNumber());
            String result = this.buildResult();
            dynamicObject.set("desclog", (Object)result);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.clearCache();
        });
        this.cacheInfo();
    }

    private void clearCache() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.appCache.remove(EPDMAbstractImportService.getSuspendKey(this.schemeId, String.valueOf(this.logId)));
    }

    /*
     * WARNING - void declaration
     */
    private EPDMImportFieldGroup buildImportConfig(DynamicObject schemeObject) {
        String fieldUpperName;
        String fieldName;
        DynamicObjectCollection collection = schemeObject.getDynamicObjectCollection("attachment");
        DynamicObject dynamicObject = (DynamicObject)collection.get(0);
        DynamicObject att = dynamicObject.getDynamicObject("fbasedataid");
        String type = att.getString("type");
        DynamicObject dataModel = schemeObject.getDynamicObject("datamodel");
        String number = dataModel.getString("number");
        String table = number.split("@")[0];
        long id = dataModel.getLong("id");
        Map otherField = DEFAULT_FIELD.getOrDefault(id, Collections.emptyMap());
        Map<String, DataModelFieldDataTypeEnum> fieldDataTypeMap = EPDMImportSchemeHelper.queryFieldDataTypeMap(id);
        DynamicObjectCollection mappingColl = schemeObject.getDynamicObjectCollection("entryentity");
        Map<String, DynamicObject> fieldDyMap = mappingColl.stream().collect(Collectors.toMap(dy -> dy.getString("fieldname").toUpperCase(Locale.ROOT), dy -> dy));
        ArrayList<String> candidateKeys = new ArrayList<String>(4);
        List primaryKeys = DB.getPrimaryKeys((DBRoute)EPDMConstant.DB_ROUTE, (String)table);
        List columnNames = DB.getColumnNames((DBRoute)EPDMConstant.DB_ROUTE, (String)table);
        String primaryKey = primaryKeys.isEmpty() ? "" : (String)primaryKeys.get(0);
        otherField.remove(primaryKey);
        String keyUpperName = primaryKey.toUpperCase(Locale.ROOT);
        DynamicObject pkDy = fieldDyMap.remove(keyUpperName);
        List fieldInfo = DB.getFieldInfo((DBRoute)EPDMConstant.DB_ROUTE, (String)table);
        Map<String, FieldInfo> fieldInfoMap = fieldInfo.stream().collect(Collectors.toMap(info -> info.getFieldName().toUpperCase(Locale.ROOT), info -> info));
        int sqlIndex = 0;
        EPDMImportFieldGroup fieldGroup = new EPDMImportFieldGroup();
        for (Map.Entry<String, DynamicObject> entry : fieldDyMap.entrySet()) {
            fieldName = entry.getKey();
            DynamicObject dy2 = entry.getValue();
            if (dy2.getBoolean("iscandidatekey")) {
                candidateKeys.add(fieldName);
                continue;
            }
            fieldUpperName = fieldName.toUpperCase(Locale.ROOT);
            String startCol = dy2.getString("colname");
            int colIndex = StringUtils.isEmpty((String)startCol) ? -1 : EPDMImportSchemeHelper.parseIntCol(startCol, type);
            String staticValue = dy2.getString("value");
            String dfValue = dy2.getString("defaultvalue");
            if (StringUtils.isEmpty((String)startCol) && StringUtils.isEmpty((String)staticValue) && StringUtils.isEmpty((String)dfValue)) continue;
            EPDMImportField importField = new EPDMImportField();
            importField.setField(dy2.getString("fieldname"));
            importField.setSqlIndex(sqlIndex++);
            importField.setFieldColIndex(startCol);
            importField.setColIndex(colIndex);
            importField.setDfValue(map -> {
                if (colIndex > -1) {
                    return Optional.ofNullable(map.get(colIndex - 1)).orElseGet(() -> dfValue);
                }
                return StringUtils.isEmpty((String)staticValue) ? dfValue : staticValue;
            });
            importField.setConversionFunc(EPDMImportSchemeHelper.valueConversionFunc(fieldInfoMap.get(fieldUpperName), fieldDataTypeMap.get(fieldUpperName)));
            fieldGroup.addFieldList(importField);
        }
        for (Map.Entry<String, Object> entry : otherField.entrySet()) {
            fieldName = entry.getKey();
            Supplier supplier = (Supplier)entry.getValue();
            fieldUpperName = fieldName.toUpperCase(Locale.ROOT);
            EPDMImportField importField = new EPDMImportField();
            importField.setField(fieldName);
            importField.setSqlIndex(sqlIndex++);
            importField.setFieldColIndex("");
            importField.setColIndex(-1);
            importField.setDfValue(arg_0 -> EPDMAbstractImportService.lambda$buildImportConfig$14((Supplier)supplier, arg_0));
            importField.setConversionFunc(EPDMImportSchemeHelper.valueConversionFunc(fieldInfoMap.get(fieldUpperName), fieldDataTypeMap.get(fieldUpperName)));
            fieldGroup.addFieldList(importField);
        }
        fieldDyMap.put(primaryKey, pkDy);
        Optional.ofNullable(pkDy).filter(dy -> dy.getBoolean("iscandidatekey")).ifPresent(dy -> fieldGroup.setPrKeyInCandidateFieldList(true));
        for (String string : candidateKeys) {
            DynamicObject dy3 = fieldDyMap.get(string);
            String fieldUpperName2 = string.toUpperCase(Locale.ROOT);
            String startCol = dy3.getString("colname");
            int colIndex = StringUtils.isEmpty((String)startCol) ? -1 : EPDMImportSchemeHelper.parseIntCol(startCol, type);
            String staticValue = dy3.getString("value");
            String dfValue = dy3.getString("defaultvalue");
            EPDMImportField importField = new EPDMImportField();
            importField.setField(dy3.getString("fieldname"));
            importField.setSqlIndex(sqlIndex++);
            importField.setFieldColIndex(startCol);
            importField.setColIndex(colIndex);
            importField.setDfValue(map -> {
                if (colIndex > -1) {
                    return Optional.ofNullable(map.get(colIndex - 1)).orElseGet(() -> dfValue);
                }
                return StringUtils.isEmpty((String)staticValue) ? dfValue : staticValue;
            });
            importField.setConversionFunc(EPDMImportSchemeHelper.valueConversionFunc(fieldInfoMap.get(fieldUpperName2), fieldDataTypeMap.get(fieldUpperName2)));
            if (fieldGroup.isPrKeyInCandidateFieldList()) {
                fieldGroup.addFieldList(importField);
                continue;
            }
            fieldGroup.addCandidateFieldList(importField);
        }
        if (StringUtils.isNotEmpty((String)primaryKey)) {
            void var26_32;
            FieldInfo pkInfo = fieldInfoMap.get(keyUpperName);
            DataModelFieldDataTypeEnum dataModelFieldDataTypeEnum = fieldDataTypeMap.get(keyUpperName);
            if (dataModelFieldDataTypeEnum != null && dataModelFieldDataTypeEnum != DataModelFieldDataTypeEnum.VARCHAR || dataModelFieldDataTypeEnum == null && !"VARCHAR".equalsIgnoreCase(pkInfo.getDataType())) {
                DataModelFieldDataTypeEnum dataModelFieldDataTypeEnum2 = DataModelFieldDataTypeEnum.LONG;
            }
            String startCol = "";
            String field = pkInfo.getFieldName();
            if (null != pkDy) {
                startCol = pkDy.getString("colname");
                field = pkDy.getString("fieldname");
            }
            int colIndex = StringUtils.isEmpty((String)startCol) ? -1 : EPDMImportSchemeHelper.parseIntCol(startCol, type);
            fieldGroup.setPkInField(!StringUtils.isEmpty((String)startCol));
            Supplier<String> dfValue = var26_32 == DataModelFieldDataTypeEnum.VARCHAR ? () -> DB.genStringId((String)table) : () -> String.valueOf(DB.genGlobalLongId());
            EPDMImportField importField = new EPDMImportField();
            importField.setField(field);
            importField.setSqlIndex(sqlIndex);
            importField.setFieldColIndex(startCol);
            importField.setColIndex(colIndex);
            importField.setDfValue(map -> {
                if (colIndex > -1) {
                    return Optional.ofNullable(map.get(colIndex - 1)).orElseGet(((Supplier)dfValue)::get);
                }
                return (String)dfValue.get();
            });
            importField.setConversionFunc(EPDMImportSchemeHelper.valueConversionFunc(pkInfo, (DataModelFieldDataTypeEnum)var26_32));
            fieldGroup.addPkFieldList(importField);
        }
        this.validateDbField(fieldGroup, columnNames);
        this.buildSql(table, fieldGroup);
        return fieldGroup;
    }

    private void validateDbField(EPDMImportFieldGroup fieldGroup, List<String> columnNames) {
        ArrayList<EPDMImportField> fields = new ArrayList<EPDMImportField>(16);
        fields.addAll(fieldGroup.getPkFieldList());
        fields.addAll(fieldGroup.getCandidateFieldList());
        fields.addAll(fieldGroup.getFieldList());
        Set cNames = columnNames.stream().map(e -> e.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        for (EPDMImportField field : fields) {
            if (!StringUtils.isNotEmpty((String)field.getField()) || cNames.contains(field.getField().toLowerCase(Locale.ENGLISH))) continue;
            this.info.setStopResolve(true);
            this.info.setTotal(0);
            throw new EPDMImportException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5[%s]\u4e0d\u5b58\u5728\u6570\u636e\u5e93\u4e2d\uff0c\u5168\u90e8\u5931\u8d25\u3002", (String)"EPDMAbstractImportService_12", (String)"epm-epbs-business", (Object[])new Object[0]), field.getField()));
        }
    }

    private void buildSql(String table, EPDMImportFieldGroup fieldGroup) {
        String field;
        List<EPDMImportField> pkFieldList = fieldGroup.getPkFieldList();
        List<EPDMImportField> candidateFieldList = fieldGroup.getCandidateFieldList();
        List<EPDMImportField> fieldList = fieldGroup.getFieldList();
        StringJoiner fieldName = new StringJoiner(",");
        StringJoiner questionMark = new StringJoiner(",");
        StringJoiner updateSetCause = new StringJoiner(",");
        for (EPDMImportField importField : fieldList) {
            String field2 = importField.getField();
            fieldName.add(field2);
            questionMark.add("?");
            updateSetCause.add(field2 + "=" + "?");
        }
        StringJoiner updateWhereCause = new StringJoiner(" and ");
        StringJoiner selectWhereCause = new StringJoiner(" and ");
        StringJoiner selectField = new StringJoiner(",");
        for (EPDMImportField importField : candidateFieldList) {
            field = importField.getField();
            fieldName.add(field);
            questionMark.add("?");
            if (pkFieldList.isEmpty()) {
                updateWhereCause.add(field + "=" + "?");
                selectField.add(field);
            } else {
                updateSetCause.add(field + "=" + "?");
            }
            selectWhereCause.add(field + "=" + "?");
        }
        for (EPDMImportField importField : pkFieldList) {
            field = importField.getField();
            fieldName.add(field);
            questionMark.add("?");
            updateWhereCause.add(field + "=" + "?");
            if (fieldGroup.isPrKeyInCandidateFieldList()) {
                selectWhereCause.add(field + "=" + "?");
            }
            selectField.add(field);
        }
        this.insertSql = "insert into " + table + "(" + fieldName + ")values(" + questionMark + ")";
        this.updateSql = "update " + table + " set " + updateSetCause + " where " + updateWhereCause;
        this.querySql = "SELECT top 1 " + selectField + " FROM " + table + " WHERE " + selectWhereCause;
    }

    private void afterException(Throwable ex) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.logId, (String)"epdm_importlog");
        dynamicObject.set("process", (Object)EPDMImportLogConstant.ProcessEnum.FAIL.getNumber());
        String stack = ThrowableHelper.toString((Throwable)ex);
        if (null != ex.getCause() && ex.getCause() instanceof EPDMImportException) {
            stack = ex.getCause().getMessage();
        }
        dynamicObject.set("desclog", (Object)(stack.length() > 2000 ? stack.substring(0, 1900) + "..." : stack));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void logFail(int rowIndex, Collection<String> msg) {
        this.info.setFail(this.info.getFail() + 1);
        this.logDesc.put(rowIndex, msg);
        this.cacheInfo();
    }

    public boolean checkoutData(Collection<EPDMImportData> collection, int batch) {
        collection.clear();
        boolean resolveComplete = false;
        while (collection.isEmpty() && !resolveComplete) {
            resolveComplete = this.info.isResolveComplete() && this.dataQueue.isEmpty();
            this.dataQueue.drainTo(collection, batch);
        }
        int importRow = this.info.getImportRow();
        this.info.setImportRow(importRow + collection.size());
        this.cacheInfo();
        return !resolveComplete;
    }

    private void pull(EPDMImportData importData) {
        this.dataQueue.offer(importData);
        this.info.setResolveRow(this.info.getTotal());
        this.cacheInfo();
    }

    private String buildResult() {
        ArrayList rows = Lists.newArrayList(this.logDesc.keySet());
        rows.sort(Comparator.comparingInt(a -> a));
        StringJoiner joiner = new StringJoiner("\n");
        int total = this.info.getTotal();
        int fail = this.info.getFail();
        if (fail == 0) {
            joiner.add(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u5168\u90e8\u5bfc\u5165\u6210\u529f\u3002", (String)"EPDMAbstractImportService_8", (String)"epm-epbs-business", (Object[])new Object[0]), total));
        } else {
            joiner.add(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u6761\u6570\u636e\uff0c\u5931\u8d25%2$s\u6570\u636e\u3002", (String)"EPDMAbstractImportService_9", (String)"epm-epbs-business", (Object[])new Object[0]), total - fail, fail));
        }
        for (Integer row : rows) {
            joiner.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c  %2$s", (String)"EPDMAbstractImportService_10", (String)"epm-epbs-business", (Object[])new Object[0]), row, String.join((CharSequence)";", (Iterable<? extends CharSequence>)this.logDesc.get(row))));
        }
        String result = joiner.toString();
        return result.length() > 2000 ? result.substring(0, 1900) + "..." : result;
    }

    private void importComplete() {
        this.info.setImportComplete(true);
        this.cacheInfo();
    }

    private void cacheInfo() {
        this.appCache.put(EPDMAbstractImportService.getSuspendKey(this.schemeId, String.valueOf(this.logId)), (Object)this.info);
    }

    private static /* synthetic */ String lambda$buildImportConfig$14(Supplier supplier, Map map) {
        return (String)supplier.get();
    }

    static {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Supplier<String>> balanceMap = new HashMap<String, Supplier<String>>();
        DEFAULT_FIELD.put(DataModelPresetEnum.T_EPM_BALANCE.getId(), balanceMap);
        balanceMap.put("FSOURCETYPE", () -> ((EPMDBalanceConstant.SourceType)EPMDBalanceConstant.SourceType.C).getCode());
        balanceMap.put("FCOLLECTTASK", () -> "");
        balanceMap.put("FBATCHNO", () -> "");
        balanceMap.put("FCOLLECTTIME", () -> df.format(TimeServiceHelper.now()));
        HashMap<String, Supplier<String>> voucherMap = new HashMap<String, Supplier<String>>();
        DEFAULT_FIELD.put(DataModelPresetEnum.T_EPM_VOUCHER.getId(), voucherMap);
        voucherMap.put("FSOURCETYPE", () -> ((EPMDVoucherDescConstant.SourcesType)EPMDVoucherDescConstant.SourcesType.C).getCode());
        voucherMap.put("FCOLLECTTASK", () -> "");
        voucherMap.put("FBATCHNO", () -> "");
        voucherMap.put("FCOLLECTORID", () -> "0");
        voucherMap.put("FCOLLECTTIME", () -> df.format(TimeServiceHelper.now()));
        voucherMap.put("FMODIFIERID", () -> String.valueOf(RequestContext.get().getCurrUserId()));
        voucherMap.put("FMODIFYTIME", () -> df.format(TimeServiceHelper.now()));
    }

    static class UniqueCheck {
        private final Map<String, Integer> uniqueStrColMap = new HashMap<String, Integer>();

        UniqueCheck() {
        }

        public void check(EPDMImportData importData, Set<String> msg, String[] paramString, String format, List<EPDMImportField> fieldList) {
            String uniqueStr = fieldList.stream().map(EPDMImportField::getSqlIndex).map(sqlIndex -> paramString[sqlIndex]).collect(Collectors.joining("@"));
            Integer integer = this.uniqueStrColMap.get(uniqueStr);
            if (integer != null) {
                msg.add(String.format(format, integer));
            } else {
                this.uniqueStrColMap.put(uniqueStr, importData.getRowIndex() + 1);
            }
        }
    }
}

