/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.importscheme;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.epm.epbs.common.util.ThrowableHelper;
import kd.epm.epdm.business.importscheme.EPDMAbstractImportService;
import kd.epm.epdm.business.importscheme.EPDMImportData;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;

public class EPDMImportCSVService
extends EPDMAbstractImportService {
    public EPDMImportCSVService(IAppCache appCache, Object schemeId, long logId) {
        super(appCache, schemeId, logId);
    }

    @Override
    public void resolveFile(String filePath, String sheet, Consumer<EPDMImportData> consumerRow) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(filePath);
             InputStreamReader reader = new InputStreamReader(inputStream);
             BufferedReader bf = new BufferedReader(reader);){
            String line;
            int row = 0;
            while ((line = bf.readLine()) != null) {
                String[] rowData = line.split(",");
                HashMap<Integer, String> colValueMap = new HashMap<Integer, String>(rowData.length);
                for (int i = 0; i < rowData.length; ++i) {
                    colValueMap.put(i, rowData[i]);
                }
                EPDMImportData importData = new EPDMImportData();
                importData.setRowIndex(row);
                importData.setData(colValueMap);
                consumerRow.accept((Object)importData);
                ++row;
            }
        }
        catch (Exception ex) {
            if (ex instanceof NotOfficeXmlFileException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4f7f\u7528\u3002", (String)"EPDMImportCSVService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)ex, (int)30));
        }
    }
}

