/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.importscheme;

import java.io.InputStream;
import java.util.Map;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.epm.epbs.common.util.ThrowableHelper;
import kd.epm.epdm.business.importscheme.EPDMAbstractImportService;
import kd.epm.epdm.business.importscheme.EPDMImportData;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;

public class EPDMImportExcelService
extends EPDMAbstractImportService {
    public EPDMImportExcelService(IAppCache appCache, Object schemeId, long logId) {
        super(appCache, schemeId, logId);
    }

    @Override
    public void resolveFile(String filePath, final String sheet, final Consumer<EPDMImportData> consumerRow) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        try (InputStream inputStream = service.getInputStream(filePath);){
            SheetHandler sheetHandler = new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow parsedRow) {
                    String sheetName = parsedRow.getSheetName();
                    if (!sheetName.equals(sheet)) {
                        return;
                    }
                    int rowNum = parsedRow.getRowNum();
                    Map data = parsedRow.getData();
                    EPDMImportData importData = new EPDMImportData();
                    importData.setRowIndex(rowNum);
                    importData.setData(data);
                    consumerRow.accept((Object)importData);
                }

                public boolean isInterrupt() {
                    return this.getSheetName().equals(sheet);
                }
            };
            sheetHandler.setReadOriginalNum(Boolean.TRUE);
            reader.read(inputStream, sheetHandler);
        }
        catch (Exception ex) {
            if (ex instanceof NotOfficeXmlFileException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4f7f\u7528\u3002", (String)"EPDMImportExcelService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)ex, (int)30));
        }
    }
}

