/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.importscheme;

import java.util.Map;
import java.util.function.Function;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class EPDMImportField {
    private static final Log LOG = LogFactory.getLog(EPDMImportField.class);
    private int sqlIndex;
    private String fieldColIndex;
    private int colIndex;
    private String field;
    private Function<Map<Integer, String>, String> dfValue;
    private Function<String, Object> conversionFunc;

    public String getValue(Map<Integer, String> map) {
        Function<Map<Integer, String>, String> dfValue = this.getDfValue();
        return dfValue.apply(map);
    }

    public Object conversionValue(String value) {
        try {
            Function<String, Object> conversionFunc = this.getConversionFunc();
            return conversionFunc.apply(value);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(int colIndex) {
        this.colIndex = colIndex;
    }

    public int getSqlIndex() {
        return this.sqlIndex;
    }

    public void setSqlIndex(int sqlIndex) {
        this.sqlIndex = sqlIndex;
    }

    public String getFieldColIndex() {
        return this.fieldColIndex;
    }

    public void setFieldColIndex(String fieldColIndex) {
        this.fieldColIndex = fieldColIndex;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Function<Map<Integer, String>, String> getDfValue() {
        return this.dfValue;
    }

    public void setDfValue(Function<Map<Integer, String>, String> dfValue) {
        this.dfValue = dfValue;
    }

    public Function<String, Object> getConversionFunc() {
        return this.conversionFunc;
    }

    public void setConversionFunc(Function<String, Object> conversionFunc) {
        this.conversionFunc = conversionFunc;
    }
}

