/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.importscheme;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.field.ComboItem;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.ThrowableHelper;
import kd.epm.epdm.business.importscheme.EPDMImportException;
import kd.epm.epdm.business.importscheme.EPDMImportSchemeHelper;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class EPDMImportSchemeAttService {
    private final DynamicObjectCollection attachment;

    public EPDMImportSchemeAttService(DynamicObjectCollection attachment) {
        this.attachment = attachment;
    }

    public List<ComboItem> analyzeSheetComboItems() {
        Function<InputStream, Workbook> buildWorkBookAction;
        ArrayList comboItems = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)this.attachment)) {
            return comboItems;
        }
        DynamicObject dynamicObject = (DynamicObject)this.attachment.get(0);
        DynamicObject baseData = dynamicObject.getDynamicObject("fbasedataid");
        if (null == baseData) {
            return comboItems;
        }
        String type = baseData.getString("type");
        if ("xls".equals(type)) {
            buildWorkBookAction = this::getHSSFWorkbook;
        } else if ("xlsx".equals(type)) {
            buildWorkBookAction = this::getXSSFWorkbook;
        } else {
            return comboItems;
        }
        String url = baseData.getString("url");
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = EPDMImportSchemeHelper.fileInputStream(url, service);
             Workbook workBook = buildWorkBookAction.apply(inputStream);){
            Iterator sheetIterator = workBook.sheetIterator();
            sheetIterator.forEachRemaining(sheet -> {
                String sheetName = sheet.getSheetName();
                comboItems.add(new ComboItem(new LocaleString(sheetName), sheetName));
            });
        }
        catch (Exception ex) {
            if (ex instanceof NotOfficeXmlFileException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4f7f\u7528\u3002", (String)"EPDMImportSchemeAttService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            if (ex instanceof EPDMImportException) {
                throw new KDBizException(ex.getMessage());
            }
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)ex, (int)30));
        }
        return comboItems;
    }

    public List<ComboItem> analyzeColNameComboItems(final String sheetName, String startCol, int startRow) {
        final ArrayList comboItems = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)this.attachment)) {
            return comboItems;
        }
        if (StringUtils.isEmpty((String)startCol)) {
            return comboItems;
        }
        DynamicObject dynamicObject = (DynamicObject)this.attachment.get(0);
        DynamicObject baseData = dynamicObject.getDynamicObject("fbasedataid");
        String type = baseData.getString("type");
        String url = baseData.getString("url");
        if (!EPDMImportSchemeHelper.startColCheck(startCol, type)) {
            return comboItems;
        }
        int IntStartCol = EPDMImportSchemeHelper.parseIntCol(startCol, type);
        final int titleRow = startRow - 1;
        final int titleStartCol = IntStartCol - 1;
        FileService service = FileServiceFactory.getAttachmentFileService();
        if (!"xls".equals(type) && !"xlsx".equals(type)) {
            try (InputStream inputStream = EPDMImportSchemeHelper.fileInputStream(url, service);
                 BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream));){
                String line = null;
                for (int i = 0; i <= titleRow && (line = bf.readLine()) != null; ++i) {
                }
                if (line != null) {
                    String[] split = line.split(",");
                    for (int i = titleStartCol; i < split.length; ++i) {
                        int colName = i + 1;
                        comboItems.add(new ComboItem(new LocaleString(colName + " " + split[i]), "" + colName));
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof NotOfficeXmlFileException) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4f7f\u7528\u3002", (String)"EPDMImportSchemeAttService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
                }
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)ex, (int)30));
            }
            return comboItems;
        }
        if (null == sheetName) {
            return comboItems;
        }
        try (InputStream inputStream = EPDMImportSchemeHelper.fileInputStream(url, service);){
            ExcelReader reader = new ExcelReader();
            SheetHandler sheetHandler = new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow parsedRow) {
                    if (!parsedRow.getSheetName().equals(sheetName) || titleRow != parsedRow.getRowNum()) {
                        return;
                    }
                    Map data = parsedRow.getData();
                    data.forEach((col, cellValue) -> {
                        if (titleStartCol > col) {
                            return;
                        }
                        String colName = EPDMImportSchemeHelper.convertToExcelColumnName(col + 1);
                        comboItems.add(new ComboItem(new LocaleString(colName + " " + cellValue), colName));
                    });
                }

                public boolean isInterrupt() {
                    return this.getSheetName().equals(sheetName);
                }
            };
            sheetHandler.setReadOriginalNum(Boolean.TRUE);
            reader.read(inputStream, sheetHandler);
        }
        catch (Exception ex) {
            if (ex instanceof NotOfficeXmlFileException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4f7f\u7528\u3002", (String)"EPDMImportSchemeAttService_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)ex, (int)30));
        }
        return comboItems;
    }

    private Workbook getHSSFWorkbook(InputStream inputStream) {
        try {
            return new HSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    private Workbook getXSSFWorkbook(InputStream inputStream) {
        try {
            return new XSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }
}

