/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.importscheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.D;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epdm.business.datamodel.helper.DataModelServiceHelper;
import kd.epm.epdm.business.importscheme.EPDMImportException;
import kd.epm.epdm.common.constant.EPDMConstant;
import kd.epm.epdm.common.enums.DataModelFieldDataTypeEnum;
import kd.epm.epdm.common.enums.DataModelPresetEnum;

public class EPDMImportSchemeHelper {
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";

    public static String startColDefault(String type) {
        if (XLS.equals(type) || XLSX.equals(type)) {
            return "A";
        }
        return "1";
    }

    public static String startColConvert(String startCol, String type) {
        int length = startCol.length();
        if (XLS.equals(type) || XLSX.equals(type)) {
            for (int i = 0; i < length; ++i) {
                char c = startCol.charAt(i);
                if (c >= 'A' && c <= 'Z') continue;
                try {
                    return EPDMImportSchemeHelper.convertToExcelColumnName(Integer.parseInt(startCol));
                }
                catch (NumberFormatException e) {
                    return "A";
                }
            }
            return startCol;
        }
        for (int i = 0; i < length; ++i) {
            char c = startCol.charAt(i);
            if (c >= '0' && c <= '9') continue;
            try {
                return String.valueOf(EPDMImportSchemeHelper.parseIntCol(startCol, XLS));
            }
            catch (Exception e) {
                return "1";
            }
        }
        return startCol;
    }

    public static boolean startColCheck(String startCol, String type) {
        if (XLS.equals(type) || XLSX.equals(type)) {
            for (int i = 0; i < startCol.length(); ++i) {
                char c = startCol.charAt(i);
                if (c >= 'A' && c <= 'Z') continue;
                return false;
            }
        } else {
            if ("0".equals(startCol)) {
                return false;
            }
            for (int i = 0; i < startCol.length(); ++i) {
                char c = startCol.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean startColCheck(String startCol) {
        for (int i = 0; i < startCol.length(); ++i) {
            char c = startCol.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String queryFullUrlById(Object primaryKeyValue) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epdm_importscheme"));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("attachment");
        DynamicObject rfDyn = (DynamicObject)dynamicObjectCollection.get(0);
        DynamicObject baseData = rfDyn.getDynamicObject("fbasedataid");
        String url = baseData.getString("url");
        return UrlService.getAttachmentFullUrl((String)url);
    }

    public static DynamicObject queryConfigById(Object primaryKeyValue) {
        QFBuilder qfBuilder;
        String fieldName = "entryentity.fieldname";
        String value = "entryentity.value";
        String colName = "entryentity.colname";
        String defaultValue = "entryentity.defaultvalue";
        String candidateKey = "entryentity.iscandidatekey";
        String selectFields = String.join((CharSequence)",", "sheet", "startrow", "attachment", "datamodel", "entryentity", fieldName, value, colName, defaultValue, candidateKey);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"epdm_importscheme", (String)selectFields, (QFilter[])(qfBuilder = new QFBuilder("id", "=", primaryKeyValue)).toArray());
        if (load.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e3b\u952e\u4e3a%1$s\u5bfc\u5165\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"EPDMImportSchemeHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]), primaryKeyValue));
        }
        DynamicObject schemeObject = load[0];
        DynamicObjectCollection collection = schemeObject.getDynamicObjectCollection("attachment");
        if (collection.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e3b\u952e\u4e3a%1$s\u5bfc\u5165\u65b9\u6848\u9644\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"EPDMImportSchemeHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), primaryKeyValue));
        }
        return schemeObject;
    }

    public static InputStream fileInputStream(String url, FileService service) throws MalformedURLException {
        if (url.startsWith("http")) {
            String[] reqParams = new URL(url).getQuery().split("&");
            HashMap<String, String> map = new HashMap<String, String>(4);
            for (String param : reqParams) {
                String[] p = param.split("=");
                map.put(p[0], p[1]);
            }
            String patch = (String)map.get("path");
            if (StringUtils.isEmpty((String)patch)) {
                TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
                TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                if (content == null) {
                    throw new EPDMImportException(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"EPDMImportSchemeHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]));
                }
                return content.getInputStream();
            }
            url = patch;
        }
        return service.getInputStream(url);
    }

    public static int parseIntCol(String startCol, String type) {
        if (XLS.equals(type) || XLSX.equals(type)) {
            return EPDMImportSchemeHelper.convertToExcelColumnNumber(startCol);
        }
        return Integer.parseInt(startCol);
    }

    public static String convertToExcelColumnName(int columnNumber) {
        StringBuilder columnName = new StringBuilder();
        while (columnNumber > 0) {
            int remainder = (columnNumber - 1) % 26;
            char ch = (char)(remainder + 65);
            columnName.insert(0, ch);
            columnNumber = (columnNumber - 1) / 26;
        }
        return columnName.toString();
    }

    public static Map<String, Function<String, Object>> getFieldValueFuncMap(long pkValue, String modelNumber) {
        String[] split = modelNumber.split("@");
        List fieldInfoList = DB.getFieldInfo((DBRoute)EPDMConstant.DB_ROUTE, (String)split[0]);
        Map<String, DataModelFieldDataTypeEnum> fieldDataTypeEnumMap = EPDMImportSchemeHelper.queryFieldDataTypeMap(pkValue);
        return fieldInfoList.stream().filter(fieldInfo -> fieldDataTypeEnumMap.containsKey(fieldInfo.getFieldName().toUpperCase())).collect(Collectors.toMap(info -> info.getFieldName().toUpperCase(Locale.ROOT), info -> {
            String fieldName = info.getFieldName();
            DataModelFieldDataTypeEnum typeEnum = (DataModelFieldDataTypeEnum)fieldDataTypeEnumMap.get(fieldName.toUpperCase(Locale.ROOT));
            return EPDMImportSchemeHelper.valueConversionFunc(info, typeEnum);
        }));
    }

    public static Map<String, DataModelFieldDataTypeEnum> queryFieldDataTypeMap(long id) {
        DataModelServiceHelper serviceHelper = new DataModelServiceHelper();
        JSONArray modelFields = serviceHelper.getDataModelFields(id);
        Map<String, DataModelFieldDataTypeEnum> collect = modelFields.stream().map(JSONObject.class::cast).collect(Collectors.toMap(fieldMapping -> fieldMapping.getString("field").toUpperCase(Locale.ROOT), fieldMapping -> {
            String dataType = fieldMapping.getString("data_type");
            String dataTypeUpperCase = dataType.toUpperCase(Locale.ROOT);
            dataTypeUpperCase = "BIGINT".equals(dataTypeUpperCase) ? DataModelFieldDataTypeEnum.LONG.name() : ("INT".equals(dataTypeUpperCase) ? DataModelFieldDataTypeEnum.INTEGER.name() : ("FLOAT".equals(dataTypeUpperCase) ? DataModelFieldDataTypeEnum.DECIMAL.name() : ("BIT".equals(dataTypeUpperCase) || "VARBINARY".equals(dataTypeUpperCase) ? DataModelFieldDataTypeEnum.VARCHAR.name() : ("DATE".equals(dataTypeUpperCase) || "TIME".equals(dataTypeUpperCase) ? DataModelFieldDataTypeEnum.DATETIME.name() : dataTypeUpperCase))));
            return DataModelFieldDataTypeEnum.valueOf((String)dataTypeUpperCase);
        }, (k1, k2) -> k1));
        if (collect.containsKey("FROWNUM") && id == DataModelPresetEnum.T_EPM_VOUCHER.getId()) {
            collect.put("FROWNUM", DataModelFieldDataTypeEnum.INTEGER);
        }
        return collect;
    }

    public static Function<String, Object> valueConversionFunc(FieldInfo fieldInfo, DataModelFieldDataTypeEnum dataType) {
        if (DataModelFieldDataTypeEnum.VARCHAR == dataType || DataModelFieldDataTypeEnum.TEXT == dataType || DataModelFieldDataTypeEnum.BOOLEAN == dataType) {
            return input -> {
                if ((long)input.length() <= fieldInfo.getDataLength()) {
                    return input;
                }
                return null;
            };
        }
        if (DataModelFieldDataTypeEnum.LONG == dataType) {
            return input -> {
                try {
                    return Long.parseLong(input);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            };
        }
        if (DataModelFieldDataTypeEnum.INTEGER == dataType) {
            return input -> {
                try {
                    return Integer.parseInt(input);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            };
        }
        if (DataModelFieldDataTypeEnum.DATETIME == dataType) {
            return D::t;
        }
        if (DataModelFieldDataTypeEnum.DECIMAL == dataType) {
            return BigDecimal::new;
        }
        return input -> null;
    }

    private static int convertToExcelColumnNumber(String columnName) {
        int result = 0;
        for (int i = 0; i < columnName.length(); ++i) {
            char ch = columnName.charAt(i);
            result = result * 26 + (ch - 65 + 1);
        }
        return result;
    }
}

