/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.voucher;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.thread.EpbsFuture;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetHelper;
import kd.epm.epdm.common.entity.EPDMDataModelPreset;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.function.IRunnable;
import kd.epm.epdm.common.util.MetadataUtil;

public class EPDMVoucherSearchService {
    private static final Consumer<Map<String, Tuple<Boolean, LocaleString>>> EMPTY_STRINGS_MAP_CONSUMER = a -> {};
    private static final BiConsumer<Collection<String>, DynamicObject> EMPTY_STRINGS_DYN_CONSUMER = (a, b) -> {};
    private static final BiConsumer<String, Object> EMPTY_STR_OBJ_CONSUMER = (a, b) -> {};
    private static final IRunnable EMPTY_RUNNER = () -> {};
    private final Object balanceId;
    private final Set<String> defaultVoucherFields;
    private final Set<String> defaultBalanceFields;
    private Consumer<Map<String, Tuple<Boolean, LocaleString>>> voucherFieldAndFieldNameConsumer = EMPTY_STRINGS_MAP_CONSUMER;
    private BiConsumer<Collection<String>, DynamicObject> voucherRowAndRowFieldConsumer = EMPTY_STRINGS_DYN_CONSUMER;
    private BiConsumer<String, Object> balanceFieldAndValueConsumer = EMPTY_STR_OBJ_CONSUMER;
    private Consumer<Map<String, Tuple<Boolean, LocaleString>>> balanceFieldAndFieldNameConsumer = EMPTY_STRINGS_MAP_CONSUMER;
    private IRunnable balanceErrorRunner = EMPTY_RUNNER;

    public EPDMVoucherSearchService(Object balanceId, Set<String> defaultVoucherFields, Set<String> defaultBalanceFields) {
        this.balanceId = balanceId == null ? Long.valueOf(0L) : balanceId;
        this.defaultVoucherFields = defaultVoucherFields == null ? Collections.emptySet() : Sets.newHashSet(defaultVoucherFields);
        this.defaultBalanceFields = defaultBalanceFields == null ? Collections.emptySet() : Sets.newHashSet(defaultBalanceFields);
    }

    public EPDMVoucherSearchService addVoucherFieldAndFieldNameConsumer(Consumer<Map<String, Tuple<Boolean, LocaleString>>> voucherFieldAndFieldNameConsumer) {
        this.voucherFieldAndFieldNameConsumer = voucherFieldAndFieldNameConsumer == null ? this.voucherFieldAndFieldNameConsumer : voucherFieldAndFieldNameConsumer;
        return this;
    }

    public EPDMVoucherSearchService addVoucherRowAndRowFieldConsumer(BiConsumer<Collection<String>, DynamicObject> voucherRowAndRowFieldConsumer) {
        this.voucherRowAndRowFieldConsumer = voucherRowAndRowFieldConsumer == null ? this.voucherRowAndRowFieldConsumer : voucherRowAndRowFieldConsumer;
        return this;
    }

    public EPDMVoucherSearchService addBalanceFieldAndValueConsumer(BiConsumer<String, Object> balanceFieldAndValueConsumer) {
        this.balanceFieldAndValueConsumer = balanceFieldAndValueConsumer == null ? this.balanceFieldAndValueConsumer : balanceFieldAndValueConsumer;
        return this;
    }

    public EPDMVoucherSearchService addBalanceFieldAndFieldNameConsumer(Consumer<Map<String, Tuple<Boolean, LocaleString>>> balanceFieldAndFieldNameConsumer) {
        this.balanceFieldAndFieldNameConsumer = balanceFieldAndFieldNameConsumer == null ? this.balanceFieldAndFieldNameConsumer : balanceFieldAndFieldNameConsumer;
        return this;
    }

    public EPDMVoucherSearchService addBalanceErrorRunner(IRunnable balanceErrorRunner) {
        this.balanceErrorRunner = balanceErrorRunner == null ? this.balanceErrorRunner : balanceErrorRunner;
        return this;
    }

    public void doActionAsync() {
        EpbsFuture queryBalancePresetFuture = EpbsFuture.supplyAsync(() -> this.getPropertyNameMap(DataModelPresetEnum.T_EPM_BALANCE, "epdm_balance", this.defaultBalanceFields));
        EpbsFuture queryVoucherPresetFuture = EpbsFuture.supplyAsync(() -> this.getPropertyNameMap(DataModelPresetEnum.T_EPM_VOUCHER, "epdm_voucherdesc", this.defaultVoucherFields));
        EpbsFuture queryBalanceFuture = queryBalancePresetFuture.thenApplyAsync(map -> {
            Set selectFields = map.keySet();
            QFBuilder qfBuilder = new QFBuilder("id", "=", this.balanceId);
            return QueryServiceHelper.queryOne((String)"epdm_balance", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray());
        });
        EpbsFuture balanceVoucherFieldMapFuture = queryBalancePresetFuture.thenCombine((CompletionStage)queryVoucherPresetFuture, this::createVoucherBalanceFieldMap);
        Map voucherPreset = (Map)queryVoucherPresetFuture.join();
        this.voucherFieldAndFieldNameConsumer.accept(voucherPreset);
        Map balanceVoucherField = (Map)balanceVoucherFieldMapFuture.join();
        DynamicObject balanceDy = (DynamicObject)queryBalanceFuture.join();
        Map balancePreset = (Map)queryBalancePresetFuture.join();
        this.balanceFieldAndFieldNameConsumer.accept(balancePreset);
        for (String selectField : balancePreset.keySet()) {
            this.balanceFieldAndValueConsumer.accept(selectField, balanceDy.get(selectField));
        }
        this.voucherExecuteQueryAndConsumeData(balanceVoucherField, balanceDy);
    }

    public void doAction() {
        Map<String, Tuple<Boolean, LocaleString>> balancePresetMap = this.getPropertyNameMap(DataModelPresetEnum.T_EPM_BALANCE, "epdm_balance", this.defaultBalanceFields);
        Map<String, Tuple<Boolean, LocaleString>> voucherPresetMap = this.getPropertyNameMap(DataModelPresetEnum.T_EPM_VOUCHER, "epdm_voucherdesc", this.defaultVoucherFields);
        Set<String> selectFields = balancePresetMap.keySet();
        QFBuilder qfBuilder = new QFBuilder("id", "=", this.balanceId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epdm_balance", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray());
        Map<String, String> voucherBalanceFieldMap = this.createVoucherBalanceFieldMap(balancePresetMap, voucherPresetMap);
        this.balanceFieldAndFieldNameConsumer.accept(balancePresetMap);
        for (String selectField : selectFields) {
            this.balanceFieldAndValueConsumer.accept(selectField, dynamicObject.get(selectField));
        }
        this.voucherExecuteQueryAndConsumeData(voucherBalanceFieldMap, dynamicObject);
        this.voucherFieldAndFieldNameConsumer.accept(voucherPresetMap);
    }

    private Map<String, Tuple<Boolean, LocaleString>> getPropertyNameMap(DataModelPresetEnum presetEnum, String formId, Set<String> defaultVoucherFields) {
        HashMap<String, Tuple<Boolean, LocaleString>> map = new HashMap<String, Tuple<Boolean, LocaleString>>(16);
        Multimap<String, EPDMDataModelPreset> preset = DataModelPresetHelper.queryPresetByFilter(qFilter -> qFilter.and("datamodel.number", "=", (Object)presetEnum.getNumber()));
        Map aliasPropertyMap = MetadataUtil.getAliasToPropertyName((String)formId);
        preset.forEach((k, v) -> {
            String field = v.getField();
            String property = (String)aliasPropertyMap.get(field.toUpperCase(Locale.ROOT));
            boolean preSet = v.isPreSet();
            if (defaultVoucherFields.contains(property) || !preSet && property.startsWith("dim")) {
                map.put(property, Tuple.create((Object)preSet, (Object)new LocaleString(v.getContent())));
            }
        });
        return map;
    }

    private Map<String, String> createVoucherBalanceFieldMap(Map<String, Tuple<Boolean, LocaleString>> balanceMap, Map<String, Tuple<Boolean, LocaleString>> voucherMap) {
        HashMap<String, String> map = new HashMap<String, String>(voucherMap.size());
        for (String voucherDimField : voucherMap.keySet()) {
            map.put(voucherDimField, null);
        }
        map.put("orgrow", "entity");
        map.put("account", "account");
        map.put("periodrow", "period");
        map.put("currencystr", "currencystr");
        for (int i = 1; i <= 100; ++i) {
            String balanceDimField = "dim" + i;
            if (!balanceMap.containsKey(balanceDimField) || !voucherMap.containsKey(balanceDimField)) continue;
            map.put(balanceDimField, balanceDimField);
        }
        return map;
    }

    private void voucherExecuteQueryAndConsumeData(Map<String, String> map, DynamicObject dy) {
        Set<String> selectFields = map.keySet();
        Object valueOrg = dy.get(map.get("orgrow"));
        Object valueAccount = dy.get(map.get("account"));
        Object valuePeriod = dy.get(map.get("periodrow"));
        Object valueCurrency = dy.get(map.get("currencystr"));
        if (StringUtils.isEmpty((String)String.valueOf(valueOrg)) || StringUtils.isEmpty((String)String.valueOf(valueAccount)) || StringUtils.isEmpty((String)String.valueOf(valuePeriod)) || StringUtils.isEmpty((String)String.valueOf(valueCurrency))) {
            this.balanceErrorRunner.run();
            return;
        }
        QFilter qFilterUser = new QFilter("orgrow", "=", valueOrg).and("account", "=", valueAccount).and("periodrow", "=", valuePeriod).and("currencystr", "=", valueCurrency);
        for (int i = 1; i <= 100; ++i) {
            Object value;
            String voucherDimField = "dim" + i;
            String propertyName = map.get(voucherDimField);
            if (null == propertyName || !StringUtils.isNotEmpty((String)(value = dy.get(propertyName)).toString())) continue;
            qFilterUser.and(voucherDimField, "=", value);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epdm_voucherdesc", (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter[]{qFilterUser});
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.voucherRowAndRowFieldConsumer.accept(selectFields, dynamicObject);
        }
    }
}

