/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.voucher;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.thread.EpbsThreadPools;
import kd.epm.epdm.common.util.LongUtil;

public class EPMDVoucherCollectBackService {
    private static final String QUERY_SQL = "select FID,fbatchno from t_epm_voucher where fbatchno != ' ' and fcollecttime is null";
    private static final String UPDATE_ROW_SQL = "UPDATE t_epm_voucher SET fcollectorid=?,fcollecttime=? WHERE fid=?";
    private static final Tuple<Long, Date> DEFAULT_COLLECT_INFO = new Tuple((Object)0L, null);
    private static final int BATCH_SIZE = 10000;
    private static final DBRoute dbRoute;

    public void afterCollect() {
        EpbsThreadPools.commonExecute(() -> this.doActionInLock((Consumer<DLock>)((Consumer)lock -> this.doAction())));
    }

    private void doAction() {
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        ArrayList<Long> deployIdList = new ArrayList<Long>(16);
        ArrayList<Runnable> action = new ArrayList<Runnable>(16);
        HashMap<String, Tuple<Long, Date>> deployCreateMap = new HashMap<String, Tuple<Long, Date>>(16);
        DB.query((DBRoute)dbRoute, (String)QUERY_SQL, rs -> {
            while (rs.next()) {
                String deployId = rs.getString("fbatchno");
                long id = rs.getLong("FID");
                Object[] objects = new Object[3];
                Tuple createInfo = (Tuple)deployCreateMap.get(deployId);
                if (createInfo != null) {
                    objects[0] = createInfo.item1;
                    objects[1] = createInfo.item2;
                } else {
                    deployIdList.add(LongUtil.toLong((String)deployId));
                    action.add(() -> {
                        Tuple tuple = (Tuple)deployCreateMap.get(deployId);
                        objects[0] = tuple.item1;
                        objects[1] = tuple.item2;
                    });
                }
                objects[2] = id;
                list.add(objects);
                this.doUpdate(list.size() > 10000, list, deployIdList, action, deployCreateMap);
            }
            return rs;
        });
        this.doUpdate(!list.isEmpty(), list, deployIdList, action, deployCreateMap);
    }

    private void doUpdate(boolean isUpdate, List<Object[]> list, List<Long> deployIdList, List<Runnable> action, Map<String, Tuple<Long, Date>> deployCreateMap) {
        if (!isUpdate) {
            return;
        }
        String selectFields = String.join((CharSequence)",", "createtime", "deployid", "creater");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epdm_etl_running_status", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("deployid", "in", deployIdList)});
        for (DynamicObject dynamicObject : query) {
            String deployId2 = dynamicObject.getString("deployid");
            long collectorId = dynamicObject.getLong("creater");
            Date collectDate = dynamicObject.getDate("createtime");
            deployCreateMap.put(deployId2, (Tuple<Long, Date>)new Tuple((Object)collectorId, (Object)collectDate));
        }
        deployIdList.forEach(deployId -> deployCreateMap.putIfAbsent(String.valueOf(deployId), DEFAULT_COLLECT_INFO));
        action.forEach(Runnable::run);
        DB.executeBatch((DBRoute)dbRoute, (String)UPDATE_ROW_SQL, list);
        list.clear();
        action.clear();
        deployIdList.clear();
    }

    private void doActionInLock(Consumer<DLock> consumer) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"EPMDVoucherHeadCreateService/createHead");
            lock.lock();
            consumer.accept((Object)lock);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    static {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"epdm_voucherdesc");
        dbRoute = new DBRoute(dataEntityType.getDBRouteKey());
    }
}

