/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.voucher;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.thread.EpbsFuture;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epdm.common.constant.EPDMConstant;
import kd.epm.epdm.common.constant.EPMDVoucherDescConstant;

public class EPMDVoucherHelper {
    public static String getId(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        return String.join((CharSequence)"\u3000", dynamicObject.getString("number"), dynamicObject.getString("sourcesys"), dynamicObject.getString("sourcestype"));
    }

    public static ThreeTuple<String, String, String> id2NumberSource(String id) {
        String[] split;
        if (id == null || (split = id.split("\u3000")).length != 3) {
            return new ThreeTuple(null, null, null);
        }
        return new ThreeTuple((Object)split[0], (Object)split[1], (Object)split[2]);
    }

    public static QFilter uniqueFilter(ThreeTuple<String, String, String> nextTuple) {
        return new QFilter("numberrow", "=", nextTuple.item1).and("sourcesysrow", "=", nextTuple.item2).and("sourcestyperow", "=", nextTuple.item3);
    }

    public static void queryCurrencyAccNumberIdMapThenDoAction(Map<String, Long> numberToIdMap, Set<String> currencyNumberSet, List<Runnable> setCurrencyIdFuncList) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", currencyNumberSet)});
        for (DynamicObject dynamicObject : dynamicObjects) {
            String number2 = dynamicObject.getString("number");
            long id = dynamicObject.getLong("id");
            numberToIdMap.put(number2, id);
        }
        currencyNumberSet.forEach(number -> numberToIdMap.putIfAbsent((String)number, -1L));
        setCurrencyIdFuncList.forEach(Runnable::run);
    }

    public static void queryCurrencyAccNumberIdMapThenDoAction2(Map<String, DynamicObject> numberToIdMap, Set<String> currencyNumberSet, List<Runnable> setCurrencyIdFuncList) {
        DynamicObject[] load;
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id,number,name,amtprecision,priceprecision,sign,isshowsign", (QFilter[])new QFilter[]{new QFilter("number", "in", currencyNumberSet)})) {
            String number = dynamicObject.getString("number");
            numberToIdMap.put(number, dynamicObject);
        }
        setCurrencyIdFuncList.forEach(Runnable::run);
    }

    public static DynamicObjectCollection queryByUniKey(ThreeTuple<String, String, String> uniqueKey) {
        QFilter qfBuilder = EPMDVoucherHelper.uniqueFilter(uniqueKey);
        MainEntityType voucherBaseType = MetadataServiceHelper.getDataEntityType((String)"epdm_voucherdesc");
        StringJoiner selectPropertiesJoiner = new StringJoiner(",");
        for (IDataEntityProperty property : voucherBaseType.getProperties()) {
            String field = property.getName();
            if (field == null || StringUtils.isEmpty((String)field) || property instanceof DynamicLocaleProperty) continue;
            selectPropertiesJoiner.add(field);
        }
        DynamicObjectCollection list = EPMDVoucherHelper.queryMaxMemoryError(t -> QueryServiceHelper.query((String)"epdm_voucherdesc", (String)selectPropertiesJoiner.toString(), (QFilter[])new QFilter[]{qfBuilder}));
        return list;
    }

    public static DynamicObject[] saveNew(DynamicObject dyFromPage) {
        EPMDVoucherHelper.setNumber(dyFromPage);
        IDataEntityType entityType = dyFromPage.getDataEntityType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        String pKey = entityType.getPrimaryKey().getName();
        Map<String, String> headField = properties.stream().filter(p -> p.getAlias() != null && StringUtils.isNotEmpty((String)p.getAlias())).filter(p -> !(p instanceof LongProp)).map(IMetadata::getName).filter(name -> !pKey.equals(name)).filter(name -> !"voucherrows.basecurrencybasedata".equals(name)).collect(Collectors.toMap(name -> name, name -> name + "row", (v1, v2) -> v1));
        DynamicObjectCollection collection = dyFromPage.getDynamicObjectCollection("voucherrows");
        if (collection.isEmpty()) {
            collection.add((Object)new DynamicObject(collection.getDynamicObjectType()));
        }
        for (DynamicObject dynamicObject : collection) {
            headField.forEach((k, v) -> dynamicObject.set(v, dyFromPage.get(k)));
        }
        DynamicObjectType dynamicObjectType = collection.getDynamicObjectType();
        DataEntityPropertyCollection properties1 = dynamicObjectType.getProperties();
        ArrayList<String> aliasList = new ArrayList<String>(16);
        HashMap<Object, String> aliasPropertyMap = new HashMap<Object, String>(16);
        ArrayList<String> pre = new ArrayList<String>(16);
        for (int i = 0; i < properties1.size(); ++i) {
            IDataEntityProperty property = (IDataEntityProperty)properties1.get(i);
            String alias = property.getAlias();
            String name2 = property.getName();
            if (!StringUtils.isNotEmpty((String)alias) || "fid".equalsIgnoreCase(alias) || property instanceof LongProp || "collectorrow".equals(name2)) continue;
            if (property instanceof BasedataProp) {
                ISimpleProperty refIdProp = ((BasedataProp)property).getDynamicComplexPropertyType().getPrimaryKey();
                String pK = refIdProp.getName();
                name2 = name2 + "." + pK;
            }
            aliasList.add(alias);
            pre.add("?");
            aliasPropertyMap.put(alias, name2);
        }
        aliasList.add("fid");
        pre.add("?");
        String sql = "INSERT INTO t_epm_voucher (" + String.join((CharSequence)",", aliasList) + ") VALUES(" + String.join((CharSequence)",", pre) + ")";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (DynamicObject dynamicObject : collection) {
            Object[] objects = new Object[aliasList.size()];
            for (int i = 0; i < aliasList.size() - 1; ++i) {
                String alias = (String)aliasList.get(i);
                String pName = (String)aliasPropertyMap.get(alias);
                Object value = dynamicObject.get(pName);
                if (value == null && "fcurrencyid".equalsIgnoreCase(alias)) {
                    value = 0L;
                }
                objects[i] = value;
            }
            objects[objects.length - 1] = IDService.get().genLongId();
            params.add(objects);
        }
        QFBuilder qfBuilder = new QFBuilder("numberrow", "=", (Object)dyFromPage.getString("number")).and("sourcesysrow", "=", (Object)dyFromPage.getString("sourcesys")).and("sourcestyperow", "=", (Object)dyFromPage.getString("sourcestype"));
        DeleteServiceHelper.delete((String)"epdm_voucherdesc", (QFilter[])qfBuilder.toArray());
        DB.executeBatch((DBRoute)EPDMConstant.DB_ROUTE, (String)sql, params);
        return new DynamicObject[]{dyFromPage};
    }

    private static void setNumber(DynamicObject dyFromPage) {
        String numberOld = dyFromPage.getString("number");
        String entityName = "epdm_voucher";
        String number = StringUtils.isEmpty((String)numberOld) ? EPMDVoucherHelper.genNewNumber(entityName) : numberOld;
        dyFromPage.set("number", (Object)number);
    }

    private static String genNewNumber(String entityName) {
        DynamicObject dy;
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        CodeRuleInfo codeRule = service.getCodeRule(entityName, dy = BusinessDataServiceHelper.newDynamicObject((String)entityName), null);
        if (codeRule == null) {
            Calendar instance = Calendar.getInstance();
            int year = instance.get(1);
            int month = instance.get(2) + 1;
            String p = month < 10 ? "P0" : "P";
            String prefix = "epm" + year + p + month;
            String numberField = "number";
            QFilter[] numberFilter = new QFilter[]{new QFilter(numberField, "like", (Object)(prefix + "%"))};
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)numberField, (QFilter[])numberFilter);
            int suffix = 1;
            for (DynamicObject dynamicObject : query) {
                String numberInDB = dynamicObject.getString(numberField);
                suffix = Math.max(suffix, EPMDVoucherHelper.getUseTime(prefix, numberInDB));
            }
            if (suffix > 99999999) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u8017\u5c3d,\u5f53\u5929\u53ea\u670999999999\u4e2a\u7f16\u7801,\u8bf7\u4fee\u6539\u7f16\u7801\u89c4\u5219\u3002", (String)"EPMDVoucherHelper_1", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            return prefix + String.format("%08d", suffix);
        }
        return service.getNumber(entityName, dy, null);
    }

    private static int getUseTime(String prefix, String numberInDB) {
        String suffix;
        if (numberInDB.contains(prefix) && StringUtils.isNotEmpty((String)(suffix = numberInDB.replace(prefix, "0")))) {
            try {
                return Integer.parseInt(suffix) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void fillByTemplate(Object tempId, IDataModel dataModel) {
        MainEntityType voucherBaseType = MetadataServiceHelper.getDataEntityType((String)"epdm_voucherbase");
        DataEntityPropertyCollection properties = voucherBaseType.getProperties();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)tempId, (String)"epdm_vouchertemplate");
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if ("id".equals(name) || property instanceof DynamicLocaleProperty) continue;
            if (property instanceof EntryProp) {
                dataModel.deleteEntryData(name);
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(name);
                DynamicObjectType propertyType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entityProperties = propertyType.getProperties();
                for (int i = 0; i < collection.size(); ++i) {
                    dataModel.createNewEntryRow(name);
                    for (IDataEntityProperty entityProperty : entityProperties) {
                        String entityPName = entityProperty.getName();
                        if ("id".equals(entityPName) || "seq".equals(entityPName)) continue;
                        dataModel.setValue(entityPName, ((DynamicObject)collection.get(i)).get(entityPName), i);
                    }
                }
                continue;
            }
            dataModel.setValue(name, dynamicObject.get(name));
        }
    }

    public static void fillByQuery(ThreeTuple<String, String, String> uniqueKey, IDataModel dataModel) {
        DynamicObjectCollection dynamicObjects = EPMDVoucherHelper.queryByUniKey(uniqueKey);
        dataModel.deleteEntryData("voucherrows");
        MainEntityType voucherType = MetadataServiceHelper.getDataEntityType((String)"epdm_voucher");
        DataEntityPropertyCollection properties = voucherType.getProperties();
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)"voucherrows");
        HashSet<String> noAliasField = new HashSet<String>(4);
        noAliasField.add("seq");
        noAliasField.add("accounting");
        noAliasField.add("accountname");
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            dataModel.createNewEntryRow("voucherrows");
            DynamicObjectType propertyType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection entityProperties = propertyType.getProperties();
            for (IDataEntityProperty entityProperty : entityProperties) {
                String name = entityProperty.getName();
                if (name.endsWith("basedata") || "id".equals(name) || entityProperty instanceof LongProp || noAliasField.contains(name) || entityProperty instanceof DynamicLocaleProperty) continue;
                dataModel.setValue(name, dynamicObject.get(name), i);
            }
        }
        if (!dynamicObjects.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            for (IDataEntityProperty dataEntityProperty : properties) {
                String name = dataEntityProperty.getName();
                if (name.endsWith("basedata") || name.endsWith("basefilter") || "id".equals(name) || "".equals(dataEntityProperty.getAlias()) || dataEntityProperty instanceof LongProp || dataEntityProperty instanceof EntryProp || dataEntityProperty instanceof DynamicLocaleProperty) continue;
                String nameRow = name + "row";
                dataModel.setValue(name, dynamicObject.get(nameRow));
            }
        }
    }

    public static List<String> changeStatus(Collection<ThreeTuple<String, String, String>> rows, EPMDVoucherDescConstant.BillStatus sourceStatus, EPMDVoucherDescConstant.BillStatus targetStatus, boolean isPartSaveAble) {
        ConcurrentSkipListSet<String> failMsg = new ConcurrentSkipListSet<String>();
        ArrayList<EpbsFuture> task = new ArrayList<EpbsFuture>(16);
        String userName = RequestContext.get().getUserName();
        Date now = TimeServiceHelper.now();
        for (ThreeTuple<String, String, String> row : rows) {
            String number = (String)row.item1;
            String sourceType = (String)row.item3;
            if (EPMDVoucherDescConstant.SourcesType.A.getCode().equals(sourceType)) {
                failMsg.add(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\uff1a%1$s\u6765\u6e90\u7c7b\u578b\u4e3a\u51ed\u8bc1\u91c7\u96c6\uff0c\u4e0d\u80fd\u6267\u884c%2$s\u64cd\u4f5c\u3002", (String)"EPMDVoucherHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), number, targetStatus.getAction()));
                continue;
            }
            QFilter uniqueQfBuilder = EPMDVoucherHelper.uniqueFilter(row);
            EpbsFuture future = EpbsFuture.supplyAsync(() -> {
                ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                String sourceStatusCode = sourceStatus.getCode();
                if (QueryServiceHelper.exists((String)"epdm_voucherdesc", (QFilter[])new QFilter[]{uniqueQfBuilder, new QFilter("billstatusrow", "!=", (Object)sourceStatusCode)})) {
                    failMsg.add(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\uff1a%1$s\u975e%2$s\u72b6\u6001\uff0c\u4e0d\u80fd\u6267\u884c%3$s\u64cd\u4f5c\u3002", (String)"EPMDVoucherHelper_3", (String)"epm-epbs-business", (Object[])new Object[0]), number, sourceStatus.getDes(), targetStatus.getAction()));
                } else {
                    QFilter qFilter = uniqueQfBuilder.and("billstatusrow", "=", (Object)sourceStatusCode);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"epdm_voucherdesc", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    for (DynamicObject dynamicObject : query) {
                        long id = dynamicObject.getLong("id");
                        Object[] param = new Object[]{targetStatus.getCode(), userName, now, id};
                        params.add(param);
                    }
                }
                return params;
            });
            task.add(future);
        }
        List params = task.stream().map(EpbsFuture::join).flatMap(Collection::stream).collect(Collectors.toList());
        if ((isPartSaveAble || failMsg.isEmpty()) && !params.isEmpty()) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"epdm_voucherdesc");
            String dbRouteKey = dataEntityType.getDBRouteKey();
            String sql = "UPDATE t_epm_voucher SET fbillstatus=?, fmodifierid=?, fmodifytime=? WHERE fid=?";
            DB.executeBatch((DBRoute)new DBRoute(dbRouteKey), (String)sql, params);
        }
        if (!failMsg.isEmpty()) {
            int all = rows.size();
            int failNum = failMsg.size();
            String headMessage = String.format(ResManager.loadKDString((String)"\u5171\u6267\u884c\u8bb0\u5f55%1$s\u6761\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"EPMDVoucherHelper_4", (String)"epm-epbs-business", (Object[])new Object[0]), all, all - failNum, failNum);
            ArrayList<String> list = new ArrayList<String>(failMsg);
            list.add(0, headMessage);
            return list;
        }
        return Collections.emptyList();
    }

    public static Set<Long> getDeleteAbleIds(Set<Object> collect, Predicate<DynamicObject> objectPredicate) {
        if (collect.isEmpty()) {
            return Collections.emptySet();
        }
        Iterator<Object> iterator = collect.iterator();
        Object id = iterator.next();
        ThreeTuple<String, String, String> tuple = EPMDVoucherHelper.id2NumberSource(id.toString());
        QFilter oneVoucherFilter = EPMDVoucherHelper.uniqueFilter(tuple);
        while (iterator.hasNext()) {
            Object nextId = iterator.next();
            ThreeTuple<String, String, String> nextTuple = EPMDVoucherHelper.id2NumberSource(nextId.toString());
            oneVoucherFilter.or(EPMDVoucherHelper.uniqueFilter(nextTuple));
        }
        String selectProperties = new StringJoiner(",").add("id").add("numberrow").add("billstatusrow").add("sourcestyperow").toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epdm_voucherdesc", (String)selectProperties, (QFilter[])new QFilter[]{oneVoucherFilter});
        return query.stream().filter(objectPredicate).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
    }

    private EPMDVoucherHelper() {
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"EPMDVoucherHelper_5", (String)"epm-epbs-business", (Object[])new Object[0]), this.getClass().getName());
        throw new IllegalStateException(msg);
    }

    public static <R> R queryMaxMemoryError(Function<Object, R> function) {
        try {
            return function.apply(null);
        }
        catch (OrmException e) {
            String errmsg = "exceed max memory limit";
            if (e.getMessage().contains(errmsg)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u51ed\u8bc1\u884c\u6570\u636e\u8d85\u8fc7\u4e86\u5e73\u53f0\u6307\u5b9a\u7684\u6700\u5927\u5185\u5b58\u9650\u5236\u3002", (String)"EPMDVoucherHelper_6", (String)"epm-epbs-business", (Object[])new Object[0]));
            }
            throw e;
        }
    }
}

