/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.business.voucher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.service.ExportBillListService;
import kd.epm.epbs.common.service.ExportVoucherService;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetHelper;
import kd.epm.epdm.business.voucher.EPMDVoucherHelper;
import kd.epm.epdm.common.entity.EPDMDataModelPreset;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.util.MetadataUtil;

public class EPMDVoucherServiceHelper {
    public static final String ORG_FILTER = "orgbasefilter";
    public static final String PERIOD_FILTER = "periodbasefilter";
    public static final String VOUCHER_ROWS = "voucherrows.";
    public static final String VOUCHER_ROW_ACCOUNT = "voucherrows.account";
    private static final String VOUCHER_ROWS_ACCOUNTING = "voucherrows.accounting";
    private static final String VOUCHER_ROWS_ACCOUNT_NAME = "voucherrows.accountname";
    public static final String VOUCHER_ROW_DIM = "voucherrows.";
    public static final String CURRENCY_STR = "voucherrows.currencystr";
    public static final String CURRENCY = "voucherrows.currency";

    public static void addUserPresetToCol(List<IListColumn> listColumns) {
        DataModelPresetHelper.addUserPresetToCol(listColumns, DataModelPresetEnum.T_EPM_VOUCHER, 6);
    }

    public static void export(BillList billList, Consumer<QFilter[]> dealQFilter) {
        Collection<EPDMDataModelPreset> dataModelPresetsLineDim = DataModelPresetHelper.getDataModelPresetsLineDim();
        Map<String, EPDMDataModelPreset> dimToPreset = dataModelPresetsLineDim.stream().collect(Collectors.toMap(EPDMDataModelPreset::getField, a -> a, (v1, v2) -> v1));
        Set<String> dimSetting = DataModelPresetHelper.getDimSetting();
        Map aliasToProperty = MetadataUtil.getAliasToProperty((String)"epdm_voucherdesc");
        ExportVoucherService service = new ExportVoucherService(billList, ResManager.loadKDString((String)"\u51ed\u8bc1\u5bfc\u51fa", (String)"EPMDVoucherServiceHelper_1", (String)"epm-epbs-business", (Object[])new Object[0])){

            public void dealCommonBaseDataFilter() {
                super.dealCommonBaseDataFilter();
                EPMDVoucherServiceHelper.dealCommonBaseDataFilter(this.filters.toArray(new QFilter[0]));
            }
        };
        service.dealCommonBaseDataFilter();
        for (String alias : dimToPreset.keySet()) {
            IDataEntityProperty property2 = (IDataEntityProperty)aliasToProperty.get(alias.toUpperCase(Locale.ROOT));
            String name = property2.getName();
            service.addSelectFields(new String[]{name});
        }
        LinkedList<String> accNumbers = new LinkedList<String>();
        LinkedList<Runnable> setAccName = new LinkedList<Runnable>();
        HashMap<String, String> accNumberNameMap = new HashMap<String, String>(16);
        service.addUserActions("accountname", (row, cell) -> {
            String accNumber = row.getString("account");
            accNumbers.add(accNumber);
            setAccName.add(() -> cell.setCellValue((String)accNumberNameMap.get(accNumber)));
        });
        service.addUserActions("accounting", (row, cell) -> {
            StringJoiner joiner = new StringJoiner(",");
            for (String propertyName : dimSetting) {
                String key = "f" + propertyName;
                EPDMDataModelPreset epdmDataModelPreset = (EPDMDataModelPreset)dimToPreset.get(key);
                if (epdmDataModelPreset == null) continue;
                String name = epdmDataModelPreset.getContent();
                String value = row.getString(propertyName);
                if (null == value) continue;
                joiner.add(name + ":" + value);
            }
            cell.setCellValue(joiner.toString());
        });
        EntityType entityType = billList.getEntityType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        properties.stream().filter(property -> property instanceof ComboProp).map(ComboProp.class::cast).forEach(arg_0 -> EPMDVoucherServiceHelper.lambda$export$8(aliasToProperty, (ExportBillListService)service, arg_0));
        List filters = service.getFilters();
        dealQFilter.accept(filters.toArray(new QFilter[0]));
        service.queryData();
        DataModelPresetHelper.queryPresetAccNumberNameMapThenDoAction(DataModelPresetEnum.T_EPM_VOUCHER, accNumberNameMap, accNumbers, setAccName);
        service.export();
    }

    public static void dealCommonBaseDataFilter(QFilter[] filters) {
        for (QFilter filter : filters) {
            String property = filter.getProperty();
            String filterCP = filter.getCP();
            String entityName = "";
            if (property.startsWith(ORG_FILTER)) {
                entityName = "bos_org";
            } else {
                if (!property.startsWith(PERIOD_FILTER)) continue;
                entityName = "bd_period";
            }
            Object value = filter.getValue();
            BillEntityType dataEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)entityName);
            String billNo = dataEntityType.getBillNo();
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)billNo, (QFilter[])new QFilter[]{new QFilter(dataEntityType.getPrimaryKey().getName(), filterCP, value)});
            if (query.isEmpty()) {
                filter.__setProperty("1");
                filter.__setCP("=");
                filter.__setValue((Object)1);
                continue;
            }
            List list = query.stream().map(dy -> dy.get(billNo)).collect(Collectors.toList());
            int base = property.indexOf("basefilter");
            filter.__setProperty(property.substring(0, base));
            List v = "in".equals(filter.getCP()) ? list : list.get(0);
            filter.__setValue(v);
        }
    }

    public static String registerProperty(DynamicObjectType dt, String selectFields) {
        StringBuilder selectFieldsFinal = new StringBuilder(selectFields);
        dt.registerSimpleProperty(new DynamicSimpleProperty(VOUCHER_ROWS_ACCOUNTING, String.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty(VOUCHER_ROWS_ACCOUNT_NAME, String.class, null));
        Set<String> dimSetting = DataModelPresetHelper.getDimSetting();
        for (String dim : dimSetting) {
            String dimRow = "voucherrows." + dim;
            selectFieldsFinal.append(",").append(dimRow);
            if (selectFields.contains(dimRow)) continue;
            dt.registerSimpleProperty(new DynamicSimpleProperty(dimRow, String.class, null));
        }
        dt.registerSimpleProperty(new DynamicSimpleProperty("voucherrows.basecurrencybasedata", String.class, null));
        DataEntityPropertyCollection properties = dt.getProperties();
        EPMDVoucherServiceHelper.registerDefault(dt, selectFieldsFinal, properties, VOUCHER_ROW_ACCOUNT, VOUCHER_ROWS_ACCOUNT_NAME, "voucherrows.basecurrency", CURRENCY_STR, CURRENCY);
        return selectFieldsFinal.toString();
    }

    private static void registerDefault(DynamicObjectType dt, StringBuilder selectFieldsFinal, DataEntityPropertyCollection properties, String ... defaultKeys) {
        for (String defaultKey : defaultKeys) {
            if (properties.containsKey((Object)defaultKey)) continue;
            selectFieldsFinal.append(",").append(defaultKey);
            dt.registerSimpleProperty(new DynamicSimpleProperty(defaultKey, String.class, null));
        }
    }

    public static void dealAccountNameAndAccountingToDy(DynamicObjectCollection pageData) {
        Collection<EPDMDataModelPreset> dataModelPresetsLineDim = DataModelPresetHelper.getDataModelPresetsLineDim();
        Map<String, EPDMDataModelPreset> dimToPreset = dataModelPresetsLineDim.stream().collect(Collectors.toMap(EPDMDataModelPreset::getField, a -> a, (v1, v2) -> v1));
        Set<String> dimSetting = DataModelPresetHelper.getDimSetting();
        ArrayList<String> accList = new ArrayList<String>(pageData.size());
        ArrayList<Runnable> setAccNameFunc = new ArrayList<Runnable>(pageData.size());
        HashMap<String, String> map = new HashMap<String, String>(16);
        HashSet<String> currencyList = new HashSet<String>(pageData.size());
        ArrayList<Runnable> setCurrencyFunc = new ArrayList<Runnable>(pageData.size());
        HashMap<String, DynamicObject> numberDynamicMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject pageDatum : pageData) {
            EPMDVoucherServiceHelper.dealAccounting(dimSetting, dimToPreset, pageDatum);
            String accNumber = pageDatum.getString(VOUCHER_ROW_ACCOUNT);
            accList.add(accNumber);
            setAccNameFunc.add(() -> pageDatum.set(VOUCHER_ROWS_ACCOUNT_NAME, map.get(accNumber)));
            String curNumber = pageDatum.getString("voucherrows.basecurrency");
            currencyList.add(curNumber);
            setCurrencyFunc.add(() -> pageDatum.set("voucherrows.basecurrencybasedata", numberDynamicMap.get(curNumber)));
            String curNumberStr = pageDatum.getString(CURRENCY_STR);
            currencyList.add(curNumberStr);
            setCurrencyFunc.add(() -> pageDatum.set(CURRENCY, numberDynamicMap.get(curNumberStr)));
        }
        DataModelPresetHelper.queryPresetAccNumberNameMapThenDoAction(DataModelPresetEnum.T_EPM_VOUCHER, map, accList, setAccNameFunc);
        EPMDVoucherHelper.queryCurrencyAccNumberIdMapThenDoAction2(numberDynamicMap, currencyList, setCurrencyFunc);
    }

    private static void dealAccounting(Set<String> dimSetting, Map<String, EPDMDataModelPreset> dimToPreset, DynamicObject pageDatum) {
        IDataEntityType dataEntityType = pageDatum.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        StringJoiner joiner = new StringJoiner(",");
        for (String propertyName : dimSetting) {
            String value;
            String key = "f" + propertyName;
            EPDMDataModelPreset epdmDataModelPreset = dimToPreset.get(key);
            if (epdmDataModelPreset == null) continue;
            String name = epdmDataModelPreset.getContent();
            String dim = "voucherrows." + propertyName;
            if (!properties.containsKey((Object)dim) || !StringUtils.isNotEmpty((String)(value = pageDatum.getString(dim)))) continue;
            joiner.add(name + ":" + value);
        }
        pageDatum.set(VOUCHER_ROWS_ACCOUNTING, (Object)joiner.toString());
    }

    private EPMDVoucherServiceHelper() {
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"EPMDVoucherServiceHelper_2", (String)"epm-epbs-business", (Object[])new Object[0]), this.getClass().getName());
        throw new IllegalStateException(msg);
    }

    private static /* synthetic */ void lambda$export$8(Map aliasToProperty, ExportBillListService service, ComboProp p) {
        Map<String, String> collect = p.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, i -> i.getName().getLocaleValue()));
        IDataEntityProperty property = (IDataEntityProperty)aliasToProperty.get(p.getAlias().toUpperCase(Locale.ROOT));
        String colNumber = property.getName();
        service.addUserActions(p.getName(), (row, cell) -> cell.setCellValue((String)collect.get(row.getString(colNumber))));
    }

    public static enum ButtonEnum {
        SAVE(new MultiLangEnumBridge("\u4fdd\u5b58", "EPMDVoucherServiceHelper_3", "epm-epbs-business"), new MultiLangEnumBridge("\u3010%1$s\u3011\u4fdd\u5b58\u6210\u529f\u3002", "EPMDVoucherServiceHelper_4", "epm-epbs-business")),
        SUBMIT(new MultiLangEnumBridge("\u63d0\u4ea4", "EPMDVoucherServiceHelper_5", "epm-epbs-business"), new MultiLangEnumBridge("\u3010%1$s\u3011\u63d0\u4ea4\u6210\u529f\u3002", "EPMDVoucherServiceHelper_6", "epm-epbs-business")),
        REJECT(new MultiLangEnumBridge("\u9a73\u56de", "EPMDVoucherServiceHelper_7", "epm-epbs-business"), new MultiLangEnumBridge("\u3010%1$s\u3011\u9a73\u56de\u6210\u529f\u3002", "EPMDVoucherServiceHelper_8", "epm-epbs-business")),
        REPOSTING(new MultiLangEnumBridge("\u53cd\u8fc7\u8d26", "EPMDVoucherServiceHelper_9", "epm-epbs-business"), new MultiLangEnumBridge("\u3010%1$s\u3011\u53cd\u8fc7\u8d26\u6210\u529f\u3002", "EPMDVoucherServiceHelper_10", "epm-epbs-business")),
        POSTING(new MultiLangEnumBridge("\u8fc7\u8d26", "EPMDVoucherServiceHelper_11", "epm-epbs-business"), new MultiLangEnumBridge("\u3010%1$s\u3011\u8fc7\u8d26\u6210\u529f\u3002", "EPMDVoucherServiceHelper_12", "epm-epbs-business"));

        private final MultiLangEnumBridge buttonName;
        private final MultiLangEnumBridge successTip;

        private ButtonEnum(MultiLangEnumBridge buttonName, MultiLangEnumBridge successTip) {
            this.buttonName = buttonName;
            this.successTip = successTip;
        }

        public String getButtonName() {
            return this.buttonName.getLocaleString().getLocaleValue();
        }

        public MultiLangEnumBridge getButtonNameLocale() {
            return this.buttonName;
        }

        public String getSuccessTip() {
            return this.successTip.getLocaleString().getLocaleValue();
        }

        public MultiLangEnumBridge getSuccessTipLocale() {
            return this.successTip;
        }
    }
}

