/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.mservice.upgrade;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.epbs.business.permission.util.DmpLoginModel;
import kd.epm.epbs.business.permission.util.DmpServiceHelper;
import kd.epm.epbs.business.permission.util.MetaDataCheckUtils;
import kd.epm.epbs.common.annotation.SDKMsService;
import kd.epm.epbs.common.configuration.factory.ConfigurationFactory;
import kd.epm.epbs.common.thread.EpbsThreadPools;

@SDKMsService
public class EpmCustomMetaPageCheckService
implements IUpgradeService {
    protected static final Log log = LogFactory.getLog(EpmCustomMetaPageCheckService.class);
    private DmpServiceHelper dmpApi;

    public DmpServiceHelper getDmpApi() {
        if (this.dmpApi == null) {
            Map dmpMap = ConfigurationFactory.readFileProps((String)"epbs/dmp_conf.properties");
            this.dmpApi = new DmpServiceHelper(DmpLoginModel.create((Map)dmpMap));
        }
        return this.dmpApi;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        EpbsThreadPools.commonExecute(() -> this.syncDmp(null));
        return new UpgradeResult();
    }

    public void syncDmp(Map<String, Map<String, List<String>>> data) {
        try {
            if (data == null) {
                data = MetaDataCheckUtils.scanData();
            }
            if (data.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry appnum : data.entrySet()) {
                for (Map.Entry isv : ((Map)appnum.getValue()).entrySet()) {
                    if (sb.length() > 1900) {
                        this.sendBug(sb + "<br>");
                        sb = new StringBuilder();
                    }
                    String format = String.format(ResManager.loadKDString((String)"\u5e94\u7528(%1$s)\u6807\u8bc6(%2$s)\u5143\u6570\u636e:", (String)"EpmCustomMetaPageCheckService_1", (String)"epm-epbs-mservice", (Object[])new Object[0]), appnum.getKey(), isv.getKey());
                    sb.append(format);
                    for (String entitynumber : (List)isv.getValue()) {
                        if (sb.length() > 1980) {
                            this.sendBug(sb + "<br>");
                            sb = new StringBuilder(format);
                        }
                        sb.append(",").append(entitynumber);
                    }
                }
            }
            if (sb.length() > 0) {
                this.sendBug(sb.toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            this.printError(e.getMessage());
        }
    }

    public void printError(String errorLog) {
        HashMap<String, Map> error = new HashMap<String, Map>(16);
        error.computeIfAbsent("error", k -> new HashMap()).put("error", Collections.singletonList("error:" + errorLog));
        MetaDataCheckUtils.syncDB(error);
    }

    private void sendBug(String bugDesc) {
        this.getDmpApi().sendBugData(e -> e.put("bugdes", bugDesc));
    }
}

