/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.mservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.mservice.EPDMDataRequest;
import kd.epm.epbs.business.mservice.EPDMDataResponse;
import kd.epm.epbs.business.mservice.EPDMRequest;
import kd.epm.epbs.common.annotation.SDKMsService;
import kd.epm.epbs.common.util.D;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epdm.business.datamodel.helper.DataModelCURDServiceHelper;
import kd.epm.epdm.business.datamodel.helper.DataModelServiceHelper;
import kd.epm.epdm.business.etl.helper.MainModelServiceHelper;
import kd.epm.epdm.common.database.AbsDataSource;
import kd.epm.epdm.common.database.DbQueryUtils;
import kd.epm.epdm.common.database.IDataSource;
import kd.epm.epdm.common.database.ModelUtils;
import kd.epm.epdm.common.enums.CataLogPresetEnum;
import kd.epm.epdm.common.enums.DBTypeEnum;
import kd.epm.epdm.common.enums.ResourceTypeEnum;
import kd.epm.epdm.common.enums.form.EpdmDataQueryTaskEnum;
import kd.epm.epdm.common.enums.form.EpdmDatamodelEnum;
import kd.epm.epdm.common.util.MetadataUtil;
import kd.epm.epdm.mservice.DataModelService;

@SDKMsService
public class DataModelServiceImpl
implements DataModelService {
    private static final Log log = LogFactory.getLog(DataModelServiceImpl.class);

    @Override
    public Map<String, Object> query(Map<String, Object> params) {
        String number = (String)params.get("number");
        if (StringUtils.isEmpty((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u7f16\u7801\u3002", (String)"DataModelServiceImpl_1", (String)"epm-epbs-mservice", (Object[])new Object[0]));
        }
        String type = (String)params.get("type");
        if (StringUtils.isEmpty((String)type)) {
            StringBuilder msg = new StringBuilder();
            for (ResourceTypeEnum value : ResourceTypeEnum.values()) {
                msg.append(value.getNumber()).append(":").append(value.getName().getDescription()).append("|");
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u6a21\u578b\u7c7b\u578b(type)\uff0c\u652f\u6301\u7c7b\u578b\uff1a%s\u3002", (String)"DataModelServiceImpl_2", (String)"epm-epbs-mservice", (Object[])new Object[0]), msg.substring(0, msg.length() - 1)));
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        String catalog = (String)params.get("catalog");
        if (StringUtils.isEmpty((String)catalog)) {
            qFilter.and(new QFilter("catalog.long_number", "like", (Object)(CataLogPresetEnum.EPM_THEME.getLongNumber() + "%")));
        } else {
            qFilter.and(new QFilter("catalog.long_number", "like", (Object)(catalog + "%")));
        }
        qFilter.and(new QFilter("type", "=", (Object)type));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epdm_dm", (String)"name, details_tag", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject == null) {
            String id = (String)params.get("id");
            if (StringUtils.isNumeric((String)id)) {
                qFilter = new QFilter("id", "=", (Object)D.l((Object)id));
                qFilter.and(new QFilter("number", "=", (Object)number));
                qFilter.and(new QFilter("type", "=", (Object)type));
                dynamicObject = QueryServiceHelper.queryOne((String)"epdm_dm", (String)"name, details_tag", (QFilter[])new QFilter[]{qFilter});
            }
            if (dynamicObject == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5171\u6a21\u578b\u6a21\u578b\u96c6\u4e0b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7c7b\u578b\u4e3a%2$s\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"DataModelServiceImpl_3", (String)"epm-epbs-mservice", (Object[])new Object[0]), number, type));
            }
        }
        JSONArray jsonArray = DataModelServiceHelper.get().getDataModelFields(dynamicObject);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("number", number);
        data.put("name", dynamicObject.getString("name"));
        data.put("details", jsonArray);
        return data;
    }

    @Override
    public EPDMDataResponse<Map<String, Object>> getQueryId(EPDMDataRequest request) {
        EPDMDataResponse response = new EPDMDataResponse(500, "ERROR");
        if (null == request) {
            response.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataModelServiceImpl_4", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        if (StringUtils.isEmpty((String)request.getModel())) {
            response.setMessage(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u8981\u67e5\u8be2\u7684\u6a21\u578b\u7f16\u7801", (String)"DataModelServiceImpl_5", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        if (StringUtils.isEmpty((String)request.getApp())) {
            response.setMessage(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u8c03\u7528\u65b9\u5e94\u7528\u7f16\u7801", (String)"DataModelServiceImpl_6", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        if (StringUtils.isEmpty((String)request.getCache())) {
            request.setCache("Y");
        }
        DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)EpdmDataQueryTaskEnum.getFormId());
        long id = GlobalIdUtil.genGlobalLongId();
        task.set(EpdmDataQueryTaskEnum.id.name(), (Object)id);
        task.set(EpdmDataQueryTaskEnum.number.name(), (Object)GlobalIdUtil.genStringId());
        task.set(EpdmDataQueryTaskEnum.status.name(), (Object)"0");
        task.set(EpdmDataQueryTaskEnum.action.name(), (Object)"R");
        task.set(EpdmDataQueryTaskEnum.app.name(), (Object)request.getApp());
        task.set(EpdmDataQueryTaskEnum.params.name(), (Object)JSON.toJSONString((Object)request));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        response.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u4efb\u52a1\u521b\u5efa\u6210\u529f", (String)"DataModelServiceImpl_7", (String)"epm-epbs-mservice", (Object[])new Object[0]));
        response.setCode(200);
        response.setData(new HashMap());
        ((Map)response.getData()).put("qid", id);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EPDMDataResponse<List<Map<String, Object>>> queryData(long queryId) {
        EPDMDataResponse response = new EPDMDataResponse(500, "ERROR");
        String status = "3";
        EPDMDataRequest request = null;
        try {
            DynamicObject cfg;
            AbsDataSource ds;
            DynamicObject modelObject;
            request = (EPDMDataRequest)DataModelCURDServiceHelper.toRequest((long)queryId, EPDMDataRequest.class).get(0);
            String modelNumber = request.getModel();
            if (StringUtils.isEmpty((String)modelNumber)) {
                response.setMessage(ResManager.loadKDString((String)"\u8bf7\u4f20\u6a21\u578bID/\u7f16\u7801\u3002", (String)"DataModelServiceImpl_8", (String)"epm-epbs-mservice", (Object[])new Object[0]));
                EPDMDataResponse ePDMDataResponse = response;
                return ePDMDataResponse;
            }
            String from = null;
            if (StringUtils.isNumeric((String)modelNumber)) {
                QFilter qFilter = new QFilter("id", "=", (Object)D.l((Object)modelNumber));
                modelObject = QueryServiceHelper.queryOne((String)"epdm_dm", (String)"id,number,type", (QFilter[])new QFilter[]{qFilter});
                if (null == modelObject) {
                    modelObject = QueryServiceHelper.queryOne((String)EpdmDatamodelEnum.getFormId(), (String)"id,number,type", (QFilter[])new QFilter[]{qFilter});
                    from = "epdm";
                }
            } else {
                QFilter qFilter = new QFilter("number", "=", (Object)modelNumber);
                modelObject = QueryServiceHelper.queryOne((String)"epdm_dm", (String)"id,number,type", (QFilter[])new QFilter[]{qFilter});
            }
            if (modelObject == null) {
                response.setMessage(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684\u6570\u636e\u6a21\u578b\u3002", (String)"DataModelServiceImpl_9", (String)"epm-epbs-mservice", (Object[])new Object[0]), modelNumber));
                EPDMDataResponse ePDMDataResponse = response;
                return ePDMDataResponse;
            }
            String type = modelObject.getString("type");
            if (!ResourceTypeEnum.DataTable.getNumber().equalsIgnoreCase(type) && !ResourceTypeEnum.DataView.getNumber().equalsIgnoreCase(type)) {
                response.setMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\uff08%2$s\uff09\u4e0d\u652f\u6301\u6570\u636e\u67e5\u8be2\u3002", (String)"DataModelServiceImpl_10", (String)"epm-epbs-mservice", (Object[])new Object[0]), modelObject.get("number"), type));
                EPDMDataResponse ePDMDataResponse = response;
                return ePDMDataResponse;
            }
            String linkNumber = request.getLink();
            String dbRoute = request.getDbRoute();
            if (StringUtils.isEmpty((String)dbRoute)) {
                dbRoute = MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()).getRouteKey();
            }
            if (null == (ds = DbQueryUtils.getDataSource((DynamicObject)(cfg = MainModelServiceHelper.getLink((String)linkNumber)), (String)dbRoute))) {
                response.setMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%1$s\u201d\uff08%2$s\uff09\uff0c\u83b7\u53d6\u6570\u636e\u94fe\u63a5\u5931\u8d25\u3002", (String)"DataModelServiceImpl_11", (String)"epm-epbs-mservice", (Object[])new Object[0]), cfg.get("name"), cfg.get("number")));
                EPDMDataResponse ePDMDataResponse = response;
                return ePDMDataResponse;
            }
            request.setOraLike(Boolean.valueOf(DBTypeEnum.ORACLE.name().equalsIgnoreCase(ds.getType().name())));
            if (null == ds.dbRoute()) {
                ds.setDbRoute(MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()));
            }
            response.setData(this.getRows(request, from, modelObject.get("id"), ds));
            response.setCode(200);
            response.setMessage("OK");
            response.setWhere(request.where());
            if (null == response.getPager()) {
                response.setPager(new EPDMDataResponse.Pager());
            }
            response.getPager().setTotal(request.getTotal());
            response.getPager().setSize(request.getSize());
            response.getPager().setPage(request.getPage());
            response.getPager().setLast(request.getLastPage());
            status = request.getPage() >= request.getLastPage() ? "3" : "1";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.setCode(500);
            response.setMessage(e.getMessage());
            status = "2";
        }
        finally {
            DataModelCURDServiceHelper.updateQueryTaskStatus((long)queryId, (String)status, (EPDMRequest)request, (boolean)true);
        }
        return response;
    }

    private List<Map<String, Object>> getRows(EPDMDataRequest request, String from, Object model, AbsDataSource ds) throws SQLException {
        String sql;
        String selectFields;
        String table;
        DynamicObject modelObject;
        if ("epdm".equalsIgnoreCase(from)) {
            modelObject = BusinessDataServiceHelper.loadSingle((Object)model, (String)EpdmDatamodelEnum.getFormId());
            table = EpdmDatamodelEnum.table.getString(modelObject);
        } else {
            modelObject = BusinessDataServiceHelper.loadSingle((Object)model, (String)"epdm_dm");
            table = ModelUtils.getTableFormModel((DynamicObject)modelObject, (AbsDataSource)ds);
        }
        if (!ds.tableExists(table, null)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201d%s\u201d\u8868/\u89c6\u56fe\u5728\u5f53\u524d\u8fde\u63a5\u914d\u7f6e\u4e2d\u4e0d\u5b58\u5728", (String)"DataModelServiceImpl_12", (String)"epm-epbs-mservice", (Object[])new Object[0]), table));
        }
        if (request.getTotal() == 0) {
            String where = request.where();
            String countSql = "select count(1) from " + table.toLowerCase(Locale.ROOT) + " " + where;
            request.setTotal(DbQueryUtils.count((IDataSource)ds, (String)countSql));
            int lastPage = (int)Math.ceil((double)request.getTotal() / (double)request.getSize());
            request.setLastPage(lastPage);
        }
        EPDMDataRequest.GroupEntity group = request.group();
        HashMap<String, Integer> fieldMap = null;
        if (null != request.getSelectFields() && !request.getSelectFields().isEmpty()) {
            fieldMap = new HashMap<String, Integer>(request.getSelectFields().size());
            for (String k : request.getSelectFields()) {
                fieldMap.put(k, 1);
            }
        }
        if (null == group) {
            selectFields = ModelUtils.getSelectFields((DynamicObject)modelObject, (String)from, fieldMap, null, (boolean)false);
            sql = DbQueryUtils.buildSelectSQl((IDataSource)ds, (String)table, (String)selectFields, (String)request.where(), null, (String)request.order(), (int)request.getSize(), (int)request.getPage());
        } else {
            selectFields = group.getFields();
            sql = DbQueryUtils.buildSelectSQl((IDataSource)ds, (String)table, (String)selectFields, (String)request.where(), (String)group.getGroupBy(), (String)request.order(), (int)request.getSize(), (int)request.getPage());
        }
        if (StringUtils.isEmpty((String)request.getCache())) {
            request.setCache("Y");
        }
        return DbQueryUtils.select((IDataSource)ds, (String)sql, (boolean)D.x((Object)request.getCache()));
    }
}

