/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.mservice.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.mservice.EPDMDataResponse;
import kd.epm.epbs.common.annotation.SDKMsService;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epdm.business.etl.helper.MainModelCreateServiceHelper;
import kd.epm.epdm.business.etl.helper.MainModelFieldServiceHelper;
import kd.epm.epdm.business.etl.helper.MainModelServiceHelper;
import kd.epm.epdm.common.enums.form.EpdmDatamodelEnum;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;
import kd.epm.epdm.common.util.MetadataUtil;
import kd.epm.epdm.mservice.MainModelService;

@SDKMsService
public class MainModelServiceImpl
implements MainModelService {
    private static final Log log = LogFactory.getLog(MainModelServiceImpl.class);

    @Override
    public EPDMDataResponse<Map<String, Object>> create(Map<String, Object> params) {
        EPDMDataResponse response = new EPDMDataResponse(500, "ERROR");
        if (null == params || params.isEmpty()) {
            response.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"MainModelServiceImpl_1", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        try {
            DynamicObject dmObject;
            String linkNumber = null;
            if (params.containsKey("link") && null != params.get("link")) {
                linkNumber = (String)params.get("link");
            }
            String number = (String)params.get("number");
            StringBuilder message = new StringBuilder();
            if (MainModelCreateServiceHelper.exists((String)number)) {
                message.append(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801[%s]\u5df2\u7ecf\u5b58\u5728\uff0c\u5c1d\u8bd5\u5efa\u8868\u3002", (String)"MainModelServiceImpl_2", (String)"epm-epbs-mservice", (Object[])new Object[0]), number));
                dmObject = MainModelCreateServiceHelper.getDataModel((String)number);
            } else {
                dmObject = (DynamicObject)TXUtils.requiresNewFunc(tx -> MainModelCreateServiceHelper.saveModel((Map)params));
            }
            String dbRoute = MetadataUtil.getDBRoute((DynamicObject)dmObject).getRouteKey();
            String _linkNumber = linkNumber;
            TXUtils.requiresNew(tx -> MainModelCreateServiceHelper.createTable((long)EpdmDatamodelEnum.id.getLong(dmObject), (String)_linkNumber, (String)dbRoute));
            if (message.length() > 0) {
                response.setMessage(message.toString());
            } else {
                response.setMessage("OK");
            }
            response.setCode(200);
            response.setData(new HashMap());
            ((Map)response.getData()).put("id", EpdmDatamodelEnum.id.getLong(dmObject));
            ((Map)response.getData()).put("number", EpdmDatamodelEnum.number.getString(dmObject));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.setCode(500);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public EPDMDataResponse<Map<String, Object>> iscReverse(Map<String, Object> params) {
        EPDMDataResponse response = new EPDMDataResponse(500, "ERROR");
        String linkNumber = null;
        if (params.containsKey("link") && null != params.get("link")) {
            linkNumber = (String)params.get("link");
        }
        Long modelId = (Long)params.get("model");
        if (!params.containsKey("model") || null == params.get("model")) {
            response.setMessage(ResManager.loadKDString((String)"\u6a21\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MainModelServiceImpl_3", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        DynamicObject dmObject = QueryServiceHelper.queryOne((String)EpdmDatamodelEnum.getFormId(), (String)EpdmDatamodelEnum.get().selectFields(), (QFilter[])new QFilter[]{new QFilter(EpdmDatamodelEnum.id.name(), "=", (Object)modelId)});
        String select = EpdmDmPresetEnum.id + "," + EpdmDmPresetEnum.datamodel + "," + EpdmDmPresetEnum.mainmodel;
        QFilter filter = new QFilter(EpdmDmPresetEnum.mainmodel.name(), "=", (Object)modelId);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)EpdmDmPresetEnum.getFormId(), (String)select, (QFilter[])new QFilter[]{filter});
        DynamicObject cfg = MainModelServiceHelper.getLink((String)linkNumber);
        Long catalogId = EpdmDatamodelEnum.catalog.getLong(dmObject);
        String table = EpdmDatamodelEnum.table.getString(dmObject);
        params = new HashMap<String, Object>(16);
        if (null == cfg) {
            params.put("dbLink", 0);
            table = table + "@" + MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()).getRouteKey();
        } else {
            params.put("dbLink", cfg.getLong("id"));
            if ("self".equalsIgnoreCase(cfg.getString("database_type"))) {
                table = table + "@" + MetadataUtil.getDBRoute((String)EpdmDatamodelEnum.getFormId()).getRouteKey();
            }
        }
        params.put("tableNames", Collections.singletonList(table));
        params.put("catalog", catalogId);
        params.put("isUpdate", "1");
        params.put("source_app", "epm");
        StringBuilder msg = new StringBuilder();
        try {
            List res = (List)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscx", (String)"IscResourceBuildService", (String)"buildTableModel", (Object[])new Object[]{params});
            if (null != res && !res.isEmpty()) {
                Map map = (Map)res.get(0);
                Long id = (Long)map.get("id");
                if (id == null) {
                    msg.append(((String)map.get("error")).replace("\r\n\r\n", "\r\n")).append("\n\n");
                    response.setMessage(msg.toString());
                } else {
                    for (int i = 0; i < dys.length; ++i) {
                        dys[i].set(EpdmDmPresetEnum.datamodel.name(), (Object)id);
                    }
                    TXUtils.requiresNew(tx -> SaveServiceHelper.save((DynamicObject[])dys));
                    response.setCode(200);
                    response.setMessage("OK");
                    response.setData((Object)map);
                }
            } else {
                response.setMessage("IscResourceBuildService#buildTableModel NULL");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public EPDMDataResponse<List<Map<String, Object>>> fields(Map<String, Object> params) {
        Object obj;
        EPDMDataResponse response = new EPDMDataResponse(500, "ERROR");
        if (!params.containsKey("model") || null == params.get("model")) {
            response.setMessage(ResManager.loadKDString((String)"\u6a21\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MainModelServiceImpl_3", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        Long modelId = (Long)params.get("model");
        List cols = null;
        if (params.containsKey("cols") && null != params.get("cols") && (obj = params.get("cols")) instanceof List) {
            cols = (List)obj;
        }
        try {
            response.setData((Object)MainModelFieldServiceHelper.queryDetails((long)modelId, cols));
            response.setCode(200);
            response.setMessage("OK");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public EPDMDataResponse<String> delField(Map<String, Object> params) {
        EPDMDataResponse response = new EPDMDataResponse(500, "ERROR");
        if (!params.containsKey("model") || null == params.get("model")) {
            response.setMessage(ResManager.loadKDString((String)"\u6a21\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MainModelServiceImpl_3", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        Long modelId = (Long)params.get("model");
        if (!params.containsKey("field") || null == params.get("field")) {
            response.setMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MainModelServiceImpl_4", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        String field = (String)params.get("field");
        try {
            TXUtils.requiresNew(tx -> MainModelFieldServiceHelper.delete((long)modelId, (String)field));
            response.setData((Object)field);
            response.setCode(200);
            response.setMessage("OK");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public EPDMDataResponse<Map<String, Object>> addField(Map<String, Object> params) {
        Object obj;
        EPDMDataResponse response = new EPDMDataResponse(500, "ERROR");
        String linkNumber = null;
        if (params.containsKey("link") && null != params.get("link")) {
            linkNumber = (String)params.get("link");
        }
        Long modelId = (Long)params.get("model");
        if (!params.containsKey("model") || null == params.get("model")) {
            response.setMessage(ResManager.loadKDString((String)"\u6a21\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MainModelServiceImpl_3", (String)"epm-epbs-mservice", (Object[])new Object[0]));
            return response;
        }
        String dbRoute = null;
        if (params.containsKey("dbRoute") && null != params.get("dbRoute")) {
            dbRoute = (String)params.get("dbRoute");
        }
        Map field = null;
        if (params.containsKey("field") && null != params.get("field") && (obj = params.get("field")) instanceof Map) {
            field = (Map)obj;
        }
        try {
            String _linkNumber = linkNumber;
            String _dbRoute = dbRoute;
            Map _field = field;
            DynamicObject dy = (DynamicObject)TXUtils.requiresNewFunc(tx -> MainModelFieldServiceHelper.add((long)modelId, (String)_linkNumber, (String)_dbRoute, (Map)_field));
            response.setData((Object)EpdmDmPresetEnum.get().getMap(dy));
            response.setCode(200);
            response.setMessage("OK");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.setMessage(e.getMessage());
        }
        return response;
    }
}

