/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.mservice.upgrade;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.epbs.common.annotation.SDKMsService;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

@SDKMsService
public class HandleLongTextUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(HandleLongTextUpgradeService.class);
    public static final String FILE_LIST_PATH = "epdm/preinsdata/xml/file_list.txt";
    public static final String LONG_TEXT_DATA = "longtextdata";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (InputStream in = HandleLongTextUpgradeService.class.getClassLoader().getResourceAsStream(FILE_LIST_PATH);
             BufferedReader bfReader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = bfReader.readLine()) != null) {
                this.dealOneFile(line);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new UpgradeResult();
    }

    private void dealOneFile(String fileName) {
        List longTextDataList;
        try (InputStream in = HandleLongTextUpgradeService.class.getClassLoader().getResourceAsStream(fileName);){
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(in);
            longTextDataList = document.getRootElement().elements(LONG_TEXT_DATA);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        for (Element element : longTextDataList) {
            Map<String, String> colMap = this.getNodeAttributes(element);
            List<Map<String, String>> pkList = this.getPkColList(element);
            String colValue = String.valueOf(element.element("data").getData());
            if (colMap.isEmpty() || pkList.isEmpty() || StringUtils.isEmpty((String)colValue)) continue;
            try {
                this.executeUpdateSql(colMap, pkList, colValue);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void executeUpdateSql(Map<String, String> tableMap, List<Map<String, String>> pkList, String fieldValue) {
        String dbkey = tableMap.get("dbkey");
        String tableName = tableMap.get("tablename");
        String colName = tableMap.get("colname");
        boolean tableExist = DB.exitsTable((DBRoute)DBRoute.of((String)dbkey), (String)tableName);
        if (!tableExist) {
            return;
        }
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder sbf = new StringBuilder();
        sbf.append("update ");
        sbf.append(tableName);
        sbf.append(" set ");
        sbf.append(colName);
        sbf.append(" =? ");
        paramList.add(fieldValue);
        sbf.append("where ");
        for (Map<String, String> pkMap : pkList) {
            String pkName = pkMap.get("name");
            String pkValue = pkMap.get("value");
            sbf.append(pkName);
            sbf.append(" =? ");
            paramList.add(Long.valueOf(pkValue));
        }
        DB.execute((DBRoute)DBRoute.of((String)dbkey), (String)sbf.toString(), (Object[])paramList.toArray());
    }

    private List<Map<String, String>> getPkColList(Element node) {
        Element pkElements = node.element("pkcols");
        List pkColList = pkElements.elements("pkcol");
        ArrayList<Map<String, String>> attList = new ArrayList<Map<String, String>>(10);
        for (Element element : pkColList) {
            attList.add(this.getNodeAttributes(element));
        }
        return attList;
    }

    private Map<String, String> getNodeAttributes(Element node) {
        HashMap<String, String> attributeMap = new HashMap<String, String>(16);
        List attList = node.attributes();
        for (Attribute attribute : attList) {
            attributeMap.put(attribute.getName(), attribute.getValue());
        }
        return attributeMap;
    }
}

