/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.FyEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class BCMDataReader {
    private static final Log logger = LogFactory.getLog(BCMDataReader.class);
    private static final String MODEL_PROPERTIES = "id,name,number,shownumber";
    private static final String EXTENDS_MODEL_PROPERTIES = "id,number,extendsgroup,extendsgroup.number";

    public static DynamicObject getModel(Long modelId) {
        return BCMDataReader.getModel(modelId, true);
    }

    public static DynamicObject getModel(Long modelId, boolean showException) {
        if (!LongUtil.isvalidLong((Object)modelId)) {
            return null;
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"bcm_model", (String)MODEL_PROPERTIES);
        if (showException && model == null) {
            logger.error("bcm modelId id not exist:" + modelId);
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BCMDataReader_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return model;
    }

    public static DynamicObject getModelByShowNumber(String showNumber) {
        if (StringUtils.isEmpty((String)showNumber)) {
            return null;
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)MODEL_PROPERTIES, (QFilter[])new QFilter("shownumber", "=", (Object)showNumber).toArray());
        return model;
    }

    public static String findModelNumberById(Long modelId) {
        DynamicObject model = BCMDataReader.getModel(modelId);
        if (Objects.isNull(model)) {
            return "";
        }
        return model.getString("number");
    }

    public static boolean isAdmin(Long modelId) {
        return (Boolean)ThreadCache.get((Object)(CacheKey.PrefixString + "isAdmin" + modelId), () -> {
            DynamicObject query = QueryServiceHelper.queryOne((String)"bcm_model", (String)"reportType", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
            if (Objects.isNull(query)) {
                return false;
            }
            String reportType = query.getString("reportType");
            ApplicationTypeEnum type = ApplicationTypeEnum.CM;
            if (Objects.equals(ApplicationTypeEnum.RPT.getOIndex(), reportType)) {
                type = ApplicationTypeEnum.RPT;
            }
            QFilter qf = MemberPermHelper.getModelPermFilter("id", "bcm_modelperm_manager", type);
            Optional<DynamicObject> any = QueryServiceHelper.query((String)"bcm_model", (String)"id", (QFilter[])new QFilter[]{qf}).stream().filter(dy -> Objects.equals(modelId, dy.getLong("id"))).findAny();
            return any.isPresent();
        });
    }

    public static DynamicObject getExtendsModel(Long modelId, String extNumber) {
        return BCMDataReader.getExtendsModel(modelId, extNumber, true);
    }

    public static DynamicObject getExtendsModel(Long modelId, String extNumber, boolean showException) {
        DynamicObject extmodel = null;
        if (!LongUtil.isvalidLong((Object)modelId)) {
            return extmodel;
        }
        QFBuilder qfBuilder = new QFBuilder().add("number", "=", (Object)extNumber).and("model", "=", (Object)modelId);
        Optional<DynamicObject> extmodelOptional = Optional.ofNullable(BusinessDataServiceHelper.loadSingle((String)"bcm_extendsmodel", (String)EXTENDS_MODEL_PROPERTIES, (QFilter[])qfBuilder.toArray()));
        if (!extmodelOptional.isPresent()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b%s\u4e0d\u5b58\u5728\u3002", (String)"BCMDataReader_1", (String)"epm-far-business", (Object[])new Object[0]), extNumber));
        }
        extmodel = extmodelOptional.get();
        return extmodel;
    }

    public static Date getModelBeginDate(Object modelId) {
        return (Date)GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.PrefixString + "getModelBeginDate-" + modelId, () -> {
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number,startfy,beginperiod,beginyearofmonth", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)modelId))});
            if (model == null) {
                return null;
            }
            return BCMDataReader.getModelBeginDate(model);
        });
    }

    public static Date getModelBeginDate(DynamicObject model) {
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BCMDataReader_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        int firstYear = model.getInt("startfy") + 1997 - 1;
        int firstMonth = model.getInt("beginperiod");
        String beginYearType = model.getString("beginyearofmonth");
        if (FyEnum.PRE.index.equals(beginYearType)) {
            --firstYear;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, firstYear);
        cal.set(2, firstMonth - 1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

