/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.dto.Dimension;
import kd.epm.far.common.common.util.QFBuilder;

public class BCMDimensionHelper {
    public static String getDimMembEntityNumByDimNum(String dimNum) {
        switch (dimNum.toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                return "bcm_entitymembertree";
            }
            case "account": {
                return "bcm_accountmembertree";
            }
            case "year": {
                return "bcm_fymembertree";
            }
            case "period": {
                return "bcm_periodmembertree";
            }
            case "scenario": {
                return "bcm_scenemembertree";
            }
            case "process": {
                return "bcm_processmembertree";
            }
            case "currency": {
                return "bcm_currencymembertree";
            }
            case "audittrail": {
                return "bcm_audittrialmembertree";
            }
            case "changetype": {
                return "bcm_changetypemembertree";
            }
            case "internalcompany": {
                return "bcm_icmembertree";
            }
            case "multigaap": {
                return "bcm_rulemembertree";
            }
            case "version": {
                return "bcm_eb_versionmembertree";
            }
            case "datatype": {
                return "eb_datetypemembertree";
            }
            case "datasort": {
                return "bcm_datasortmembertree";
            }
            case "mycompany": {
                return "bcm_mycompanymembertree";
            }
            case "metric": {
                return "epm_metricmembertree";
            }
            case "extends": {
                return "bcm_structofextend";
            }
            case "bperiod": {
                return "epm_bperiodmembertree";
            }
        }
        return "bcm_userdefinedmembertree";
    }

    public static Map<String, String> getDimensionShortNumber2NumberMap(String modelNum) {
        LinkedHashMap cacheMap = new LinkedHashMap(16);
        BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray(), (String)"dseq").values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getString("number")));
        return Collections.unmodifiableMap(cacheMap);
    }

    public static DynamicObject getDimByNumber(String number, Long modelId, String entity) {
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,fieldmapped,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fnumber = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fnumber};
        return BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)selectFields, (QFilter[])filters);
    }

    public static String findModelNumberById(Object id) {
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id.toString()), (String)"bcm_model", (String)"number");
        return dyna.getString("number");
    }

    public static Long getDimId(Long modelId, String dimNumber) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add(new QFilter("number", "=", (Object)dimNumber)).toArray());
        if (Objects.isNull(dynamicObject)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f%s\u4e0d\u5b58\u5728\u3002", (String)"BCMDimensionHelper_1", (String)"epm-far-business", (Object[])new Object[0]), dimNumber));
        }
        return dynamicObject.getLong("id");
    }

    public static String getDimensionModelById(long dimId) {
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)dimId, (String)"bcm_dimension", (String)"membermodel");
        return dy != null ? dy.getString("membermodel") : "";
    }

    public static DynamicObject getDimensionDynById(long dimId) {
        if (QueryServiceHelper.exists((String)"bcm_dimension_ext", (Object)dimId)) {
            return BusinessDataServiceHelper.loadSingle((Object)dimId, (String)"bcm_dimension_ext");
        }
        return BusinessDataServiceHelper.loadSingle((Object)dimId, (String)"bcm_dimension");
    }

    public static Map<Integer, String> getDimSortKey(Long modelId) {
        String entityName = "bcm_dimension";
        QFilter dimFilter = new QFilter("model", "=", (Object)modelId);
        String selectField = "dseq,number";
        DynamicObjectCollection dimDseq = QueryServiceHelper.query((String)entityName, (String)selectField, (QFilter[])new QFilter[]{dimFilter}, (String)"dseq");
        LinkedHashMap<Integer, String> dimNumberSortByDseq = new LinkedHashMap<Integer, String>(16);
        for (DynamicObject dim : dimDseq) {
            if (!"Scenario".equals(dim.getString("number"))) continue;
            dimNumberSortByDseq.put(dim.getInt("dseq"), dim.getString("number"));
            break;
        }
        for (DynamicObject dim : dimDseq) {
            if ("Scenario".equals(dim.getString("number"))) continue;
            dimNumberSortByDseq.put(dim.getInt("dseq"), dim.getString("number"));
        }
        return dimNumberSortByDseq;
    }

    public static List<Dimension> getDimensions(long modelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        DynamicObjectCollection dimData = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,number,shortnumber,dseq,modifytime,issysdimension", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(dimData.size());
        for (DynamicObject dimRow : dimData) {
            Dimension dim = new Dimension();
            dim.setId(dimRow.getLong("id"));
            dim.setNumber(dimRow.getString("number"));
            dim.setName(dimRow.getString("name"));
            dim.setShortNumber(dimRow.getString("shortnumber"));
            dim.setDseq(dimRow.getInt("dseq"));
            dim.setModifyTime(dimRow.getDate("modifytime"));
            dim.setSysDimension(dimRow.getBoolean("issysdimension"));
            dimensions.add(dim);
        }
        return dimensions;
    }
}

