/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm;

import com.google.common.collect.Lists;
import java.lang.constant.Constable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.bcm.BCMDimensionHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.DimMember;
import kd.epm.far.business.bcm.dto.DimProperty;
import kd.epm.far.business.bcm.dto.EnumValue;
import kd.epm.far.business.bcm.dto.MemberRange;
import kd.epm.far.business.bcm.dto.MemberRangeInput;
import kd.epm.far.business.bcm.dto.MemberRangeResult;
import kd.epm.far.business.bcm.dto.OrgBizChangeRecord;
import kd.epm.far.business.bcm.dto.OrgNameChangeRecord;
import kd.epm.far.business.bcm.dto.PeriodMemberEx;
import kd.epm.far.business.bcm.invest.ChangeTypeModel;
import kd.epm.far.business.bcm.invest.InvestServiceHelper;
import kd.epm.far.business.common.enums.OrgBizChangeEffEnum;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimMemberRange;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.enums.OrgBizChangeTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class BCMMemberHelper {
    public static List<DimMember> getDimMembers(long modelId, long dimensionId, Date modifyTime) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        if (dimensionId > 0L) {
            qFilters.add(new QFilter("id", "=", (Object)dimensionId));
        }
        DynamicObjectCollection dimDatas = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,membermodel,issysdimension", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<DimMember> members = new ArrayList<DimMember>(6);
        for (DynamicObject dimData : dimDatas) {
            dimensionId = dimData.getLong("id");
            members.addAll(BCMMemberHelper.getMembers(modelId, dimensionId, dimData.getBoolean("issysdimension"), modifyTime, dimData.getString("membermodel")));
        }
        return members;
    }

    public static List<DimMember> getDimMembers(Long dimId, Set<Long> memberIds) {
        if (!LongUtil.isvalidLong((Object)dimId)) {
            return Collections.emptyList();
        }
        DynamicObject dim = BCMDimensionHelper.getDimensionDynById(dimId);
        if (Objects.isNull(dim)) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("model_id", "=", (Object)dim.getLong("model.id"));
        qFilter.and(new QFilter("id", "in", memberIds));
        String selectFields = "id,number,name";
        DynamicObjectCollection memberDatas = QueryServiceHelper.query((String)dim.getString("membermodel"), (String)selectFields, (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)memberDatas)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)memberDatas.size());
        memberDatas.forEach(dy -> {
            DimMember dimMember = new DimMember();
            dimMember.setId(dy.getLong("id"));
            dimMember.setNumber(dy.getString("number"));
            list.add(dimMember);
        });
        return list;
    }

    private static List<DimMember> getMembers(long modelId, long dimensionId, boolean isSysDimension, Date modifyTime, String memberModel) {
        ArrayList<QFilter> qMemberFilters = new ArrayList<QFilter>();
        qMemberFilters.add(new QFilter("model_id", "=", (Object)modelId));
        if (modifyTime != null) {
            qMemberFilters.add(new QFilter("modifytime", ">", (Object)modifyTime));
        }
        boolean hasDataType = false;
        String selectFields = "id,number,name,isleaf,level,parent_id,modifytime,dpropertyid1.id,longnumber,dseq,storagetype";
        if (!isSysDimension) {
            qMemberFilters.add(new QFilter("dimension_id", "=", (Object)dimensionId));
            hasDataType = true;
            selectFields = selectFields + ",datatype,enumitem";
        }
        if (memberModel.equals("bcm_entitymembertree")) {
            selectFields = "id,number,name,isleaf,level,parent_id,modifytime,dpropertyid1.id,longnumber,dseq,cslscheme.id,currency.number,storagetype";
        }
        if (!memberModel.equals("bcm_currencymembertree") && !memberModel.equals("bcm_processmembertree")) {
            selectFields = selectFields + ",copyfrom.id";
        }
        if (memberModel.equals("bcm_scenemembertree") || memberModel.equals("bcm_accountmembertree") || memberModel.equals("bcm_changetypemembertree")) {
            hasDataType = true;
            selectFields = selectFields + ",datatype,enumitem";
        }
        if (memberModel.equals("bcm_datasortmembertree")) {
            hasDataType = true;
            selectFields = selectFields + ",datatype";
        }
        if (memberModel.equals("bcm_audittrialmembertree")) {
            selectFields = selectFields + ",datasource";
        }
        DynamicObjectCollection memberDatas = QueryServiceHelper.query((String)memberModel, (String)selectFields, (QFilter[])qMemberFilters.toArray(new QFilter[0]), (String)"id desc");
        return BCMMemberHelper.convertToDimMemberModel(memberDatas, memberModel, hasDataType, dimensionId);
    }

    private static List<DimMember> convertToDimMemberModel(DynamicObjectCollection dyMembers, String memberModel, boolean hasDataType, long dimensionId) {
        ArrayList<DimMember> members = new ArrayList<DimMember>(dyMembers.size());
        for (DynamicObject memberRow : dyMembers) {
            DimMember member = new DimMember();
            member.setId(memberRow.getLong("id"));
            member.setNumber(memberRow.getString("number"));
            member.setName(memberRow.getString("name"));
            member.setIsLeaf(memberRow.getBoolean("isleaf"));
            member.setLevel(memberRow.getInt("level"));
            member.setParentId(memberRow.getLong("parent_id"));
            member.setModifyTime(memberRow.getDate("modifytime"));
            member.setPropertyId(memberRow.getLong("dpropertyid1.id"));
            member.setLongNumber(memberRow.getString("longnumber"));
            member.setStorageType(memberRow.getInt("storagetype"));
            member.setDseq(memberRow.getLong("dseq"));
            member.setDimensionId(dimensionId);
            if (memberModel.equals("bcm_entitymembertree")) {
                member.setSchemeId(memberRow.getLong("cslscheme.id"));
                member.setCurrencyNumber(memberRow.getString("currency.number"));
            }
            if (!memberModel.equals("bcm_currencymembertree") && !memberModel.equals("bcm_processmembertree")) {
                member.setCopyFrom(memberRow.getLong("copyfrom.id"));
            }
            if (hasDataType) {
                String dataType;
                if (!memberModel.equals("bcm_datasortmembertree")) {
                    member.setEnumItemId(memberRow.getLong("enumitem"));
                }
                if (StringUtils.isEmpty((String)(dataType = memberRow.getString("datatype")))) {
                    member.setDataType("0");
                } else {
                    member.setDataType(dataType);
                }
            } else {
                member.setDataType("0");
            }
            if (memberModel.equals("bcm_audittrialmembertree") && !StringUtils.isEmpty((String)memberRow.getString("datasource"))) {
                member.setAtSourceFrom(memberRow.getString("datasource"));
            }
            members.add(member);
        }
        return members;
    }

    public static List<EnumValue> getEnumValues(long modelId, long dimensionId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        if (dimensionId > 0L) {
            qFilters.add(new QFilter("dimension_id", "=", (Object)dimensionId));
        }
        DynamicObjectCollection enumValueData = QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,dimension_id,enumitemid,datatype,name,enumvalue,dseq", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        ArrayList<EnumValue> enumValues = new ArrayList<EnumValue>(enumValueData.size());
        for (DynamicObject valueRow : enumValueData) {
            EnumValue enumValue = new EnumValue();
            enumValue.setId(valueRow.getLong("id"));
            enumValue.setDimensionId(valueRow.getLong("dimension_id"));
            enumValue.setEnumItemId(valueRow.getLong("enumitemid"));
            enumValue.setDataType(valueRow.getInt("datatype"));
            enumValue.setName(valueRow.getString("name"));
            enumValue.setValue(valueRow.getString("enumvalue"));
            enumValue.setDseq(valueRow.getInt("dseq"));
            enumValues.add(enumValue);
        }
        return enumValues;
    }

    public static Map<Long, List<Long>> getDeleteMembers(long modelId, long dimensionId, Date modifyTime) {
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        if (modifyTime == null) {
            return map;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        qFilters.add(new QFilter("createtime", ">", (Object)modifyTime));
        qFilters.add(new QFilter("operatenumber", "=", (Object)"delete").or("operatenumber", "=", (Object)"delete_share"));
        if (dimensionId > 0L) {
            qFilters.add(new QFilter("dimension.id", "=", (Object)dimensionId));
        }
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"bcm_dimensionmodifylog", (String)"id,dimension.id,memberid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"dimension.id asc");
        List dimIds = logs.stream().map(log -> log.getLong("dimension.id")).distinct().collect(Collectors.toList());
        for (Long dimId : dimIds) {
            List memberIds = logs.stream().filter(log -> log.getLong("dimension.id") == dimId.longValue()).map(log -> log.getLong("memberid")).distinct().collect(Collectors.toList());
            map.put(dimId, memberIds);
        }
        return map;
    }

    public static Map<String, List<String>> getScenarioPeriods(long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"number, sceneperiod.number", (QFilter[])qfBuilder.toArray());
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(dys.length);
        for (DynamicObject dy : dys) {
            map.computeIfAbsent(dy.getString("number"), k -> new ArrayList());
            if (dy.getDynamicObjectCollection("sceneperiod") == null) continue;
            dy.getDynamicObjectCollection("sceneperiod").forEach(e -> {
                if (e.getDynamicObject("fbasedataid") != null) {
                    ((List)map.get(dy.getString("number"))).add(e.getDynamicObject("fbasedataid").getString("number"));
                }
            });
        }
        return map;
    }

    public static List<PeriodMemberEx> getPeriodMemberEx(long modelId, Date modifyTime) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (modifyTime != null) {
            qFilters.add(new QFilter("modifytime", ">", (Object)modifyTime));
        }
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id, effmonth, effday, expmonth, expday,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<PeriodMemberEx> result = new ArrayList<PeriodMemberEx>(dys.size());
        for (DynamicObject obj : dys) {
            PeriodMemberEx item = new PeriodMemberEx();
            item.setEffday(obj.getInt("effday"));
            item.setEffmonth(obj.getInt("effmonth"));
            item.setExpmonth(obj.getInt("expmonth"));
            item.setExpday(obj.getInt("expday"));
            item.setModelId(modelId);
            item.setId(obj.getLong("id"));
            item.setModifytime(obj.getDate("modifytime"));
            result.add(item);
        }
        return result;
    }

    public static List<OrgBizChangeRecord> getEntityBizChangeRecord(long modelId) {
        DBRoute dbRoute = new DBRoute("bcm");
        String bizSql = "select x.fid ,t.fentityid,t.feffdate ,t.fexpdate ,t.fseq ,t.fchangetype from  t_bcm_structofent x join t_bcm_entitybizrecord t on  x.fid =t.fid  where x.fmodelid =?";
        DataSet bizDataSet = DB.queryDataSet((String)"getOrgBizChangeRecord", (DBRoute)dbRoute, (String)bizSql, (Object[])new Object[]{modelId});
        Map<String, ChangeTypeModel> invChangeTypeModel = InvestServiceHelper.getInvChangetypeModel(modelId);
        Map<String, Map> bizChangeTypeMap = invChangeTypeModel.values().stream().collect(Collectors.toMap(ChangeTypeModel::number, x -> {
            HashMap<String, Constable> map = new HashMap<String, Constable>();
            map.put("change", Integer.valueOf(Integer.parseInt(x.change())));
            map.put("isdefault", Boolean.valueOf(x.isdefault()));
            map.put("modelId", Long.valueOf(modelId));
            return map;
        }, (v1, v2) -> (Long)v1.get("modelId") != 0L ? v1 : v2));
        if (!bizChangeTypeMap.containsKey(OrgBizChangeTypeEnum.disable.getValue())) {
            HashMap<String, Constable> disableMap = new HashMap<String, Constable>();
            disableMap.put("change", Integer.valueOf(2));
            disableMap.put("isdefault", Boolean.valueOf(true));
            bizChangeTypeMap.put(OrgBizChangeTypeEnum.disable.getValue(), disableMap);
        }
        ArrayList<OrgBizChangeRecord> result = new ArrayList<OrgBizChangeRecord>(16);
        for (Row row : bizDataSet) {
            String changeType = row.getString("fchangetype");
            if (!bizChangeTypeMap.containsKey(changeType)) continue;
            OrgBizChangeRecord record = new OrgBizChangeRecord();
            record.setEffdate(row.getDate("feffdate"));
            record.setExpdate(row.getDate("fexpdate"));
            record.setChangeType(changeType);
            record.setSeq(row.getInteger("fseq"));
            boolean isDefault = (Boolean)bizChangeTypeMap.get(changeType).get("isdefault");
            if (isDefault) {
                switch (changeType) {
                    case "BD000": {
                        record.setEffType(OrgBizChangeEffEnum.CurrentMonth.ordinal());
                        record.setChangeDirect(2);
                        break;
                    }
                    case "BD001": 
                    case "BD002": 
                    case "BD003": 
                    case "BD004": 
                    case "BD007": 
                    case "BD008": {
                        record.setEffType(OrgBizChangeEffEnum.CurrentMonth.ordinal());
                        record.setChangeDirect(1);
                        break;
                    }
                    case "BD005": 
                    case "BD006": {
                        record.setEffType(OrgBizChangeEffEnum.NextYear.ordinal());
                        record.setChangeDirect(2);
                        break;
                    }
                    case "BD009": {
                        record.setEffType(OrgBizChangeEffEnum.NextMonth.ordinal());
                        record.setChangeDirect(2);
                        break;
                    }
                }
            } else {
                Integer changeDirect = (Integer)bizChangeTypeMap.get(changeType).get("change");
                if (changeDirect == 1) {
                    record.setEffType(OrgBizChangeEffEnum.CurrentMonth.ordinal());
                } else if (changeDirect == 2) {
                    record.setEffType(OrgBizChangeEffEnum.NextYear.ordinal());
                }
                record.setChangeDirect(changeDirect);
            }
            record.setEntryId(row.getLong("fentityid"));
            record.setOrgId(row.getLong("fid"));
            record.setModelId(modelId);
            result.add(record);
        }
        return result;
    }

    public static List<OrgNameChangeRecord> getEntityNameChangeRecord(long modelId) {
        Date beginDate = BCMDataReader.getModelBeginDate(modelId);
        DBRoute dbRoute = new DBRoute("bcm");
        String bizSql = "select x.fid,t.fentityid ,t.fname ,t.fsimplename ,t.feffdate ,t.fexpdate,t.fseq from  t_bcm_structofent x join t_bcm_entitynamerecord t on  x.fid =t.fid where x.fmodelid =? ";
        DataSet bizDataSet = DB.queryDataSet((String)"getOrgNameChangeRecord", (DBRoute)dbRoute, (String)bizSql, (Object[])new Object[]{modelId});
        ArrayList<OrgNameChangeRecord> result = new ArrayList<OrgNameChangeRecord>(16);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        for (Row row : bizDataSet) {
            if (null == row.getDate("feffdate") || fmt.format(beginDate).equals(fmt.format(row.getDate("feffdate"))) && null == row.get("fexpdate")) continue;
            OrgNameChangeRecord record = new OrgNameChangeRecord();
            record.setEffdate(row.getDate("feffdate"));
            record.setExpdate(row.getDate("fexpdate"));
            record.setName(row.getString("fname"));
            record.setSimpleName(row.getString("fsimplename"));
            record.setSeq(row.getInteger("fseq"));
            record.setEntryId(row.getLong("fentityid"));
            record.setOrgId(row.getLong("fid"));
            record.setModelId(modelId);
            result.add(record);
        }
        return result;
    }

    public static List<DimProperty> getProperties(long modelId, long dimensionId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        if (dimensionId > 0L) {
            qFilters.add(new QFilter("dimension_id", "=", (Object)dimensionId));
        }
        HashMap propertySorts = new HashMap(6);
        DynamicObjectCollection roots = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id,dimension_id", (QFilter[])qFilters.toArray(new QFilter[0]));
        Map<Long, List<DynamicObject>> dimProperties = roots.stream().collect(Collectors.groupingBy(r -> r.getLong("dimension_id")));
        dimProperties.forEach((k, v) -> {
            int i = 1;
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(6);
            for (DynamicObject dy : v) {
                map.put(dy.getLong("id"), i);
                ++i;
            }
            propertySorts.put(k, map);
        });
        DynamicObjectCollection propertyData = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,name,parentid.id,level,longnumber,dseq,dimension_id,propertyid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        ArrayList<DimProperty> properties = new ArrayList<DimProperty>(propertyData.size());
        for (DynamicObject propertyRow : propertyData) {
            Integer dseq;
            DimProperty property = new DimProperty();
            property.setId(propertyRow.getLong("id"));
            property.setNumber(propertyRow.getString("number"));
            property.setName(propertyRow.getString("name"));
            property.setParentId(propertyRow.getLong("parentid.id"));
            property.setLevel(propertyRow.getInt("level"));
            property.setLongNumber(propertyRow.getString("longnumber"));
            property.setDseq(propertyRow.getLong("dseq"));
            property.setDimensionId(propertyRow.getLong("dimension_id"));
            if (property.getParentId() == 0L && propertySorts.containsKey(property.getDimensionId()) && (dseq = (Integer)((Map)propertySorts.get(property.getDimensionId())).get(propertyRow.getLong("propertyid"))) != null) {
                property.setDseq(dseq.intValue());
            }
            properties.add(property);
        }
        return properties;
    }

    public static List<DimMemberRange> getMemberRangeDetails(Long modelId, DimensionInfo dim, List<DimMemberInfo> sourceMembers) {
        Object memberRange;
        ArrayList<DimMemberRange> memberRanges = new ArrayList<DimMemberRange>(100);
        ArrayList<MemberRange> rangeMemberList = new ArrayList<MemberRange>(100);
        for (DimMemberInfo source : sourceMembers) {
            int range = source.getRange();
            DimMemberRange rangeDim = new DimMemberRange();
            rangeDim.setSource(source);
            rangeDim.setMemberInfos(Collections.singletonList(source));
            memberRanges.add(rangeDim);
            if (range == 10) {
                rangeDim.setMemberInfos(Collections.singletonList(source));
                continue;
            }
            rangeDim.setMemberInfos(new ArrayList<DimMemberInfo>(100));
            memberRange = new MemberRange();
            ((MemberRange)memberRange).setId(source.getId());
            ((MemberRange)memberRange).setRange(range);
            rangeMemberList.add((MemberRange)memberRange);
        }
        if (dim != null && rangeMemberList.size() > 0) {
            MemberRangeInput memberRangeInput = new MemberRangeInput();
            memberRangeInput.setModelId(modelId);
            memberRangeInput.setEntityName(dim.getEntityName());
            memberRangeInput.setMembers(rangeMemberList);
            List<MemberRangeResult> rangeResults = BCMMsServiceHelper.batchGetMembersByIds(memberRangeInput);
            for (MemberRangeResult rangeResult : rangeResults) {
                memberRange = memberRanges.stream().filter(m -> m.getSource().getId().toString().equalsIgnoreCase(rangeResult.getInputMemberId())).findFirst().orElse(null);
                if (memberRange == null) continue;
                DimMemberInfo memberInfo = new DimMemberInfo();
                memberInfo.setId(LongUtil.toLong((Object)rangeResult.getId()));
                memberInfo.setNumber(rangeResult.getNumber());
                memberInfo.setName(rangeResult.getName());
                ((DimMemberRange)memberRange).getMemberInfos().add(memberInfo);
            }
        }
        return memberRanges;
    }
}

