/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dto.BCMCurrencyDto;
import kd.epm.far.business.bcm.dto.BCMMember;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.bcm.dto.BCMPerm;
import kd.epm.far.business.bcm.dto.ExtendsQueryInfo;
import kd.epm.far.business.bcm.dto.ExtendsResultSet;
import kd.epm.far.business.bcm.dto.MemberRangeInput;
import kd.epm.far.business.bcm.dto.MemberRangeResult;
import kd.epm.far.business.bcm.dto.OlapResultSet;
import kd.epm.far.business.bcm.dto.OlapSQLBuilder;
import kd.epm.far.business.bcm.dto.ReportDimResult;
import kd.epm.far.business.bcm.dto.ReportSectionAreaInfo;
import kd.epm.far.business.bcm.dto.ReportSectionResult;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.enums.PermEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.msservice.MsServiceHelper;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.collections4.map.MultiKeyMap;

public class BCMMsServiceHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(BCMMsServiceHelper.class);

    public static OlapResultSet olapQueryData(OlapSQLBuilder sqlBuilder) {
        try {
            Map<String, Object> result = BCMMsServiceHelper.invokeService("OLAPQUERYDATA", JSON.toJSONString((Object)sqlBuilder));
            if (result == null) {
                return null;
            }
            return new OlapResultSet(sqlBuilder, (List)result.get("rows"));
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u591a\u7ef4\u5e93\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static Map<String, Object> getAreaByTemplateId(Long templateId) {
        try {
            HashMap<String, Long> input = new HashMap<String, Long>(2);
            input.put("templateId", templateId);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("GETAREABYTEMPLATEID", JSON.toJSONString(input));
            if (result == null) {
                return null;
            }
            return (Map)result.get("result");
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u8868\u6a21\u677f\u533a\u57df\u5931\u8d25\u3002", (String)"BCMServiceHelper_8", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static Object getTemplateData(Long templateId, String extendNumber, Map<String, String> dimMap, List<String> orgs) {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(2);
            input.put("templateId", templateId);
            input.put("dimMap", dimMap);
            input.put("extendNumber", extendNumber);
            input.put(DimTypesEnum.ENTITY.getNumber(), SerializationUtils.toJsonString(orgs));
            Map<String, Object> result = BCMMsServiceHelper.invokeService("GETTEMPLATEDATA", JSON.toJSONString(input));
            if (result == null) {
                return null;
            }
            return result.get("data");
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u8868\u6570\u636e\u5931\u8d25\u3002", (String)"BCMServiceHelper_10", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static Map<Long, String> getTemplate(Long modelId) {
        try {
            HashMap<String, Long> input = new HashMap<String, Long>(2);
            input.put("modelId", modelId);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("GETTEMPLATE", JSON.toJSONString(input));
            if (result == null) {
                return null;
            }
            return (Map)result.get("result");
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u8868\u6a21\u677f\u5931\u8d25\u3002", (String)"BCMServiceHelper_9", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static ExtendsResultSet extendsQueryData(ExtendsQueryInfo extendsQueryInfo) {
        try {
            Map<String, Object> result = BCMMsServiceHelper.invokeService("EXTENDSQUERYDATA", JSON.toJSONString((Object)extendsQueryInfo));
            if (result == null) {
                return null;
            }
            List rows = (List)result.get("rows");
            return new ExtendsResultSet(extendsQueryInfo, rows);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u62d3\u5c55\u7ef4\u5e93\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static ReportDimResult reportDimResultQueryData(Long componentId) {
        try {
            HashMap<String, Long> input = new HashMap<String, Long>(2);
            input.put("componentId", componentId);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("reportDimResultQueryData", JSON.toJSONString(input));
            if (result == null) {
                return null;
            }
            return new ReportDimResult((List)result.get("dimValues"), (LinkedHashSet)result.get("dimKeys"), (String)result.get("pageDim"));
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u8868\u5207\u7247\u7ef4\u5ea6\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static boolean reportsectionCheckArea(Long componentId) {
        try {
            HashMap<String, Long> input = new HashMap<String, Long>(2);
            input.put("componentId", componentId);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("reportsectionCheckArea", JSON.toJSONString(input));
            if (result == null) {
                return false;
            }
            return (Boolean)result.get("isFloat");
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u8868\u5207\u7247\u5426\u5b58\u5728\u6d6e\u52a8\u533a\u57df\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static ReportSectionResult getExcelDataByReportsection(Map<String, Object> params) {
        try {
            Map<String, Object> result = BCMMsServiceHelper.invokeService("getExcelDataByReportsection", JSON.toJSONString(params));
            if (result == null) {
                return null;
            }
            if (result.get("excelData") == null) {
                return null;
            }
            ReportSectionResult reportSectionResult = new ReportSectionResult();
            reportSectionResult.setExcelData((byte[])result.get("excelData"));
            String areaData = TypeUtils.getMapValueString(result, "areaData");
            if (StringUtils.isNotEmpty((String)areaData)) {
                reportSectionResult.setAreaData(JSON.parseArray((String)areaData, ReportSectionAreaInfo.class));
            }
            return reportSectionResult;
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u8868\u5207\u7247\u7ef4\u5ea6\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static byte[] getTemplateExcelByReportsection(Map<String, Object> params) {
        try {
            Map<String, Object> result = BCMMsServiceHelper.invokeService("getTemplateExcelByReportsection", JSON.toJSONString(params));
            if (result == null) {
                return null;
            }
            if (result.get("excelData") == null) {
                return null;
            }
            return (byte[])result.get("excelData");
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u8868\u5207\u7247\u6a21\u677f\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static BCMMember findMemberByNumber(String modelNum, String dimNum, String number) {
        if (!(StringUtils.isNotEmpty((String)modelNum) && StringUtils.isNotEmpty((String)dimNum) && StringUtils.isNotEmpty((String)number))) {
            return null;
        }
        try {
            HashMap<String, String> input = new HashMap<String, String>(2);
            input.put("modelNum", modelNum);
            input.put("dimNum", dimNum);
            input.put("number", number);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("findMemberByNumber", JSON.toJSONString(input));
            if (result == null) {
                return null;
            }
            return (BCMMember)JSON.parseObject((String)JSON.toJSONString(result), (TypeReference)new TypeReference<BCMMember>(){}, (Feature[])new Feature[0]);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u5ea6\u6210\u5458\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static BCMMember findMemberById(Long modelId, String entityNumber, Long memberId) {
        if (!(LongUtil.isvalidLong((Object)modelId) && StringUtils.isNotEmpty((String)entityNumber) && LongUtil.isvalidLong((Object)memberId))) {
            return null;
        }
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(2);
            input.put("modelId", modelId);
            input.put("entityNumber", entityNumber);
            input.put("memberId", memberId);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("findMemberById", JSON.toJSONString(input));
            if (result == null) {
                return null;
            }
            return (BCMMember)JSON.parseObject((String)JSON.toJSONString(result), (TypeReference)new TypeReference<BCMMember>(){}, (Feature[])new Feature[0]);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u5ea6\u6210\u5458\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static Set<String> batchGetMemberNumbers(String modelNum, String dimNumber, String memberNumber, RangeEnum range) {
        try {
            HashMap<String, String> input = new HashMap<String, String>(2);
            input.put("modelNum", modelNum);
            input.put("dimNum", dimNumber);
            input.put("number", memberNumber);
            input.put("range", range.getNumber());
            Map<String, Object> result = BCMMsServiceHelper.invokeService("batchGetMembers", JSON.toJSONString(input));
            if (result == null) {
                return null;
            }
            return (Set)JSON.parseObject((String)JSON.toJSONString((Object)result.get("result")), (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u5ea6\u6210\u5458\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static BCMPerm getMemberPerm(Long modelId, Long dimId) {
        try {
            HashMap<String, Long> input = new HashMap<String, Long>(2);
            input.put("modelId", modelId);
            input.put("dimId", dimId);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("getMemberPerm", JSON.toJSONString(input));
            BCMPerm bcmPerm = new BCMPerm();
            bcmPerm.setDefaultPerm(Integer.valueOf(result.get("defaultPerm").toString()));
            for (PermEnum value : PermEnum.values()) {
                Object o = result.get(String.valueOf(value.getValue()));
                bcmPerm.buildPerms(value, o);
            }
            return bcmPerm;
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u5ea6\u6210\u5458\u6743\u9650\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static Set<String> filterHasPermMember(String modelNum, String dimNum, Set<String> members) {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(2);
            input.put("modelNum", modelNum);
            input.put("dimNum", dimNum);
            input.put("members", members);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("filterHasPermMember", JSON.toJSONString(input));
            if (result == null) {
                return null;
            }
            return (Set)JSON.parseObject((String)JSON.toJSONString((Object)result.get("result")), (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public static List<MemberRangeResult> batchGetMembersByIds(MemberRangeInput input) {
        try {
            Map<String, Object> result = BCMMsServiceHelper.invokeService("batchGetMembersByIds", JSON.toJSONString((Object)input));
            if (result == null) {
                return null;
            }
            return JSON.parseArray((String)JSON.toJSONString((Object)result.get("result")), MemberRangeResult.class);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u5ea6\u6210\u5458\u67e5\u8be2\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static BCMMemberTreeNode memberReaderfindMemberByNumber(String modelNum, String dimNum, String number) {
        try {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(5);
            params.put("modelNum", modelNum);
            params.put("dimNum", dimNum);
            params.put("number", number);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("MEMBERREADERFINDMEMBERBYNUMBER", JSON.toJSONString(params));
            if (result == null) {
                return null;
            }
            if (result.get("member") == null) {
                return null;
            }
            return (BCMMemberTreeNode)JSONObject.parseObject((String)result.get("member").toString(), BCMMemberTreeNode.class);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u5ea6\u6210\u5458\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BCMServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public static MultiKeyMap<String, Object> handleECDC(String cubeNumber, List<String> entitys, List<String> currencys, List<String> processs, Boolean bpall) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(5);
            params.put("cubeNumber", cubeNumber);
            params.put("entitys", entitys);
            params.put("currencys", currencys);
            params.put("processs", processs);
            params.put("bpall", bpall);
            Map<String, Object> result = BCMMsServiceHelper.invokeService("HANDLEECDC", JSON.toJSONString(params));
            if (result == null || result.get("result") == null) {
                return new MultiKeyMap();
            }
            List dtoList = JSONArray.parseArray((String)result.get("result").toString(), BCMCurrencyDto.class);
            MultiKeyMap currencyresult = new MultiKeyMap();
            for (BCMCurrencyDto dto : dtoList) {
                currencyresult.put((Object)dto.getEntity(), (Object)dto.getProcess(), dto.getCurrencyList());
            }
            return currencyresult;
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            logger.error("BCMServiceHelper", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u7ec4\u7ec7\u8fc7\u7a0b\u5e01\u522b\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)"BCMServiceHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    private static Map<String, Object> invokeService(String action, String input) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("action", action);
        param.put("input", input);
        try {
            Map result = (Map)MsServiceHelper.invokeService((String)"fi", (String)"bcm", (String)"FIDMMsService", (String)"execute", (Object[])new Object[]{param});
            logger.debug("inokeService: " + JSON.toJSONString(param));
            if (((Boolean)result.get("success")).booleanValue()) {
                return (Map)result.get("data");
            }
            throw new KDBizException(result.get("message").toString());
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            throw ex;
        }
    }
}

