/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.dto.CslScheme;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.common.common.enums.CslSchemeScopeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class CslSchemeServiceHelper {
    public static List<CslScheme> getCslSchemes(long modelId, Date modifyTime) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)modelId));
        qFilters.add(new QFilter("modifytime", ">", (Object)modifyTime));
        DynamicObjectCollection dimData = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,number,name,parent_id,isleaf,level,modifytime,description,effectivestatus,islegalorgview,isenable,nodetype,longnumber", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc");
        DynamicObjectCollection filterSchemes = new DynamicObjectCollection();
        for (DynamicObject dyObj : dimData) {
            dyObj.refreshDataEntityState();
            filterSchemes.add((Object)dyObj);
        }
        CslSchemeServiceHelper.filterByPerm(filterSchemes, modelId);
        ArrayList<CslScheme> schemes = new ArrayList<CslScheme>(filterSchemes.size());
        for (DynamicObject row : filterSchemes) {
            CslScheme scheme = new CslScheme();
            scheme.setId(row.getLong("id"));
            scheme.setNumber(row.getString("number"));
            scheme.setName(row.getString("name"));
            scheme.setParentId(row.getLong("parent_id"));
            scheme.setLeaf(row.getBoolean("isleaf"));
            scheme.setLevel(row.getInt("level"));
            scheme.setModifyTime(row.getDate("modifytime"));
            scheme.setDescription(row.getString("description"));
            scheme.setEffectiveStatus(row.getBoolean("effectivestatus"));
            scheme.setLegalOrgView(row.getBoolean("islegalorgview"));
            scheme.setEnable(row.getBoolean("isenable"));
            scheme.setNodeType(row.getInt("nodetype"));
            scheme.setLongNumber(row.getString("longnumber"));
            schemes.add(scheme);
        }
        return schemes;
    }

    public static void filterByPerm(DynamicObjectCollection queryNodes, Long modelId) {
        if (MemberPermHelper.isModelAdmin(modelId)) {
            return;
        }
        Set<Long> filterSet = CslSchemeServiceHelper.getNoPermCslSchemeIds(modelId);
        Iterator it = queryNodes.iterator();
        while (it.hasNext()) {
            DynamicObject next = (DynamicObject)it.next();
            long id = next.getLong("id");
            if (!filterSet.contains(id)) continue;
            it.remove();
        }
    }

    private static DynamicObjectCollection getCslScheme(Long modelId) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number, name, parent, scope, creater", (QFilter[])qf.toArray(), (String)"level asc");
    }

    public static Set<Long> getNoPermCslSchemeIds(Long modelId) {
        DynamicObjectCollection queryNodes = CslSchemeServiceHelper.getCslScheme(modelId);
        Map<Long, Integer> permMap = MemberPermHelper.getCslSchemePermission("bcm_cslscheme", modelId, queryNodes);
        HashSet<Long> filterSet = new HashSet<Long>();
        HashMap<Long, List> parentChildIds = new HashMap<Long, List>(16);
        for (DynamicObject node : queryNodes) {
            long parent = node.getLong("parent");
            if (parent != 0L) {
                List child = parentChildIds.computeIfAbsent(parent, x -> new ArrayList());
                child.add(node.getLong("id"));
            }
            Long useId = LongUtil.toLong((Object)RequestContext.get().getUserId());
            Integer perm = permMap.get(node.getLong("id"));
            if ((!CslSchemeScopeEnum.isOneSelfScope((String)node.getString("scope")) || useId.compareTo(node.getLong("creater")) == 0) && (perm == null || perm.compareTo(3) != 0)) continue;
            filterSet.add(node.getLong("id"));
        }
        queryNodes.forEach(next -> {
            long id = next.getLong("id");
            long parent = next.getLong("parent");
            if ((filterSet.contains(id) || filterSet.contains(parent)) && parentChildIds.get(id) != null) {
                filterSet.addAll((Collection)parentChildIds.get(id));
            }
        });
        return filterSet;
    }

    public static Set<Long> getCurrUserHavePermCslSchemeIdNotRateScheme(String modelId, boolean isIncludeRateScheme) {
        QFilter qFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        if (!isIncludeRateScheme) {
            qFilter.and("number", "!=", (Object)"DefaultRateScheme");
        }
        qFilter.and(QFilter.of((String)"isenable = ? and nodetype = ?", (Object[])new Object[]{true, "1"}));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id", (QFilter[])qFilter.toArray());
        boolean isModelPerm = MemberPermHelper.ifUserHasRootPermByModel(RequestContext.get().getCurrUserId(), modelId);
        if (!isModelPerm) {
            CslSchemeServiceHelper.filterByPerm(doc, LongUtil.toLong((Object)modelId));
        }
        HashSet<Long> cslSchemeIdSet = new HashSet<Long>(16);
        cslSchemeIdSet.add(0L);
        QFilter rootSchemeFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        rootSchemeFilter.and("longnumber", "=", (Object)"root");
        DynamicObject rootScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])rootSchemeFilter.toArray());
        if (rootScheme != null) {
            cslSchemeIdSet.add(rootScheme.getLong("id"));
        }
        cslSchemeIdSet.addAll(doc.stream().map(r -> r.getLong("id")).collect(Collectors.toSet()));
        return cslSchemeIdSet;
    }
}

