/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm.cslscheme;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.cslscheme.CslSchemeTree;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.enums.CslSchemeScopeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class CslSchemeServiceHelper {
    public static Long getRptDefaultSchemeId(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)"DefaultScheme"));
        return (Long)GlobalCacheServiceHelper.getCommonCache().getOrLoad("DefaultSchemeId-" + modelId, () -> {
            DynamicObject defaultScheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])filter.toArray());
            if (defaultScheme != null) {
                return defaultScheme.getLong("id");
            }
            return 0L;
        });
    }

    public static void filterByPerm(DynamicObjectCollection queryNodes, Long modelId) {
        if (MemberPermHelper.isModelAdmin(modelId)) {
            return;
        }
        Set<Long> filterSet = CslSchemeServiceHelper.getNoPermCslSchemeIds(modelId);
        Iterator it = queryNodes.iterator();
        while (it.hasNext()) {
            DynamicObject next = (DynamicObject)it.next();
            long id = next.getLong("id");
            if (!filterSet.contains(id)) continue;
            it.remove();
        }
    }

    private static DynamicObjectCollection getCslScheme(Long modelId) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number, name, parent, scope, creater", (QFilter[])qf.toArray(), (String)"level asc");
    }

    public static Set<Long> getNoPermCslSchemeIds(Long modelId) {
        DynamicObjectCollection queryNodes = CslSchemeServiceHelper.getCslScheme(modelId);
        Map<Long, Integer> permMap = MemberPermHelper.getCslSchemePermission("bcm_cslscheme", modelId, queryNodes);
        HashSet<Long> filterSet = new HashSet<Long>();
        HashMap<Long, List> parentChildIds = new HashMap<Long, List>(16);
        for (DynamicObject node : queryNodes) {
            long parent = node.getLong("parent");
            if (parent != 0L) {
                List child = parentChildIds.computeIfAbsent(parent, x -> new ArrayList());
                child.add(node.getLong("id"));
            }
            Long useId = LongUtil.toLong((Object)RequestContext.get().getUserId());
            Integer perm = permMap.get(node.getLong("id"));
            if ((!CslSchemeScopeEnum.isOneSelfScope((String)node.getString("scope")) || useId.compareTo(node.getLong("creater")) == 0) && (perm == null || perm.compareTo(3) != 0)) continue;
            filterSet.add(node.getLong("id"));
        }
        queryNodes.forEach(next -> {
            long id = next.getLong("id");
            long parent = next.getLong("parent");
            if ((filterSet.contains(id) || filterSet.contains(parent)) && parentChildIds.get(id) != null) {
                filterSet.addAll((Collection)parentChildIds.get(id));
            }
        });
        return filterSet;
    }

    public static CslSchemeTree getCslSchemeTree(Long modelId, boolean isScheme, boolean noRate) {
        return CslSchemeServiceHelper.getCslSchemeTree(modelId, isScheme, 0L, noRate);
    }

    public static CslSchemeTree getCslSchemeTree(Long modelId, boolean isScheme, Long parentId, boolean noRateScheme) {
        DynamicObject parentNode;
        QFilter filters = QFilter.of((String)"model = ?", (Object[])new Object[]{modelId});
        if (!QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])filters.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u5165\u201c\u5e94\u7528\u4f53\u7cfb\u5217\u8868\u201d\u5347\u7ea7\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CslSchemeServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!isScheme) {
            filters.and(QFilter.of((String)"nodetype = ?", (Object[])new Object[]{"0"}));
        }
        if (parentId != null && parentId != 0L && (parentNode = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id, number, longnumber", (QFilter[])filters.toArray())) != null) {
            filters.and(new QFilter("longnumber", "like", (Object)(parentNode.getString("longnumber") + ".%")));
        }
        filters.and(QFilter.of((String)"isenable = ?", (Object[])new Object[]{true}));
        if (noRateScheme) {
            filters.and("number", "!=", (Object)"DefaultRateScheme");
        }
        DynamicObjectCollection queryNodes = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number, name, parent", (QFilter[])filters.toArray(), (String)"level, id");
        CslSchemeServiceHelper.reOrderScheme(queryNodes);
        CslSchemeServiceHelper.filterByPerm(queryNodes, modelId);
        if (queryNodes.size() <= 0) {
            return new CslSchemeTree("0", ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u3002", (String)"CslSchemeServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject rootNode = (DynamicObject)queryNodes.get(0);
        HashBasedTable nodes = HashBasedTable.create();
        HashMap id2TreeMapping = Maps.newHashMap();
        CslSchemeTree root = new CslSchemeTree(rootNode.getString("id"), rootNode.getString("name"));
        queryNodes.forEach(arg_0 -> CslSchemeServiceHelper.lambda$getCslSchemeTree$3((Table)nodes, id2TreeMapping, rootNode, root, arg_0));
        nodes.rowMap().forEach((k, v) -> {
            CslSchemeTree parentNode = (CslSchemeTree)id2TreeMapping.get(k);
            if (parentNode != null) {
                v.values().forEach(vl -> parentNode.addChild(vl));
            }
        });
        return root;
    }

    private static void reOrderScheme(DynamicObjectCollection queryNodes) {
        for (int i = 0; i < queryNodes.size(); ++i) {
            if (!"DefaultRateScheme".equalsIgnoreCase(((DynamicObject)queryNodes.get(i)).getString("number"))) continue;
            DynamicObject rateScheme = (DynamicObject)queryNodes.get(i);
            queryNodes.remove((Object)rateScheme);
            queryNodes.add((Object)rateScheme);
            break;
        }
    }

    public static TreeNode addTreeNode2TreeView(long modelId, boolean hasScheme, TreeView treeView) {
        if (treeView == null) {
            return null;
        }
        treeView.deleteAllNodes();
        CslSchemeTree cslSchemeTree = CslSchemeServiceHelper.getCslSchemeTree(modelId, hasScheme, false);
        TreeNode root = cslSchemeTree.trans2TreeNode();
        root.iterate(1, node -> {
            node.setIsOpened(true);
            node.setExpend(true);
        });
        treeView.addNode(root);
        return root;
    }

    private static /* synthetic */ void lambda$getCslSchemeTree$3(Table nodes, Map id2TreeMapping, DynamicObject rootNode, CslSchemeTree root, DynamicObject v) {
        CslSchemeTree node = new CslSchemeTree(v.getString("id"), v.getString("name"));
        nodes.put((Object)v.getLong("parent"), (Object)v.getLong("id"), (Object)node);
        id2TreeMapping.put(v.getLong("id"), node);
        if (v.getLong("parent") == rootNode.getLong("id")) {
            root.addChild(node);
        }
    }
}

