/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm.dimension;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.ThrowableHelper;

public class BCMMemberReader {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(BCMMemberReader.class);

    public static DimMemberInfo getFirstMemberId(Long modelId, String dimNumber) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, DisModelTypeEnum.CM.getType());
        List<DimensionInfo> dimensionInfos = modelStrategyEx.getDim().getDimList();
        DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(dimensionInfos, dimNumber);
        if (dimensionInfo == null) {
            return null;
        }
        String selectFields = "id,number,name";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection memberDys = QueryServiceHelper.query((String)dimensionInfo.getEntityName(), (String)selectFields, (QFilter[])filters, (String)"id asc", (int)1);
        if (memberDys.size() == 0) {
            return null;
        }
        return DimensionUtils.convertToMemberInfo((DynamicObject)memberDys.get(0));
    }

    public static BCMMemberTreeNode findMemberByNumber(String modelNum, String dimNum, String number) {
        if (StringUtils.isEmpty((String)number)) {
            return BCMMemberTreeNode.NotFoundTreeNode;
        }
        BCMMemberTreeNode member = BCMMsServiceHelper.memberReaderfindMemberByNumber(modelNum, dimNum, number);
        if (member == null) {
            return BCMMemberTreeNode.NotFoundTreeNode;
        }
        return member;
    }

    public static Map<String, String> getDimensionShortNumber2NumberMap(String modelNum) {
        return (Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.PrefixString + "dim-number-short-" + modelNum, () -> {
            LinkedHashMap cacheMap = new LinkedHashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray(), (String)"dseq").values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getString("number")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static Map<String, String> getDimensionNumber2nameMap(String modelNum) {
        return (Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.PrefixString + "dim-number-short2name" + modelNum, () -> {
            HashMap cacheMap = new HashMap(16);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,shortnumber,name,id", (QFilter[])new QFilter("model.number", "=", (Object)modelNum).toArray()).values().forEach(e -> cacheMap.put(e.getString("shortnumber"), e.getString("number") + ";" + e.getString("name") + ";" + e.getString("id")));
            return Collections.unmodifiableMap(cacheMap);
        });
    }

    public static DynamicObject getDimensionDynById(long dimId) {
        try {
            return (DynamicObject)GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.PrefixString + "getDimensionDynById-" + dimId, () -> {
                if (QueryServiceHelper.exists((String)"bcm_dimension_ext", (Object)dimId)) {
                    return BusinessDataServiceHelper.loadSingle((Object)dimId, (String)"bcm_dimension_ext");
                }
                return BusinessDataServiceHelper.loadSingle((Object)dimId, (String)"bcm_dimension");
            });
        }
        catch (Exception ex) {
            log.error("getDimensionDynById error." + ThrowableHelper.toString((Exception)ex));
            return null;
        }
    }

    public static String findModelNumberById(Object id) {
        DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id.toString()), (String)"bcm_model", (String)"number");
        if (dyna == null) {
            log.error(String.format("model id:%s is not found from cache.", id));
            dyna = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id.toString()), (String)"bcm_model", (String)"number");
        }
        return dyna.getString("number");
    }

    public static Long findModelIdByNum(String number) {
        return (Long)GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.PrefixString + "model_id_2_number_" + number, () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{number}).toArray());
            return dyna == null ? 0L : dyna.getLong("id");
        });
    }

    public static String findModelNumberByShowNum(String showNumber) {
        return (String)GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.PrefixString + "model_shownumber_2_number_" + showNumber, () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"number", (QFilter[])QFilter.of((String)"shownumber=?", (Object[])new Object[]{showNumber}).toArray());
            return dyna.getString("number");
        });
    }
}

