/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm.dimension;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.dimension.DimNodeType;
import kd.epm.far.business.bcm.dimension.DimensionTree;
import kd.epm.far.business.bcm.dimension.StoredMemberFetch;
import kd.epm.far.common.common.enums.StorageTypeEnum;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class DimensionNode {
    private static final int maxLevel = 500;
    private DynamicObject dyn;
    private DynamicObject shareDyn;
    private long id;
    private long memberId;
    private long parent;
    private boolean isLeaf;
    private String storageType;
    private String aggoprt;
    private Date modifyTime;
    private String modifier;
    private String number;
    private String longNumber;
    private Integer dseq;
    private DimNodeType nodeType;
    private Map<String, Object> propExtend = new HashMap<String, Object>(8);

    public DimensionNode(DynamicObject dyn) {
        if (dyn != null) {
            this.dyn = dyn;
            DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
            this.id = dyn.getLong("id");
            this.parent = DimensionNode.getLongCompatible(dyn, "parent");
            this.storageType = dyn.getString("storagetype");
            this.isLeaf = dyn.getBoolean("isleaf");
            long copyfrom = DimensionNode.getLongCompatible(dyn, "copyfrom");
            this.memberId = copyfrom == 0L ? this.id : copyfrom;
            this.aggoprt = !"bcm_structofextend".equals(dyn.getDynamicObjectType().getName()) ? dyn.getString("aggoprt") : "";
            this.modifyTime = dyn.getDate("modifytime");
            if (properties.get((Object)"modifier") != null) {
                this.modifier = dyn.getString("modifier");
            }
            this.number = dyn.getString("number");
            this.dseq = dyn.getInt("dseq");
            this.nodeType = StorageTypeEnum.SHARE.getOIndex().equals(this.storageType) ? DimNodeType.SHARE_E : DimNodeType.STORE;
        }
    }

    public DimensionNode(DynamicObject dyn, DynamicObject shareDyn) {
        this(dyn);
        if (shareDyn != null) {
            this.dyn = dyn == null ? shareDyn : dyn;
            this.shareDyn = shareDyn;
            this.id = shareDyn.getLong("id");
            this.parent = DimensionNode.getLongCompatible(shareDyn, "parent");
            this.storageType = StorageTypeEnum.SHARE.getOIndex();
            long copyfrom = DimensionNode.getLongCompatible(shareDyn, "copyfrom");
            this.memberId = copyfrom == 0L ? this.id : copyfrom;
            this.isLeaf = this.dyn.getBoolean("isleaf");
            this.aggoprt = shareDyn.getString("aggoprt");
            this.modifyTime = shareDyn.getDate("modifytime");
            DataEntityPropertyCollection properties = shareDyn.getDataEntityType().getProperties();
            if (properties.get((Object)"modifier") != null) {
                this.modifier = shareDyn.getString("modifier");
            }
            this.number = this.dyn.getString("number");
            this.dseq = shareDyn.getInt("dseq");
            this.nodeType = DimNodeType.SHARE_E;
        }
    }

    private static DimensionTree<String, DimensionNode> _createDimTreeWithShareRef(DynamicObject[] objs, String entityId, StoredMemberFetch fetch, boolean showShareAll) {
        HashMap<Long, DimensionNode> needUpdate = new HashMap<Long, DimensionNode>(16);
        ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> parentChildStoredMap = new ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>>(10);
        ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> parentChildSharedMap = new ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>>(10);
        ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> sharedStoredMap = new ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>>(10);
        DimensionTree<String, DimensionNode> root = DimensionNode._createDimTreeWithShareAndStore(objs, needUpdate, parentChildStoredMap, parentChildSharedMap, sharedStoredMap, showShareAll);
        Map<String, DimensionNode> shareNumberMap = sharedStoredMap.stream().collect(Collectors.toMap(k -> (String)((DimensionTree)k.t1).getKey(), v -> (DimensionNode)((DimensionTree)v.t1).getData(), (v1, v2) -> v1));
        for (Tuple2 object : sharedStoredMap) {
            DimensionNode.refChildren2((DimensionTree)object.t1, (DimensionTree)object.t2, 0, shareNumberMap);
        }
        for (Tuple2 tuple2 : parentChildSharedMap) {
            DimensionNode.addChild((DimensionTree)tuple2.t1, (DimensionTree)tuple2.t2, true);
        }
        if (showShareAll) {
            for (Tuple2 tuple2 : parentChildStoredMap) {
                DimensionNode.removeChild((DimensionTree)tuple2.t1, (DimensionTree)tuple2.t2);
            }
        }
        if (entityId != null) {
            Throwable throwable = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"dimtree", (String)entityId, (String)"id,isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", needUpdate.keySet())}, null);){
                for (Row d : ds) {
                    Long id = d.getLong("id");
                    Boolean isleaf = d.getBoolean("isleaf");
                    ((DimensionNode)needUpdate.get(id)).setLeaf(isleaf);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        } else if (fetch != null) {
            DynamicObject[] storedDync;
            for (DynamicObject stored : storedDync = fetch.fetch(needUpdate.keySet())) {
                long id = stored.getLong("id");
                DimensionNode sharedNode = (DimensionNode)needUpdate.get(id);
                sharedNode.setDyn(stored);
            }
        }
        DimensionTree.sort(root);
        return root;
    }

    private static DimensionTree<String, DimensionNode> createNormalTree(DynamicObject[] objs) {
        HashMap<Long, DimensionNode> needUpdate = new HashMap<Long, DimensionNode>(16);
        ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> parentChildStoredMap = new ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>>(10);
        ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> parentChildSharedMap = new ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>>(10);
        ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> sharedStoredMap = new ArrayList<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>>(10);
        return DimensionNode._createDimTreeWithShareAndStore(objs, needUpdate, parentChildStoredMap, parentChildSharedMap, sharedStoredMap, true);
    }

    private static DimensionTree<String, DimensionNode> _createDimTreeWithShareAndStore(DynamicObject[] objs, Map<Long, DimensionNode> needUpdate, List<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> parentChildStoredMap, List<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> parentChildSharedMap, List<Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>> sharedStoredMap, boolean showSharedAll) {
        if (objs == null || objs.length == 0) {
            return null;
        }
        DimensionTree root = null;
        LinkedHashMap<Long, DimensionTree<String, DimensionNode>> idTreeMap = new LinkedHashMap<Long, DimensionTree<String, DimensionNode>>(16);
        LinkedHashMap<Long, DimensionTree<String, DimensionNode>> allidTreeMap = new LinkedHashMap<Long, DimensionTree<String, DimensionNode>>(16);
        HashMap<Long, List> idSharedChildrenMap = new HashMap<Long, List>(16);
        for (DynamicObject obj : objs) {
            String storagetype = obj.getString("storagetype");
            long id = DimensionNode.getLongCompatible(obj, "id");
            String number = obj.getString("number");
            DimensionTree<String, DimensionNode> member = new DimensionTree<String, DimensionNode>(number, new DimensionNode(obj));
            allidTreeMap.put(id, member);
            if (!StorageTypeEnum.SHARE.getOIndex().equals(storagetype)) {
                idTreeMap.put(id, member);
                continue;
            }
            long pid = DimensionNode.getLongCompatible(obj, "parent");
            idSharedChildrenMap.computeIfAbsent(pid, k -> new ArrayList(10)).add(obj);
        }
        for (DimensionTree dimensionTree : idTreeMap.values()) {
            DimensionNode node = (DimensionNode)dimensionTree.getData();
            long pid = node.getParent();
            if (pid != 0L) {
                DimensionTree parent = (DimensionTree)idTreeMap.get(pid);
                if (parent == null && root == null) {
                    root = dimensionTree;
                }
                if (parent == null) continue;
                DimensionNode.addChild(parent, dimensionTree, true);
                continue;
            }
            if (root != null && !"Entity".equalsIgnoreCase((String)dimensionTree.getKey())) continue;
            root = dimensionTree;
        }
        for (Map.Entry entry : idSharedChildrenMap.entrySet()) {
            Long key = (Long)entry.getKey();
            List value = (List)entry.getValue();
            DimensionTree parent = (DimensionTree)allidTreeMap.get(key);
            if (parent == null) continue;
            for (DynamicObject dyn : value) {
                long copyfrom = DimensionNode.getLongCompatible(dyn, "copyfrom");
                if (copyfrom == 0L) continue;
                DimensionTree childStored = (DimensionTree)allidTreeMap.get(copyfrom);
                if (childStored == null) {
                    childStored = (DimensionTree)allidTreeMap.get(dyn.getLong("id"));
                }
                DynamicObject storedDyn = childStored == null ? null : ((DimensionNode)childStored.getData()).getDyn();
                DimensionNode node = new DimensionNode(storedDyn, dyn);
                DimensionTree<String, DimensionNode> childShared = new DimensionTree<String, DimensionNode>(dyn.getString("number"), node);
                if (childStored != null) {
                    sharedStoredMap.add((Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>)new Tuple2(childShared, (Object)childStored));
                    parentChildStoredMap.add((Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>)new Tuple2((Object)parent, (Object)childStored));
                } else {
                    needUpdate.put(copyfrom, node);
                }
                parentChildSharedMap.add((Tuple2<DimensionTree<String, DimensionNode>, DimensionTree<String, DimensionNode>>)new Tuple2((Object)parent, childShared));
            }
        }
        if (showSharedAll) {
            for (Tuple2 tuple2 : parentChildStoredMap) {
                DimensionNode.addChild((DimensionTree)tuple2.t1, (DimensionTree)tuple2.t2, false);
            }
        }
        return root;
    }

    public static DimensionTree<String, DimensionNode> createDimTreeWithShareRef(DynamicObject[] objs, StoredMemberFetch fetch) {
        return DimensionNode._createDimTreeWithShareRef(objs, null, fetch, true);
    }

    private static <K, V> void removeChild(DimensionTree<K, V> parent, DimensionTree<K, V> child) {
        List<DimensionTree<K, V>> children = parent.getChildren();
        if (children != null && child != null) {
            children.remove(child);
        }
    }

    private static <K, V> void addChild(DimensionTree<K, V> parent, DimensionTree<K, V> child, boolean setParent) {
        parent.getChildren().add(child);
        if (setParent) {
            child.setParent(parent);
        }
    }

    public static void refChildren(DimensionTree<String, DimensionNode> nodeShared, DimensionTree<String, DimensionNode> nodeStored, int cursor) {
        DimensionNode rootSharedNode = nodeShared.getData();
        if (cursor > 500) {
            return;
        }
        for (DimensionTree<String, DimensionNode> storedChild : nodeStored.getChildren()) {
            DimensionNode storedNode = storedChild.getData();
            DimensionNode sharedNode = new DimensionNode(storedNode.getDyn(), storedNode.getShareDyn());
            DimensionTree<String, DimensionNode> sharedChild = new DimensionTree<String, DimensionNode>(storedNode.getNumber(), sharedNode);
            sharedNode.setParent(rootSharedNode.getId());
            sharedNode.setLeaf(storedNode.isLeaf());
            if (StorageTypeEnum.SHARE.getOIndex().equals(rootSharedNode.getStorageType())) {
                sharedNode.setId(GlobalIdUtil.genGlobalLongId());
                sharedNode.setNodeType(DimNodeType.SHARE_V);
                sharedNode.setStorageType(StorageTypeEnum.SHARE.getOIndex());
                if (Objects.nonNull(sharedNode.getShareDyn())) {
                    sharedNode.setAggoprt(sharedNode.getShareDyn().getString("aggoprt"));
                } else {
                    sharedNode.setAggoprt(sharedNode.getDyn().getString("aggoprt"));
                }
            } else {
                sharedNode.setId(storedNode.getId());
                sharedNode.setStorageType(storedNode.getStorageType());
            }
            DimensionNode.refChildren(sharedChild, storedChild, cursor + 1);
            DimensionNode.addChild(nodeShared, sharedChild, true);
        }
    }

    public static void refChildren2(DimensionTree<String, DimensionNode> nodeShared, DimensionTree<String, DimensionNode> nodeStored, int cursor, Map<String, DimensionNode> shareNumberMap) {
        DimensionNode rootSharedNode = nodeShared.getData();
        if (cursor > 500) {
            return;
        }
        for (DimensionTree<String, DimensionNode> storedChild : nodeStored.getChildren()) {
            DimensionNode share = shareNumberMap.get(storedChild.getKey());
            if (share == null) continue;
            DimensionNode storedNode = storedChild.getData();
            DimensionNode sharedNode = new DimensionNode(storedNode.getDyn(), share.getShareDyn());
            DimensionTree<String, DimensionNode> sharedChild = new DimensionTree<String, DimensionNode>(storedNode.getNumber(), sharedNode);
            sharedNode.setParent(rootSharedNode.getId());
            sharedNode.setLeaf(storedNode.isLeaf());
            if (StorageTypeEnum.SHARE.getOIndex().equals(rootSharedNode.getStorageType())) {
                sharedNode.setId(share.getShareDyn().getLong("id"));
                sharedNode.setNodeType(DimNodeType.SHARE_V);
                sharedNode.setStorageType(StorageTypeEnum.SHARE.getOIndex());
                if (Objects.nonNull(sharedNode.getShareDyn())) {
                    sharedNode.setAggoprt(sharedNode.getShareDyn().getString("aggoprt"));
                } else {
                    sharedNode.setAggoprt(sharedNode.getDyn().getString("aggoprt"));
                }
            } else {
                sharedNode.setId(storedNode.getId());
                sharedNode.setStorageType(storedNode.getStorageType());
            }
            DimensionNode.refChildren2(sharedChild, storedChild, cursor + 1, shareNumberMap);
            DimensionNode.addChild(nodeShared, sharedChild, true);
        }
    }

    public static void refChildrenOfDim(DimensionTree<String, DimensionNode> nodeShared, DimensionTree<String, DimensionNode> nodeStored, int cursor, String menberentityid) {
        DimensionNode rootSharedNode = nodeShared.getData();
        if (cursor > 500) {
            return;
        }
        DynamicObjectCollection childs = null;
        if (StorageTypeEnum.SHARE.getOIndex().equals(rootSharedNode.getStorageType())) {
            long sharePId = rootSharedNode.getId();
            QFilter qf = new QFilter("parent", "=", (Object)sharePId);
            childs = QueryServiceHelper.query((String)menberentityid, (String)"id,number", (QFilter[])qf.toArray());
        }
        for (DimensionTree<String, DimensionNode> storedChild : nodeStored.getChildren()) {
            DimensionNode storedNode = storedChild.getData();
            DimensionNode sharedNode = new DimensionNode(storedNode.getDyn(), storedNode.getShareDyn());
            DimensionTree<String, DimensionNode> sharedChild = new DimensionTree<String, DimensionNode>(storedNode.getNumber(), sharedNode);
            sharedNode.setParent(rootSharedNode.getId());
            sharedNode.setLeaf(storedNode.isLeaf());
            if (StorageTypeEnum.SHARE.getOIndex().equals(rootSharedNode.getStorageType())) {
                Optional<DynamicObject> shareNode;
                long shardNodeId = 0L;
                if (childs != null && childs.size() > 0 && (shareNode = childs.stream().filter(x -> x.getString("number").equals(storedNode.getDyn().getString("number"))).findFirst()).isPresent()) {
                    shardNodeId = shareNode.get().getLong("id");
                }
                if (shardNodeId == 0L) {
                    shardNodeId = GlobalIdUtil.genGlobalLongId();
                }
                sharedNode.setId(shardNodeId);
                sharedNode.setNodeType(DimNodeType.SHARE_V);
                sharedNode.setStorageType(StorageTypeEnum.SHARE.getOIndex());
                if (Objects.nonNull(sharedNode.getShareDyn())) {
                    sharedNode.setAggoprt(sharedNode.getShareDyn().getString("aggoprt"));
                } else {
                    sharedNode.setAggoprt(sharedNode.getDyn().getString("aggoprt"));
                }
            } else {
                sharedNode.setId(storedNode.getId());
                sharedNode.setStorageType(storedNode.getStorageType());
            }
            DimensionNode.refChildren(sharedChild, storedChild, cursor + 1);
            DimensionNode.addChild(nodeShared, sharedChild, true);
        }
    }

    public static void updateLongNumber(DimensionTree<String, DimensionNode> tree) {
        tree.dfs(t -> {
            DimensionNode data = (DimensionNode)t.getData();
            String number = data.getNumber();
            DimensionTree parent = t.getParent();
            if (parent == null) {
                String longNumber = data.getLongNumber();
                if (longNumber == null) {
                    data.setLongNumber(number);
                }
            } else {
                String pln = ((DimensionNode)parent.getData()).getLongNumber();
                data.setLongNumber(String.join((CharSequence)"!", pln, number));
            }
        });
    }

    public static long getLongCompatible(DynamicObject dyn, String prop) {
        return Objects.isNull(dyn.get(prop)) ? 0L : (dyn.get(prop) instanceof Long ? dyn.getLong(prop) : dyn.getDynamicObject(prop).getLong("id"));
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getParent() {
        return this.parent;
    }

    public void setParent(long parent) {
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public DynamicObject getDyn() {
        return this.dyn;
    }

    public void setDyn(DynamicObject dyn) {
        this.dyn = dyn;
        this.number = dyn.getString("number");
        this.isLeaf = dyn.getBoolean("isleaf");
    }

    public long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(long memberId) {
        this.memberId = memberId;
    }

    public DynamicObject getShareDyn() {
        return this.shareDyn;
    }

    public void setShareDyn(DynamicObject shareDyn) {
        this.shareDyn = shareDyn;
    }

    public String getAggoprt() {
        return this.aggoprt;
    }

    public void setAggoprt(String aggoprt) {
        this.aggoprt = aggoprt;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public DimNodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(DimNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public Object getPropExtend(String propName) {
        return this.propExtend.get(propName);
    }

    public void setPropExtend(String propName, Object value) {
        this.propExtend.put(propName, value);
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Integer getDseq() {
        return this.dseq;
    }

    public void setDseq(Integer dseq) {
        this.dseq = dseq;
    }
}

