/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.far.business.bcm.BCMMemberHelper;
import kd.epm.far.business.bcm.dto.DimMember;
import kd.epm.far.common.common.enums.PermEnum;
import org.apache.commons.collections.CollectionUtils;

public class BCMPerm {
    private Integer defaultPerm;
    private Set<Long> noPermSets;
    private Set<Long> readPermSets;
    private Set<Long> writePermSets;
    private Set<String> noPermNumberSets;
    private Set<String> readPermNumberSets;
    private Set<String> writePermNumberSets;

    public Integer getDefaultPerm() {
        return this.defaultPerm;
    }

    public void setDefaultPerm(Integer defaultPerm) {
        this.defaultPerm = defaultPerm;
    }

    public Set<Long> getNoPermSets() {
        return this.noPermSets;
    }

    public void setNoPermSets(Set<Long> noPermSets) {
        this.noPermSets = noPermSets;
    }

    public Set<Long> getReadPermSets() {
        return this.readPermSets;
    }

    public void setReadPermSets(Set<Long> readPermSets) {
        this.readPermSets = readPermSets;
    }

    public Set<Long> getWritePermSets() {
        return this.writePermSets;
    }

    public void setWritePermSets(Set<Long> writePermSets) {
        this.writePermSets = writePermSets;
    }

    public Set<String> getNoPermNumberSets() {
        return this.noPermNumberSets;
    }

    public void setNoPermNumberSets(Set<String> noPermNumberSets) {
        this.noPermNumberSets = noPermNumberSets;
    }

    public Set<String> getReadPermNumberSets() {
        return this.readPermNumberSets;
    }

    public void setReadPermNumberSets(Set<String> readPermNumberSets) {
        this.readPermNumberSets = readPermNumberSets;
    }

    public Set<String> getWritePermNumberSets() {
        return this.writePermNumberSets;
    }

    public void setWritePermNumberSets(Set<String> writePermNumberSets) {
        this.writePermNumberSets = writePermNumberSets;
    }

    public void buildPerms(PermEnum perm, Object ids) {
        Set sets = Sets.newHashSetWithExpectedSize((int)16);
        if (Objects.nonNull(ids)) {
            sets = (Set)JSON.parseObject((String)ids.toString(), (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
        }
        switch (perm) {
            case NOPERM: {
                this.setNoPermSets(sets);
                break;
            }
            case READONLY: {
                this.setReadPermSets(sets);
                break;
            }
            case READWRITE: {
                this.setWritePermSets(sets);
            }
        }
    }

    public void initNumberSet(Long dimId) {
        if (CollectionUtils.isNotEmpty(this.noPermSets) && CollectionUtils.isEmpty(this.noPermNumberSets)) {
            this.noPermNumberSets = BCMMemberHelper.getDimMembers(dimId, this.noPermSets).stream().map(DimMember::getNumber).collect(Collectors.toSet());
        }
        if (CollectionUtils.isNotEmpty(this.readPermSets) && CollectionUtils.isEmpty(this.readPermNumberSets)) {
            this.readPermNumberSets = BCMMemberHelper.getDimMembers(dimId, this.readPermSets).stream().map(DimMember::getNumber).collect(Collectors.toSet());
        }
        if (CollectionUtils.isNotEmpty(this.writePermSets) && CollectionUtils.isEmpty(this.writePermNumberSets)) {
            this.writePermNumberSets = BCMMemberHelper.getDimMembers(dimId, this.writePermSets).stream().map(DimMember::getNumber).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty(this.noPermNumberSets)) {
            this.noPermNumberSets = Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(this.readPermNumberSets)) {
            this.readPermNumberSets = Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(this.writePermNumberSets)) {
            this.writePermNumberSets = Collections.emptySet();
        }
    }
}

