/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm.dto;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.BCMPerm;
import kd.epm.far.common.common.enums.PermEnum;
import kd.epm.far.common.common.util.LongUtil;

public class BcmPermService {
    private Long modelId;
    private Long dimId;
    private BCMPerm perm;

    public BcmPermService(Long modelId, Long dimId) {
        this.modelId = modelId;
        this.dimId = dimId;
        if (LongUtil.isvalidLong((Object)modelId) && LongUtil.isvalidLong((Object)dimId)) {
            this.perm = BCMMsServiceHelper.getMemberPerm(modelId, dimId);
        }
    }

    private void checkPermExist() {
        if (Objects.isNull(this.perm)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6743\u9650\u4fe1\u606f\u83b7\u53d6\u5931\u8d25,\u8bf7\u68c0\u67e5\u6765\u6e90\u4f53\u7cfb\u3002", (String)"BcmPermService_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public Long getDimId() {
        return this.dimId;
    }

    public BCMPerm getPerm() {
        return this.perm;
    }

    public boolean hasPerm(Long memberId) {
        boolean isCmAdmin = BCMDataReader.isAdmin(this.modelId);
        if (isCmAdmin) {
            return Boolean.TRUE;
        }
        this.checkPermExist();
        if (Objects.equals(PermEnum.NOPERM.getValue(), this.perm.getDefaultPerm())) {
            return this.perm.getReadPermSets().contains(memberId) || this.perm.getWritePermSets().contains(memberId);
        }
        return !this.perm.getNoPermSets().contains(memberId);
    }

    public boolean hasPerm(String number) {
        boolean isCmAdmin = BCMDataReader.isAdmin(this.modelId);
        if (isCmAdmin) {
            return Boolean.TRUE;
        }
        this.checkPermExist();
        this.perm.initNumberSet(this.dimId);
        if (Objects.equals(PermEnum.NOPERM.getValue(), this.perm.getDefaultPerm())) {
            return this.perm.getReadPermNumberSets().contains(number) || this.perm.getWritePermNumberSets().contains(number);
        }
        return !this.perm.getNoPermNumberSets().contains(number);
    }

    public QFilter getPermQFilter(String property) {
        boolean isCmAdmin = BCMDataReader.isAdmin(this.modelId);
        if (isCmAdmin) {
            return new QFilter("1", "=", (Object)1);
        }
        this.checkPermExist();
        if (Objects.equals(PermEnum.NOPERM.getValue(), this.perm.getDefaultPerm())) {
            ArrayList<Long> ids = new ArrayList<Long>(this.perm.getReadPermSets().size() + this.perm.getWritePermSets().size());
            if (this.perm.getReadPermSets().size() > 0) {
                ids.addAll(this.perm.getReadPermSets());
            }
            if (this.perm.getWritePermSets().size() > 0) {
                ids.addAll(this.perm.getWritePermSets());
            }
            return new QFilter(property, "in", ids);
        }
        ArrayList<Long> ids = new ArrayList<Long>(this.perm.getNoPermSets().size());
        if (this.perm.getNoPermSets().size() > 0) {
            ids.addAll(this.perm.getNoPermSets());
        }
        if (ids.size() > 0) {
            return new QFilter(property, "not in", ids);
        }
        return null;
    }
}

