/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.epm.far.common.common.Pair;

public class OlapSQLBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _cubecatalog;
    private List<String> selector = new LinkedList<String>();
    private List<Pair<String, String[]>> filter = new ArrayList<Pair<String, String[]>>();
    private List<String> measures = new LinkedList<String>();
    private int top = -1;
    private boolean excludeDynaData = false;
    private boolean excludeNullData = false;

    public OlapSQLBuilder(String cubecatalog) {
        this._cubecatalog = cubecatalog;
    }

    public String getCubecatalog() {
        return this._cubecatalog;
    }

    public void setCubecatalog(String cubecatalog) {
        this._cubecatalog = cubecatalog;
    }

    public void addSelectField(String ... dimKeys) {
        for (String f : dimKeys) {
            if (this.selector.contains(f)) {
                throw new KDBizException(String.format("set repeated field:%s", f));
            }
            this.selector.add(f);
        }
    }

    public String[] getSelectField() {
        return this.selector.toArray(new String[0]);
    }

    public void addFilter(String dimKey, String ... values) {
        this.filter.add((Pair<String, String[]>)Pair.onePair((Object)dimKey, (Object)values));
    }

    public List<Pair<String, String[]>> getFilters() {
        return this.filter;
    }

    public Pair<String, String[]> getFilter(String dimNum) {
        return this.filter.stream().filter(f -> ((String)f.p1).equals(dimNum)).findFirst().orElse(null);
    }

    public void addMeasures(String ... measures) {
        for (String m : measures) {
            if (this.measures.contains(m)) {
                throw new KDBizException(String.format("set repeated measure:%s", m));
            }
            this.measures.add(m);
        }
    }

    public void reset() {
        this.selector.clear();
        this.filter.clear();
        this.measures.clear();
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public List<String> getMeasures() {
        return this.measures;
    }

    public boolean isExcludeDynaData() {
        return this.excludeDynaData;
    }

    public void setExcludeDynaData(boolean excludeDynaData) {
        this.excludeDynaData = excludeDynaData;
    }

    public boolean isExcludeNullData() {
        return this.excludeNullData;
    }

    public void setExcludeNullData(boolean excludeNullData) {
        this.excludeNullData = excludeNullData;
    }
}

