/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm.invest;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.epm.far.common.common.enums.OrgBizChangeTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class ChangeTypeModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ChangeTypeModel.class);
    private long id;
    private int seq;
    private String number;
    private String name;
    private boolean isdefault;
    private String change;
    private String relatedChangeType;

    public ChangeTypeModel(DynamicObject changeTypeDy) {
        if (changeTypeDy == null) {
            return;
        }
        this.id = changeTypeDy.getLong("id");
        this.number = changeTypeDy.getString("number");
        this.name = changeTypeDy.getString("name");
        this.change = changeTypeDy.getString("change");
        this.seq = changeTypeDy.getInt("dseq");
        OrgBizChangeTypeEnum orgBizTypeEnum = OrgBizChangeTypeEnum.getEnumByValue4Rule((String)this.number);
        this.isdefault = changeTypeDy.getBoolean("isdefault");
        if (this.seq == 0 && this.isdefault && orgBizTypeEnum != null) {
            this.seq = orgBizTypeEnum.getDefaultDseq();
        }
        try {
            this.relatedChangeType = changeTypeDy.getString("relatedchangetype.number");
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    public long getId() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public boolean isdefault() {
        return this.isdefault;
    }

    public String change() {
        return StringUtils.isEmpty((String)this.change) ? "0" : this.change;
    }

    public int seq() {
        return this.seq;
    }

    public String number() {
        return this.number;
    }

    public String relatedChangeType() {
        return this.relatedChangeType;
    }

    public String getRealChangeType() {
        return this.relatedChangeType == null ? this.number : this.relatedChangeType;
    }

    public ChangeTypeModel setSeq(int seq) {
        this.seq = seq;
        return this;
    }
}

