/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.bcm.invest;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.bcm.invest.ChangeTypeModel;
import kd.epm.far.business.common.cache.AppCacheServiceHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.OrgBizChangeTypeEnum;

public class InvestServiceHelper {
    public static Map<String, ChangeTypeModel> getInvChangetypeModel(Long modelId) {
        String packKey = InvestServiceHelper.packMergeCacheKey("InvCngtypeSet", modelId, null, null, null);
        return (Map)InvestServiceHelper.get(packKey, () -> {
            Map<String, DynamicObject> invChangetypeDyMap = InvestServiceHelper.queryInvChangetypeDy(modelId);
            LinkedHashMap invChangetypeSettingMap = new LinkedHashMap(invChangetypeDyMap.size());
            ChangeTypeModel addNewModel = new ChangeTypeModel(invChangetypeDyMap.get(OrgBizChangeTypeEnum.initNewlyAdded.getCode()));
            Comparator<ChangeTypeModel> dseqComparator = Comparator.comparingInt(p -> p.seq() == 0 ? addNewModel.seq() : p.seq());
            Comparator<ChangeTypeModel> defaultComparator = Comparator.comparingInt(p -> p.isdefault() ? 0 : 1);
            AtomicInteger seqAto = new AtomicInteger(0);
            invChangetypeDyMap.values().stream().map(ChangeTypeModel::new).sorted(dseqComparator.thenComparing(defaultComparator)).collect(Collectors.toList()).forEach(p -> {
                p.setSeq(seqAto.incrementAndGet());
                invChangetypeSettingMap.put(p.number(), p);
            });
            return invChangetypeSettingMap;
        });
    }

    public static Map<String, DynamicObject> queryInvChangetypeDy(Long modelId) {
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("model", "in", (Object)new Long[]{0L, modelId});
        DynamicObject[] invChangeTypes = BusinessDataServiceHelper.load((String)"bcm_invchangetype", (String)"relatedchangetype.number,id,name,number,isdefault,change,dseq", (QFilter[])filter.toArray(), (String)"model desc");
        HashMap<String, DynamicObject> invChangetypeSettingMap = new HashMap<String, DynamicObject>(invChangeTypes.length);
        for (DynamicObject invChangeType : invChangeTypes) {
            invChangetypeSettingMap.computeIfAbsent(invChangeType.getString("number"), a -> invChangeType);
        }
        return invChangetypeSettingMap;
    }

    public static <T> T get(String packKey, CacheLoader<T> loader) {
        return (T)ThreadCache.get((Object)(CacheKey.PrefixString + packKey), () -> {
            String cacheStr = (String)AppCacheServiceHelper.get(packKey);
            if (cacheStr == null) {
                Object t = loader.load();
                if (t != null) {
                    AppCacheServiceHelper.put(packKey, SerializationUtils.serializeToBase64((Object)t));
                }
                return t;
            }
            try {
                return SerializationUtils.deSerializeFromBase64((String)cacheStr);
            }
            catch (Throwable t1) {
                AppCacheServiceHelper.remove(packKey);
                return loader.load();
            }
        });
    }

    public static String packMergeCacheKey(String sign, Long modelId, Long sceneId, Long fyId, Long periodId) {
        StringJoiner sb = new StringJoiner("_");
        sb.add("V1.0");
        sb.add(sign);
        sb.add(modelId.toString());
        if (sceneId != null) {
            sb.add(sceneId.toString());
        }
        if (fyId != null) {
            sb.add(fyId.toString());
        }
        if (periodId != null) {
            sb.add(periodId.toString());
        }
        return sb.toString();
    }
}

