/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.business.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.ExchangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class ExportUtil {
    public static final String EMPTY = "";
    public static final String TEMPLATETYPE = "templatetype";
    public static final String COLUMN_DEFINED_PROPERTY = "definedpropertyvalue";
    public static final String ENUM_FIELD = "enumitem";
    public static final String EXCHANGE_ATT = "exchange";
    public static final String ENTRYRATE_ATT = "entryrate";
    public static final Set<String> ENUM_NEED_SWITCH = Sets.newHashSet((Object[])new String[]{"bcm_accountmembertree", "bcm_changetypemembertree", "bcm_scenemembertree"});
    private static final int ROW_SIZE = 50000;
    private static final String[] SOURCES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String export(DynamicObject[] arrDimMapping, Object template, String routeAppId, String formId, String fileName) throws IOException {
        return ExportUtil.export(arrDimMapping, template, routeAppId, formId, fileName, (Consumer<ExportWriterFormat>)((Consumer)e -> {}));
    }

    public static String export(DynamicObject[] arrDimMapping, Object template, String routeAppId, String formId, String fileName, Consumer<ExportWriterFormat> consumer) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHeadAndClearCTAndAT(wb, sheet, styles, routeAppId, formId, template, formId, arrDimMapping, consumer);
        if (format != null) {
            ExportUtil.handlerProperties(format, formId);
            String json = SerializationUtils.toJsonString((Object)arrDimMapping);
            JSONArray billArr = JSON.parseArray((String)json);
            ExportUtil.handlerBillDatas(billArr, formId);
            int rowIndex = 4;
            try (TraceSpan span = Tracer.create((String)"bcmexport", (String)"export");){
                for (int i = 0; i < billArr.size(); ++i) {
                    JSONObject bill = billArr.getJSONObject(i);
                    if (bill == null) continue;
                    ExportUtil.billFormatConfig(bill);
                    int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex, (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
                    rowIndex += Math.max(offset, 1);
                }
            }
        }
        return ExportUtil.writeFile(wb, fileName);
    }

    private static void handlerBillDatas(JSONArray billArr, String formId) {
        if ("bcm_chkformulasetting".equals(formId)) {
            Object modelId = billArr.getJSONObject(0).getJSONObject("model").get((Object)"id");
            Map number2LastName = (Map)ThreadCache.get((Object)(CacheKey.PrefixString + formId + "import--->" + modelId), () -> {
                HashMap map = new HashMap(16);
                QFilter modelFilter = new QFilter("model", "=", billArr.getJSONObject(0).getJSONObject("model").get((Object)"id"));
                QFilter tempFilter = new QFilter(TEMPLATETYPE, "in", Arrays.asList("0", "1")).and(new QFilter("status", "=", (Object)"1"));
                DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name", (QFilter[])new QFilter[]{modelFilter, tempFilter}, (String)"versionnumber desc");
                doc.forEach(d -> map.putIfAbsent(d.getString("number"), d.getString("name")));
                return map;
            });
            for (int i = 0; i < billArr.size(); ++i) {
                JSONArray multitemplate = billArr.getJSONObject(i).getJSONArray("multitemplate");
                for (int j = 0; j < multitemplate.size(); ++j) {
                    JSONObject fbasedataid = multitemplate.getJSONObject(j).getJSONObject("fbasedataid");
                    fbasedataid.put("name", number2LastName.get(fbasedataid.getString("number")));
                }
            }
        }
    }

    private static void handlerProperties(ExportWriterFormat format, String formId) {
        String langtag;
        JSONArray dkarr;
        JSONArray dkarr2;
        Object dkobj;
        if (format.properties.get("model") != null && (dkobj = ((Map)format.properties.get("model")).get("DataKey")) instanceof JSONArray && (dkarr2 = (JSONArray)dkobj).size() > 1) {
            Object v1 = dkarr2.get(0);
            Object v2 = dkarr2.get(1);
            if ("name".equals(v1) && "shownumber".equals(v2)) {
                dkarr2.set(0, v2);
                dkarr2.set(1, v1);
            }
        }
        if ("bcm_invrelation".equals(formId)) {
            dkarr = (JSONArray)((Map)format.properties.get("invelimtemplate")).get("DataKey");
            langtag = Lang.get().getLangTag().replace("-", "_");
            dkarr.set(1, (Object)("fbasedataid.name." + langtag));
        }
        if ("bcm_chkformulasetting".equals(formId)) {
            dkarr = (JSONArray)((Map)format.properties.get("mulcslscheme")).get("DataKey");
            langtag = Lang.get().getLangTag().replace("-", "_");
            dkarr.set(1, (Object)("fbasedataid.name." + langtag));
            JSONArray csl = (JSONArray)((Map)format.properties.get("org")).get("DataKey");
            csl.set(2, (Object)"cslscheme.number");
        }
    }

    public static void billFormatConfig(JSONObject bill) {
        for (Map.Entry billEntry : bill.entrySet()) {
            if (!(billEntry.getValue() instanceof BigDecimal) || !bill.containsKey(billEntry.getKey())) continue;
            bill.put((String)billEntry.getKey(), (Object)((BigDecimal)billEntry.getValue()).stripTrailingZeros());
        }
    }

    public static DynamicObject getImportTemplate(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("bizobject.number", "=", (Object)formId), new QFilter(TEMPLATETYPE, "=", (Object)"IMPT").or(new QFilter(TEMPLATETYPE, "is null", null))};
        DynamicObject templateData = QueryServiceHelper.queryOne((String)"bos_importtemplate", (String)"id,name", (QFilter[])filters);
        if (templateData == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5f15\u5165\u5f15\u51fa\u6a21\u677f\u3002", (String)"ExportUtil_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return templateData;
    }

    public static String export(DynamicObject[] arrDimMapping, String routeAppId, String formId) throws Exception {
        DynamicObject templateData = ExportUtil.getImportTemplate(formId);
        String fileName = ExportUtil.genFullFileName(templateData.getString("name"), EMPTY);
        return ExportUtil.export(arrDimMapping, templateData.get("id"), routeAppId, formId, fileName);
    }

    public static String export(DynamicObject[] arrDimMapping, String routeAppId, String formId, Consumer<ExportWriterFormat> consumer) throws Exception {
        DynamicObject templateData = ExportUtil.getImportTemplate(formId);
        String fileName = ExportUtil.genFullFileName(templateData.getString("name"), EMPTY);
        return ExportUtil.export(arrDimMapping, templateData.get("id"), routeAppId, formId, fileName, consumer);
    }

    public static String genFullFileName(String templateName, String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(templateName);
        LocalDate now = LocalDate.now();
        sb.append(String.format("_%4d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()));
        sb.append(".xlsx");
        return sb.toString();
    }

    public static String genFullFileName(Long template, String billFormId, String fileNamePrefix) {
        return ExportUtil.genFileName(template, billFormId, fileNamePrefix) + ".xlsx";
    }

    public static String genFileName(Long template, String billFormId, String fileNamePrefix) {
        StringBuilder fileName = new StringBuilder(fileNamePrefix);
        DynamicObject templateData = null;
        if (template > 0L) {
            templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        }
        if (templateData != null) {
            fileName.append(templateData.get("name"));
        } else {
            BillEntityType listEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
            fileName.append(listEntityType.getDisplayName());
        }
        LocalDate now = LocalDate.now();
        fileName.append(String.format("_%4d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()));
        return fileName.toString();
    }

    public static String export(QFBuilder filterParam, Object template, String routeAppId, String formId, String fileName) throws IOException {
        DynamicObject[] arrDimMapping = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])filterParam.toArray()).values().toArray(new DynamicObject[0]);
        return ExportUtil.export(arrDimMapping, template, routeAppId, formId, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static ExportWriterFormat getExportWriterFormatAndWriteHeadAndClearCTAndAT(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, Object formId, Object template, Object extendData, DynamicObject[] exportData, Consumer<ExportWriterFormat> consumer) {
        ExportWriterFormat format = ExportUtil.buildWriterFormat(routeAppId, formId, template, extendData);
        if (consumer != null) {
            consumer.accept((Object)format);
        }
        if (exportData.length > 0) {
            ExportUtil.clearChangeTypeAndAuditTrail(exportData[0], format);
        }
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportWriterFormat)format);
        return format;
    }

    public static ExportWriterFormat getExportWriterFormatAndWriteHeadCustomized(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, Object formId, Object template, Object extendData, long modelId, long dimensionId) {
        ExportWriterFormat format = ExportUtil.buildWriterFormat(routeAppId, formId, template, extendData);
        if (format != null && format.fields.contains(COLUMN_DEFINED_PROPERTY)) {
            DynamicObjectCollection defineProps = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"number,propertyn", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("dimension", "=", (Object)dimensionId)}, (String)"id");
            List definedPropNames = defineProps.stream().map(x -> x.getString("number")).collect(Collectors.toList());
            if (!definedPropNames.isEmpty()) {
                int colIndexOfDefinedProp = -1;
                for (int i = 0; i < format.fields.size(); ++i) {
                    if (!COLUMN_DEFINED_PROPERTY.equals(format.fields.get(i))) continue;
                    colIndexOfDefinedProp = i;
                    break;
                }
                ArrayList tailPart = new ArrayList(format.fields.subList(colIndexOfDefinedProp + 1, format.fields.size()));
                format.fields = new ArrayList(format.fields.subList(0, colIndexOfDefinedProp));
                Map originPropValue = (Map)format.properties.remove(COLUMN_DEFINED_PROPERTY);
                for (String oneDefinedProp : definedPropNames) {
                    String newColumnTitle = ExportUtil.buildDefinedPropertyColumnName(oneDefinedProp);
                    format.fields.add(newColumnTitle);
                    HashMap propValueConfig = new HashMap(8);
                    originPropValue.entrySet().forEach(x -> {
                        Object newValue = x.getValue();
                        if ("DisplayName".equals(x.getKey())) {
                            newValue = newValue.toString() + oneDefinedProp;
                        } else if ("propName".equals(x.getKey())) {
                            newValue = newColumnTitle;
                        }
                        propValueConfig.put(x.getKey(), newValue);
                    });
                    format.properties.put(newColumnTitle, propValueConfig);
                }
                format.fields.addAll(tailPart);
            } else {
                format.fields.removeIf(COLUMN_DEFINED_PROPERTY::equals);
                format.properties.remove(COLUMN_DEFINED_PROPERTY);
            }
        }
        if (format != null && ENUM_NEED_SWITCH.contains(extendData) && format.fields.contains(ENUM_FIELD)) {
            ArrayList<String> flexEnumItem = new ArrayList<String>();
            flexEnumItem.add("enumitem.name");
            format.flexColumn.put(ENUM_FIELD, flexEnumItem);
            ArrayList<String> flexDisplayEnumItem = new ArrayList<String>();
            flexDisplayEnumItem.add(ResManager.loadKDString((String)"\u679a\u4e3e\u9879(\u540d\u79f0)", (String)"ExportUtil_1", (String)"epm-far-business", (Object[])new Object[0]));
            format.flexColumnDisplay.put(ENUM_FIELD, flexDisplayEnumItem);
            JSONArray jsonArray = ((Map)format.properties.get(ENUM_FIELD)).getOrDefault("DataKey", new JSONArray());
            jsonArray.add((Object)"name");
            ((Map)format.properties.get(ENUM_FIELD)).put("DataKey", jsonArray);
        }
        if (format != null && (format.fields.contains(EXCHANGE_ATT) || format.fields.contains(ENTRYRATE_ATT)) && !format.name.equals("bcm_extmemberimp")) {
            DynamicObjectCollection accMems = ExportUtil.getAllRates(modelId);
            Map<String, String> name2Index = ExportUtil.createMappingOfAccount();
            if (accMems != null && accMems.size() > 0) {
                JSONArray inputArrType;
                ArrayList accounts = new ArrayList(10);
                accMems.forEach(x -> {
                    StringBuilder sb = new StringBuilder(16);
                    sb.append(x.getString("name"));
                    sb.append(" # ");
                    String number = (String)name2Index.get(x.getString("number"));
                    sb.append(StringUtils.isEmpty((String)number) ? x.getString("number") : number);
                    accounts.add(sb.toString());
                });
                if (format.fields.contains(EXCHANGE_ATT)) {
                    inputArrType = (JSONArray)((Map)format.properties.get(EXCHANGE_ATT)).get("InputType");
                    inputArrType.clear();
                    inputArrType.addAll(accounts);
                    StringBuilder sb = new StringBuilder(16);
                    sb.append(ResManager.loadKDString((String)"\u4e0d\u6298\u7b97", (String)"AccountMemberAddPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    sb.append(" # ");
                    sb.append(ExchangeEnum.NONE.index);
                    inputArrType.add((Object)sb);
                }
                if (format.fields.contains(ENTRYRATE_ATT)) {
                    inputArrType = (JSONArray)((Map)format.properties.get(ENTRYRATE_ATT)).get("InputType");
                    inputArrType.clear();
                    inputArrType.addAll(accounts);
                }
            }
        }
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportWriterFormat)format);
        return format;
    }

    public static Map<String, String> createMappingOfAccount() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("ClosingRate", ExchangeEnum.TERMINAL.index);
        map.put("AverageRate", ExchangeEnum.AVERAGE.index);
        map.put("UserdefinedRate", ExchangeEnum.CUSTOM.index);
        return map;
    }

    public static final String buildDefinedPropertyColumnName(String definedProp) {
        return "definedpropertyvalue - " + definedProp;
    }

    public static ExportWriterFormat buildWriterFormat(String routeAppId, Object formId, Object template, Object extendData) {
        ExportWriterFormat format = null;
        String exportJson = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, template, EMPTY, extendData});
        if (!StringUtils.isEmpty((String)exportJson) && exportJson.startsWith("[")) {
            List formatArr = JSON.parseArray((String)exportJson, ExportWriterFormat.class);
            if (formatArr != null && !formatArr.isEmpty()) {
                format = (ExportWriterFormat)formatArr.get(0);
            }
        } else {
            format = (ExportWriterFormat)JSON.parseObject((String)exportJson, ExportWriterFormat.class);
        }
        return format;
    }

    public static void clearChangeTypeAndAuditTrail(DynamicObject exportData, ExportWriterFormat format) {
    }

    private static Long getModelId(DynamicObject dot) {
        DataEntityPropertyCollection props = dot.getDataEntityType().getProperties();
        String modelKey = null;
        if (props.containsKey((Object)"model")) {
            modelKey = "model";
        } else if (props.containsKey((Object)"modelid")) {
            modelKey = "modelid";
        }
        if (modelKey == null) {
            return null;
        }
        Object model = dot.get(modelKey);
        if (model instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        if (model instanceof Long) {
            return LongUtil.toLong((Object)model);
        }
        return null;
    }

    public static void clearChangeType(ExportWriterFormat format) {
        if (format != null) {
            format.flexColumn.keySet().removeIf(e -> e.startsWith("changetype"));
            format.flexColumnDisplay.keySet().removeIf(e -> e.startsWith("changetype"));
            format.flexColumnDesc.keySet().removeIf(e -> e.startsWith("changetype"));
            format.fields.removeIf(e -> e.startsWith("changetype"));
            format.properties.keySet().removeIf(e -> e.startsWith("changetype"));
            if (!format.next.isEmpty()) {
                format.next.forEach(f -> {
                    f.flexColumn.keySet().removeIf(e -> e.startsWith("changetype"));
                    f.flexColumnDisplay.keySet().removeIf(e -> e.startsWith("changetype"));
                    f.flexColumnDesc.keySet().removeIf(e -> e.startsWith("changetype"));
                    f.fields.removeIf(e -> e.startsWith("changetype"));
                    f.properties.keySet().removeIf(e -> e.startsWith("changetype"));
                });
            }
        }
    }

    public static void clearAuditTrail(ExportWriterFormat format) {
        if (format != null) {
            format.flexColumn.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            format.flexColumnDisplay.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            format.flexColumnDesc.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            format.fields.removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            format.properties.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            if (!format.next.isEmpty()) {
                format.next.forEach(f -> {
                    f.flexColumn.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                    f.flexColumnDisplay.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                    f.flexColumnDesc.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                    f.fields.removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                    f.properties.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                });
            }
        }
    }

    public static Map<String, String> convertMultiKeyValuePairString(String valueString) {
        String[] items;
        if (StringUtils.isEmpty((String)valueString)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(8);
        for (String item : items = StringUtils.split((String)valueString, (boolean)true, (char[])new char[]{';'})) {
            String[] keyValuePair = StringUtils.split((String)item, (boolean)true, (char[])new char[]{':'});
            Preconditions.checkState((keyValuePair.length == 2 ? 1 : 0) != 0, (Object)("'" + item + "' is not the key:seq:value style"));
            result.put(keyValuePair[0], keyValuePair[1]);
        }
        return result;
    }

    public static void postWriteSheet(SXSSFWorkbook wb, SXSSFSheet sheet) {
        try {
            sheet.flushRows();
        }
        catch (IOException e) {
            throw new KDBizException("export error");
        }
        CTWorksheet ctSheet = wb.getXSSFWorkbook().getSheet(sheet.getSheetName()).getCTWorksheet();
        ctSheet.getDimension().setRef("A1:" + ExportUtil.getColumnLabel(1) + sheet.getPhysicalNumberOfRows());
    }

    public static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append("Z");
            remainder = 26;
        } else {
            sb.append(SOURCES[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(SOURCES[remainder]);
        }
        return sb.reverse().toString();
    }

    public static ExportWriterFormat getAuthExportWriterFormatAndWriteHead(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle style, String routeAppId, String formId, long importTemplateId, String entityName, LinkedHashMap<String, String> showSteptypeNameMap) {
        ExportWriterFormat format = ExportUtil.buildWriterFormat(routeAppId, formId, importTemplateId, entityName);
        Iterator<Map.Entry<String, String>> iterator = showSteptypeNameMap.entrySet().iterator();
        ArrayList<String> stayFieldList = new ArrayList<String>(10);
        ArrayList<String> removeFieldList = new ArrayList<String>(10);
        while (iterator.hasNext()) {
            Map propertiesMap;
            Map.Entry<String, String> next = iterator.next();
            String fieldName = next.getKey();
            String showName = next.getValue();
            stayFieldList.add(fieldName);
            if (format == null || !Objects.nonNull(propertiesMap = (Map)format.properties.get(fieldName))) continue;
            propertiesMap.put("DisplayName", showName);
        }
        if (format != null) {
            Map properties = format.properties;
            for (Map.Entry next : properties.entrySet()) {
                String key = (String)next.getKey();
                if (!key.startsWith("level") || stayFieldList.contains(key)) continue;
                removeFieldList.add(key);
            }
            for (String removeField : removeFieldList) {
                properties.remove(removeField);
                format.fields.remove(removeField);
            }
            ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)style, (ExportWriterFormat)format);
        }
        return format;
    }

    public static DynamicObjectCollection getAllRates(Long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("parent.number", "=", (Object)"ExchangeRate");
        qf.and(new QFilter("number", "in", Arrays.asList("ClosingRate", "AverageRate", "UserdefinedRate")).or("number", "like", (Object)"UserdefinedRate%"));
        DynamicObjectCollection results = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"id,name,number", (QFilter[])qf.toArray(), (String)"number");
        Collections.swap(results, 0, 1);
        return results;
    }
}

