/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.business.serviceHelper;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.common.business.serviceHelper.MemberPermSpreadLogic;
import kd.epm.far.business.common.perm.UserDistributeServiceHelper;
import kd.epm.far.business.common.strategy.CMModel;
import kd.epm.far.business.common.strategy.EBModel;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.RPTModel;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;

public class MemberPermHelper {
    public static final String NUMBER = "number";
    public static final String ID = "id";

    @Deprecated
    public static Map<Long, Integer> getCslSchemePermission(String entityName, Long modelid, DynamicObjectCollection queryNodes) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getCslMemberPermission(entityName, modelid, queryNodes);
    }

    public static QFilter getModelPermFilter(String filterField, String formId, ApplicationTypeEnum application) {
        if ("bcm_modelperm_manager".equals(formId) || "report_modelperm_manager".equals(formId)) {
            return new QFilter(filterField, "in", MemberPermHelper.getLimitedModelListByUser(application, true));
        }
        return new QFilter(filterField, "in", MemberPermHelper.getLimitedModelListByUser(application, false));
    }

    public static Set<Long> getLimitedModelListByUser() {
        return MemberPermHelper.getLimitedModelListByUser(null);
    }

    public static Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application) {
        return MemberPermHelper.getLimitedModelListByUser(application, false);
    }

    public static Set<Long> getLimitedModelListByUser(String formId, ApplicationTypeEnum application) {
        if ("bcm_modelperm_manager".equals(formId) || "report_modelperm_manager".equals(formId)) {
            return MemberPermHelper.getLimitedModelListByUser(application, true);
        }
        return MemberPermHelper.getLimitedModelListByUser(application, false);
    }

    public static Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application, Boolean ifCheckManager) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getLimitedModelListByUser(application, ifCheckManager, true);
    }

    public static boolean ifUserHasRootPermByModel(long userId, String modelId) {
        return (Boolean)ThreadCache.get((Object)(CacheKey.PrefixString + Joiner.on((char)'-').join((Object)modelId, (Object)userId, new Object[]{"check_admin"})), () -> MemberPermHelper.ifUserHasRootPermByModelFromDb(userId, modelId));
    }

    private static boolean ifUserHasRootPermByModelFromDb(long userId, String modelId) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.ifUserHasRootPermByModelFromDb(userId, modelId);
    }

    public static boolean isModelAdmin(Long modelId) {
        Set<Long> modelIds = MemberPermHelper.getLimitedModelListByUser();
        return modelIds.contains(modelId);
    }

    public static boolean isFidmModelAdmin(Long modelId, String app) {
        return MemberPermHelper.isDiscModelAdmin(modelId, app);
    }

    public static Set<Long> getFidmModelAdmin() {
        return MemberPermHelper.getDisModelAdmin(ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static boolean isDiscModelAdmin(Long modelId, String appType) {
        long userId = RequestContext.get().getCurrUserId();
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter userFilter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
        userFilter.and(new QFilter("app", "=", (Object)appType));
        QFilter modelFilter = new QFilter("fidmmodel.id", "=", (Object)modelId);
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getFidmModelAdmin(new QFilter[]{userFilter, modelFilter}).size() > 0;
    }

    public static boolean isDiscModelSuperAdmin(String appType) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getFidmModelSuperAdmin(appType);
    }

    public static Set<Long> getDisModelAdmin(String appNumber) {
        long userId = RequestContext.get().getCurrUserId();
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter userFilter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
        userFilter.and(new QFilter("app", "=", (Object)appNumber));
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getFidmModelAdmin(new QFilter[]{userFilter}).stream().filter(t -> t.getLong("fidmmodel.id") != 0L).map(t -> t.getLong("fidmmodel.id")).collect(Collectors.toSet());
    }

    public static DynamicObjectCollection getDiscModelAdmin(Set<Long> modelIds, String appType) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getDiscModelAdmin(modelIds, appType);
    }

    public static Set<Long> getUserModelListByUser(String appId) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        IModel iModel = new CMModel();
        List<DynamicObject> useModels = iModel.getUseModels();
        Set set = useModels.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
        result.addAll(set);
        iModel = new RPTModel();
        useModels = iModel.getUseModels();
        set = useModels.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
        result.addAll(set);
        iModel = new EBModel();
        useModels = iModel.getUseModels();
        set = useModels.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
        result.addAll(set);
        return result;
    }
}

