/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.business.serviceHelper;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.perm.UserDistributeServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.ModelStatusEnum;
import kd.epm.far.common.common.util.LongUtil;

public class MemberPermSpreadLogic {
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String MODEL = "model";
    public static final String ROLEADMINBCM = "Role-Admin_bcm";
    public static final String ROLEADMINRPT = "Role-Admin_rpt";
    public static final String ROLEADMINFIDM = "Role-Admin_fidm";
    public static final String ROLEADMINFAR = "Role-Admin_far";

    private void addPermClass(Set<Long> allOrgIds, Map<Long, Integer> memberPerm, Object modelId, String entityName) {
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(entityName, String.valueOf(modelId), RequestContext.get().getUserId());
        this.permCalssHandler(allOrgIds, memberPerm, map);
    }

    private void permCalssHandler(Set<Long> allOrgIds, Map<Long, Integer> memberPerm, ArrayListMultimap<String, Long> map) {
        for (String key : map.keySet()) {
            List ids = map.get((Object)key);
            if ("1".equals(key)) {
                ids.stream().forEach(id -> {
                    Integer value;
                    if (allOrgIds.contains(id) && ((value = (Integer)memberPerm.get(id)) == null || value < 3)) {
                        memberPerm.put((Long)id, 3);
                    }
                });
                continue;
            }
            if ("2".equals(key)) {
                ids.stream().forEach(id -> {
                    Integer value;
                    if (allOrgIds.contains(id) && ((value = (Integer)memberPerm.get(id)) == null || value < 2)) {
                        memberPerm.put((Long)id, 2);
                    }
                });
                continue;
            }
            if (!"3".equals(key)) continue;
            ids.stream().forEach(id -> {
                Integer value;
                if (allOrgIds.contains(id) && (value = (Integer)memberPerm.get(id)) == null) {
                    memberPerm.put((Long)id, 1);
                }
            });
        }
    }

    public DynamicObjectCollection getFidmModelAdmin(QFilter[] filters) {
        List filterVal = Arrays.stream(filters).map(QFilter::getValue).collect(Collectors.toList());
        return (DynamicObjectCollection)ThreadCache.get((Object)(CacheKey.PrefixString + Joiner.on((char)'-').join(filterVal, (Object)"fidm_admin", new Object[0])), () -> QueryServiceHelper.query((String)"bcm_modelperm", (String)"fidmmodel.id", (QFilter[])filters));
    }

    public boolean getFidmModelSuperAdmin(String application) {
        DynamicObject[] dynamicObjects;
        DynamicObject managerRole = null;
        if (ApplicationTypeEnum.FIDM.appnum.equals(application)) {
            managerRole = BusinessDataServiceHelper.loadSingle((String)"bcm_perm_role", (String)"id,enable,bizdomain", (QFilter[])new QFilter(NUMBER, "=", (Object)ROLEADMINFIDM).and("enable", "=", (Object)true).toArray());
        } else if (ApplicationTypeEnum.FAR.appnum.equals(application)) {
            managerRole = BusinessDataServiceHelper.loadSingle((String)"bcm_perm_role", (String)"id,enable,bizdomain", (QFilter[])new QFilter(NUMBER, "=", (Object)ROLEADMINFAR).and("enable", "=", (Object)true).toArray());
        }
        if (managerRole == null) {
            return false;
        }
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        String id = managerRole.getString(ID);
        return StringUtils.isNotEmpty((CharSequence)id) && (dynamicObjects = BusinessDataServiceHelper.load((String)"perm_userrole", (String)"user", (QFilter[])new QFilter("role", "=", (Object)id).and(new QFilter("user", "=", (Object)userId)).toArray())) != null && dynamicObjects.length > 0;
    }

    Map<Long, Integer> getCslMemberPermission(String entityName, Long modelid, DynamicObjectCollection queryNodes) {
        HashMap<Long, Integer> permMap = new HashMap<Long, Integer>();
        Map<Long, DynamicObject> cslMap = queryNodes.stream().collect(Collectors.toMap(x -> x.getLong(ID), x -> x));
        this.addPermClass(cslMap.keySet(), permMap, modelid, entityName);
        boolean adminUserBol = this.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), modelid.toString());
        if (adminUserBol) {
            permMap.forEach((k, v) -> permMap.put((Long)k, 1));
        }
        return permMap;
    }

    public DynamicObjectCollection getDiscModelAdmin(Set<Long> modelIds, String appType) {
        String fields = "fidmmodel.id,username";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_modelperm", (String)fields, (QFilter[])new QFilter[]{new QFilter("fidmmodel.id", "in", modelIds).and(new QFilter("app", "=", (Object)appType))});
        return dynamicObjectCollection;
    }

    public Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application, Boolean ifCheckManager, Boolean isCheckStatus) {
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        return (Set)ThreadCache.get((Object)(CacheKey.PrefixString + "limit_model_" + userId + application), () -> {
            DynamicObjectCollection dys;
            Set<Object> modelIds = new HashSet();
            Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
            groupIds.add(userId);
            QFilter filter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
            if (application != null) {
                filter = this.getIsManagerQFilter(application, ifCheckManager, filter);
                if (application == ApplicationTypeEnum.RPT) {
                    filter.and(new QFilter("model.reporttype", "in", (Object)new String[]{ApplicationTypeEnum.RPT.index, ApplicationTypeEnum.CM.index, ApplicationTypeEnum.PUB.index}));
                } else if (application == ApplicationTypeEnum.DI) {
                    filter.and(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.CM.index));
                } else if (application == ApplicationTypeEnum.BGMD) {
                    filter.and(new QFilter("model.reporttype", "in", (Object)new String[]{ApplicationTypeEnum.BGMD.index, ApplicationTypeEnum.EB.index, "6"}));
                } else if (application != ApplicationTypeEnum.BGBD) {
                    filter.and(new QFilter("model.reporttype", "=", (Object)application.index));
                }
                if (isCheckStatus.booleanValue()) {
                    filter.and(new QFilter("model.status", "=", (Object)ModelStatusEnum.AUDIT.getValue()));
                }
            }
            QFilter[] filters = this.getRptModelQFilter(filter);
            String entityname = "bcm_modelperm";
            if (application == ApplicationTypeEnum.BGMD) {
                entityname = "epm_modelperm";
            }
            if (!CollectionUtils.isEmpty((Collection)(dys = QueryServiceHelper.query((String)entityname, (String)"model.id", (QFilter[])filters)))) {
                modelIds = dys.stream().filter(dy -> dy.getLong("model.id") != 0L).map(dy -> dy.getLong("model.id")).collect(Collectors.toSet());
            }
            return modelIds;
        });
    }

    public QFilter getIsManagerQFilter(ApplicationTypeEnum application, Boolean ifCheckManager, QFilter filter) {
        if (ifCheckManager != null && ifCheckManager.booleanValue() && this.isManager(application)) {
            filter = new QFilter("modelpermentry.eusers", ">", (Object)0L);
        }
        return filter;
    }

    private QFilter[] getRptModelQFilter(QFilter filter) {
        return new QFilter[]{filter};
    }

    public boolean isManager(ApplicationTypeEnum application) {
        DynamicObject managerRole = null;
        if (ApplicationTypeEnum.CM == application) {
            managerRole = BusinessDataServiceHelper.loadSingle((String)"bcm_perm_role", (String)"id,enable,bizdomain", (QFilter[])new QFilter(NUMBER, "=", (Object)ROLEADMINBCM).and("enable", "=", (Object)true).toArray());
        } else if (ApplicationTypeEnum.RPT == application) {
            managerRole = BusinessDataServiceHelper.loadSingle((String)"bcm_perm_role", (String)"id,enable,bizdomain", (QFilter[])new QFilter(NUMBER, "=", (Object)ROLEADMINRPT).and("enable", "=", (Object)true).toArray());
        }
        if (managerRole == null) {
            return false;
        }
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        String id = managerRole.getString(ID);
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            boolean existUser = QueryServiceHelper.exists((String)"perm_userrole", (QFilter[])new QFilter("role", "=", (Object)id).and(new QFilter("user", "=", (Object)userId)).toArray());
            return existUser;
        }
        return false;
    }

    public boolean ifUserHasRootPermByModel(long userId, String modelId) {
        return (Boolean)ThreadCache.get((Object)(CacheKey.PrefixString + Joiner.on((char)'-').join((Object)modelId, (Object)userId, new Object[]{"check_admin"})), () -> this.ifUserHasRootPermByModelFromDb(userId, modelId));
    }

    public boolean ifUserHasRootPermByModelFromDb(long userId, String modelId) {
        String isGalaxySystem = System.getProperty("isGalaxySystem");
        if (isGalaxySystem != null && isGalaxySystem.equalsIgnoreCase("true")) {
            return false;
        }
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter filter1 = new QFilter(MODEL, "=", (Object)LongUtil.toLong((Object)modelId));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MemberPermSpreadLogic.ifUserHasRootPermByModel", (String)"bcm_modelperm", (String)"id,modelpermentry.eusers.id", (QFilter[])new QFilter[]{filter1}, null);){
            for (Row row : ds) {
                if (!groupIds.contains(row.getLong("modelpermentry.eusers.id"))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

