/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.config;

import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.cache.AppCacheServiceHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.config.ConfigEnum;
import kd.epm.far.common.common.util.QFBuilder;

public class ConfigServiceHelper {
    private static final String CONFIG = "config";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";

    public static boolean getGlobalBoolParam(String key) {
        return ConfigServiceHelper.getBoolParam(0L, key);
    }

    public static boolean getBoolParam(Long modelid, String key) {
        return (Boolean)ThreadCache.get((Object)(CacheKey.PrefixString + modelid + "|" + key), () -> {
            Object value = AppCacheServiceHelper.get(modelid + "." + key);
            if (value == null) {
                value = ConfigServiceHelper.queryConfig(modelid, key);
                ConfigServiceHelper.cacheIt(modelid, key, value);
            }
            return ConfigServiceHelper.resolverConfigParam(value);
        });
    }

    public static boolean resolverConfigParam(Object result) {
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            return "true".equalsIgnoreCase(result.toString()) || "1".equals(result.toString());
        }
        if (result instanceof Integer) {
            return (Integer)result == 1;
        }
        return false;
    }

    public static void cacheIt(Long modelid, String key, Object value) {
        if (value != null) {
            AppCacheServiceHelper.put(modelid + "." + key, value);
        }
    }

    private static Object queryConfig(Long modelid, String key) {
        return ThreadCache.get((Object)(CacheKey.PrefixString + String.format("querycfg-%d-%s", modelid, key)), () -> {
            QFBuilder qf = new QFBuilder();
            qf.add(MODEL, "=", (Object)modelid);
            qf.add(NUMBER, "=", (Object)key);
            DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)CONFIG, (QFilter[])qf.toArray());
            if (obj != null) {
                return obj.get(CONFIG);
            }
            return ConfigEnum.getConfigDataByNumber((String)key).isConfig();
        });
    }

    public static void remove(Long modelId, String key) {
        AppCacheServiceHelper.remove(modelId + "." + key);
    }
}

