/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ConfigsettingEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.gpt.DisclosureGPTConstants;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class DMConfigServiceHelper {
    public static String getValueByNumber(String number) {
        Map<String, Object> item = DMConfigServiceHelper.getItemByNumber(0L, number);
        return item.get("config").toString();
    }

    public static String getValueByNumber(Long modelId, String number) {
        Map<String, Object> item = DMConfigServiceHelper.getItemByNumber(modelId, number);
        return item.get("config").toString();
    }

    public static String getTextByNumber(Long modelId, String number) {
        Map<String, Object> item = DMConfigServiceHelper.getItemByNumber(modelId, number);
        return item.get("configtext").toString();
    }

    public static Map<String, Object> getItemByNumber(Long modelId, String number) {
        LinkedHashMap<String, Object> setting = null;
        if (StringUtils.isEmpty((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DMConfigServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ConfigsettingEnum enumData = ConfigsettingEnum.getByNumber(number);
        if (enumData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"DMConfigServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (enumData.getParamType().equals("0")) {
            modelId = 0L;
        } else if (enumData.getParamType().equals("1") && (modelId == null || modelId <= 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DMConfigServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String selectFields = "id,number,name,description,creator.name,createtime,modifier.name,modifytime,isenable,config,model.id,configtext";
        QFilter modelQt = new QFilter("model", "=", (Object)modelId);
        QFilter numberQt = new QFilter("number", "=", (Object)number);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"fidm_configsetting", (String)selectFields, (QFilter[])new QFilter[]{modelQt, numberQt});
        setting = new LinkedHashMap<String, Object>(2);
        setting.put("id", 0L);
        setting.put("number", enumData.getNumber());
        setting.put("name", enumData.getName());
        setting.put("config", enumData.getDefaultVal());
        setting.put("configname", DMConfigServiceHelper.getConfigName(enumData, dy));
        setting.put("description", enumData.getDesc());
        setting.put("modelid", modelId);
        setting.put("creatorname", enumData.getName());
        setting.put("createtime", TimeServiceHelper.now());
        setting.put("creator", RequestContext.get().getUserName());
        setting.put("modifier", RequestContext.get().getUserName());
        setting.put("modifytime", TimeServiceHelper.now());
        setting.put("isenable", "1");
        setting.put("configtext", "");
        if (dy != null) {
            setting.put("id", dy.getLong("id"));
            setting.put("config", dy.getString("config"));
            setting.put("configtext", dy.getString("configtext"));
            setting.put("creatorname", dy.getString("creator.name"));
            setting.put("isenable", dy.getString("isenable"));
            setting.put("creator", dy.getString("creator.name"));
            setting.put("createtime", dy.getDate("createtime"));
            setting.put("modifier", dy.getString("modifier.name"));
            setting.put("modifytime", dy.getDate("modifytime"));
        }
        return setting;
    }

    public static List<Map<String, Object>> getList(Long modelId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(2);
        String paramType = modelId == null || modelId == 0L ? "0" : "1";
        List<ConfigsettingEnum> enumList = ConfigsettingEnum.getList(paramType);
        String selectFields = "id,number,name,description,creator.name,createtime,modifier.name,modifytime,isenable,config,model.id,configtext";
        DynamicObjectCollection dbList = QueryServiceHelper.query((String)"fidm_configsetting", (String)selectFields, (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        List<String> notDisplays = DMConfigServiceHelper.getNotDisplayParams();
        for (ConfigsettingEnum enumData : enumList) {
            if (notDisplays.contains(enumData.getNumber())) continue;
            DynamicObject dy = dbList.stream().filter(m -> m.getString("number").equals(enumData.getNumber())).findAny().orElse(null);
            LinkedHashMap<String, Object> setting = new LinkedHashMap<String, Object>(2);
            setting.put("id", 0L);
            setting.put("number", enumData.getNumber());
            setting.put("name", enumData.getName());
            setting.put("config", enumData.getDefaultVal());
            setting.put("configname", DMConfigServiceHelper.getConfigName(enumData, dy));
            setting.put("description", enumData.getDesc());
            setting.put("modelid", modelId);
            setting.put("creatorname", enumData.getName());
            setting.put("createtime", TimeServiceHelper.now());
            setting.put("creator", RequestContext.get().getUserName());
            setting.put("modifier", RequestContext.get().getUserName());
            setting.put("modifytime", TimeServiceHelper.now());
            setting.put("isenable", "1");
            setting.put("configtext", "");
            if (dy != null) {
                setting.put("id", dy.getLong("id"));
                setting.put("config", dy.getString("config"));
                setting.put("configtext", dy.getString("configtext"));
                setting.put("creatorname", dy.getString("creator.name"));
                setting.put("isenable", dy.getString("isenable"));
                setting.put("creator", dy.getString("creator.name"));
                setting.put("createtime", dy.getDate("createtime"));
                setting.put("modifier", dy.getString("modifier.name"));
                setting.put("modifytime", dy.getDate("modifytime"));
            }
            list.add(setting);
        }
        return list;
    }

    public static List<String> getNotDisplayParams() {
        ArrayList<String> notDisplays = new ArrayList<String>(100);
        if (!DMConfigServiceHelper.checkGPTParamsExist()) {
            notDisplays.add(ConfigsettingEnum.FIDM03.getNumber());
            notDisplays.add(ConfigsettingEnum.FIDM04.getNumber());
        }
        notDisplays.add(ConfigsettingEnum.FIDM02.getNumber());
        return notDisplays;
    }

    public static boolean checkGPTParamsExist() {
        LicenseCheckResult result;
        Long groupId = DisclosureGPTConstants.LicenseGPTGroupId;
        Long userId = RequestContext.get().getCurrUserId();
        String licenseVersion = LicenseServiceHelper.getProductVersion();
        return Integer.parseInt(licenseVersion.split("\\.")[0]) >= 6 && Boolean.TRUE.equals((result = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)groupId)).getHasLicense());
    }

    private static String getConfigName(ConfigsettingEnum enumData, DynamicObject dy) {
        String type;
        String val = "-";
        if (enumData == ConfigsettingEnum.FIDM01) {
            String type2 = dy == null ? enumData.getDefaultVal() : dy.getString("config");
            OpenWordEnum openWordEnum = OpenWordEnum.getByType(type2);
            if (openWordEnum == null) {
                return type2;
            }
            return openWordEnum.getName();
        }
        if (enumData == ConfigsettingEnum.FIDM02 || enumData == ConfigsettingEnum.FIDM04) {
            if (dy != null) {
                return ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"DMConfigServiceHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"DMConfigServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]);
        }
        String string = type = dy == null ? enumData.getDefaultVal() : dy.getString("config");
        if (type.equals("0")) {
            return ResManager.loadKDString((String)"\u5426", (String)"DMConfigServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (type.equals("1")) {
            return ResManager.loadKDString((String)"\u662f", (String)"DMConfigServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]);
        }
        return val;
    }

    public static List<ComboItem> getConfigItem(String number) {
        ArrayList<ComboItem> list = new ArrayList(2);
        if (ConfigsettingEnum.FIDM01.getNumber().equals(number)) {
            list = OpenWordEnum.getItems();
            list = list.stream().filter(m -> !OpenWordEnum.EPMCLIENT.getType().equals(m.getValue()) && !OpenWordEnum.WPS.getType().equals(m.getValue()) && !OpenWordEnum.WEBOFFICE.getType().equals(m.getValue())).collect(Collectors.toList());
        } else {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"DMConfigServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0])));
            item.setValue("0");
            list.add(item);
            ComboItem item1 = new ComboItem();
            item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"DMConfigServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0])));
            item1.setValue("1");
            list.add(item1);
        }
        return list;
    }

    public static void openEidtView(IFormView view, IFormPlugin plugin, Long modelId, String number) {
        if (StringUtils.isEmpty((String)number)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("modelId", modelId.toString());
        params.put("paramNumber", number);
        String formId = "fidm_configsetting";
        if (ConfigsettingEnum.FIDM02.getNumber().equals(number)) {
            formId = "fidm_configsetting_fidm02";
        } else if (ConfigsettingEnum.FIDM04.getNumber().equals(number)) {
            formId = "fidm_configsetting_fidm04";
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(params);
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e", (String)"DMConfigServiceHelper_10", (String)"epm-far-business", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "fidm_configsetting");
        formShowParameter.setCloseCallBack(closeCallBack);
        view.showForm(formShowParameter);
    }

    public static boolean save(Long modelId, String number, String configVal, String configtext) {
        if (StringUtils.isEmpty((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DMConfigServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ConfigsettingEnum enumData = ConfigsettingEnum.getByNumber(number);
        if (enumData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"DMConfigServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (enumData.getParamType().equals("0")) {
            modelId = 0L;
        } else if (enumData.getParamType().equals("1") && (modelId == null || modelId <= 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DMConfigServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
        }
        boolean isInsert = false;
        QFilter modelQt = new QFilter("model", "=", (Object)modelId);
        QFilter numberQt = new QFilter("number", "=", (Object)number);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"fidm_configsetting", (QFilter[])new QFilter[]{modelQt, numberQt});
        if (dy == null) {
            dy = BusinessDataServiceHelper.newDynamicObject((String)"fidm_configsetting");
            dy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dy.set("number", (Object)enumData.getNumber());
            dy.set("isenable", (Object)"1");
            dy.set("creator", (Object)RequestContext.get().getCurrUserId());
            dy.set("createtime", (Object)TimeServiceHelper.now());
            isInsert = true;
        }
        dy.set("model", (Object)modelId);
        dy.set("name", (Object)enumData.getName());
        dy.set("description", (Object)enumData.getDesc());
        dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dy.set("modifytime", (Object)TimeServiceHelper.now());
        if (!StringUtils.isEmpty((String)configVal)) {
            dy.set("config", (Object)configVal);
        }
        if (!StringUtils.isEmpty((String)configtext)) {
            dy.set("configtext", (Object)configtext);
        }
        if (isInsert) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        } else {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dy});
        }
        String realVal = configVal;
        if (StringUtils.isEmpty((String)realVal)) {
            realVal = configtext;
        }
        DisclosureLogHelper.writeConfigLog(OperationResult.SUCCESS, OperationName.OPER, number, realVal);
        return true;
    }

    public static String getAndCheckOpenWordEnum() {
        String openType = DMConfigServiceHelper.getValueByNumber(0L, ConfigsettingEnum.FIDM01.getNumber());
        return openType;
    }

    public static void repair() {
        String openType = DMConfigServiceHelper.getValueByNumber(0L, ConfigsettingEnum.FIDM01.getNumber());
        if (openType.equals(OpenWordEnum.WPS.getType()) || openType.equals(OpenWordEnum.WEBOFFICE.getType())) {
            DMConfigServiceHelper.save(0L, ConfigsettingEnum.FIDM01.getNumber(), OpenWordEnum.WEB.getType(), "");
        }
    }
}

