/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.control.tree;

import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;

public interface ITreeNode<T>
extends Serializable {
    public String getId();

    public String getName();

    public T getData();

    public ITreeNode<T> getParent();

    public void setParent(ITreeNode<T> var1);

    public List<ITreeNode<T>> getChildren();

    public void addChild(ITreeNode<T> var1);

    public boolean removeChild(ITreeNode<T> var1);

    public boolean removeAll();

    public boolean addAllChild(List<ITreeNode<T>> var1);

    public boolean isOpened();

    public void SetIsOpened(boolean var1);

    default public ITreeNode<T> getTreeNode(String id, int maxLevel) {
        if (this.getId().equalsIgnoreCase(id)) {
            return this;
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            for (ITreeNode<T> child : this.getChildren()) {
                ITreeNode<T> node = child.getTreeNode(id, maxLevel - 1);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    default public boolean isLeaf() {
        return this.getChildren() == null || this.getChildren().size() == 0;
    }

    default public void iterate(int maxLevel, Consumer<ITreeNode<T>> callback) {
        callback.accept(this);
        if (maxLevel > 0 && this.getChildren() != null) {
            for (ITreeNode<ITreeNode<ITreeNode>> iTreeNode : this.getChildren()) {
                iTreeNode.iterate(maxLevel - 1, callback);
            }
        }
    }
}

