/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.control.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.epm.far.business.common.control.tree.ITreeNode;
import kd.epm.far.common.common.Recorder;
import org.apache.commons.lang3.tuple.Pair;

public class TreeModel<E extends ITreeNode<?>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private E root;
    private Map<String, ITreeNode<?>> dict = new HashMap();
    private boolean isBuiltDict = false;

    public TreeModel(E root) {
        Objects.requireNonNull(root);
        this.root = root;
    }

    public E getRoot() {
        return this.root;
    }

    public E searchByNodeId(String nodeId) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        return (E)this.dict.get(nodeId);
    }

    private void buildNodeDictionary() {
        this.cycleIterateNode((ITreeNode<?>)this.root);
        this.isBuiltDict = true;
    }

    private void cycleIterateNode(ITreeNode<?> node) {
        this.dict.put(node.getId(), node);
        for (ITreeNode<?> n : node.getChildren()) {
            this.cycleIterateNode(n);
        }
    }

    public List<E> seekAllChildrenIf(String pNodeId, Predicate<E> p) {
        E node = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)node, pNodeId);
        Recorder r = new Recorder(new ArrayList());
        if (p.test(this.root)) {
            ((List)r.getRecord()).add(this.root);
        }
        this.cycleSeekAllNodes((ITreeNode<?>)node, p, (Recorder<List<E>>)r);
        return (List)r.getRecord();
    }

    private void cycleSeekAllNodes(ITreeNode<?> node, Predicate<E> p, Recorder<List<E>> r) {
        node.getChildren().forEach(t -> {
            if (p.test(t)) {
                ((List)r.getRecord()).add(t);
            }
            this.cycleSeekAllNodes((ITreeNode<?>)t, p, r);
        });
    }

    private void cycleNode(ITreeNode<?> pNode, Consumer<ITreeNode<?>> cs) {
        pNode.getChildren().forEach(c -> {
            cs.accept((ITreeNode<?>)c);
            this.cycleNode((ITreeNode<?>)c, cs);
        });
    }

    private void checkNode(ITreeNode<?> node, String nodeId) {
        if (node == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8282\u70b9ID\uff1a%s\u5728\u6811\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TreeModel_0", (String)"epm-far-business", (Object[])new Object[0]), nodeId));
        }
    }

    public TreeNode buildEntryTree(TreeView tree) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        tree.deleteAllNodes();
        TreeNode troot = new TreeNode();
        this.cloneTreeNode(true, troot, (ITreeNode<?>)this.root);
        tree.addNode(troot);
        return troot;
    }

    private void cloneTreeNode(boolean isRoot, TreeNode parentNode, ITreeNode<?> currNode) {
        TreeNode pNode = parentNode;
        if (isRoot) {
            parentNode.setId(currNode.getId());
            parentNode.setText(currNode.getName());
            parentNode.setIsOpened(currNode.isOpened());
            if (!currNode.isLeaf()) {
                parentNode.setChildren(new ArrayList());
            }
        } else {
            TreeNode child = new TreeNode(parentNode.getId(), currNode.getId(), currNode.getName(), !currNode.isLeaf());
            child.setIsOpened(currNode.isOpened());
            parentNode.addChild(child);
            pNode = child;
        }
        for (ITreeNode<?> c : currNode.getChildren()) {
            this.cloneTreeNode(false, pNode, c);
        }
    }

    public Map<String, ITreeNode<?>> getDict() {
        return this.dict;
    }

    public Pair<TreeNode, Set<String>> loadtoNode(TreeView tree, String nodeId) {
        ITreeNode<?> parent;
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        List selectedNodeId = tree.getTreeState().getCheckedNodeIds();
        tree.deleteAllNodes();
        TreeNode troot = new TreeNode();
        ITreeNode<?> find = this.dict.get(nodeId);
        HashSet<String> openedNodeIdSets = new HashSet<String>();
        for (parent = find.getParent(); parent != null; parent = parent.getParent()) {
            openedNodeIdSets.add(parent.getId());
        }
        if (!find.isLeaf()) {
            openedNodeIdSets.add(find.getId());
        }
        if (!selectedNodeId.isEmpty()) {
            for (String s : selectedNodeId) {
                if (openedNodeIdSets.contains(s)) continue;
                find = this.dict.get(s);
                for (parent = find.getParent(); parent != null && !openedNodeIdSets.contains(parent.getId()); parent = parent.getParent()) {
                    openedNodeIdSets.add(parent.getId());
                }
            }
        }
        this.loadOpenedTreeNode(true, troot, (ITreeNode<?>)this.root, (Set<String>)openedNodeIdSets);
        TreeNode focusNode = new TreeNode();
        focusNode.setId(nodeId);
        tree.addNode(troot);
        openedNodeIdSets.forEach(e -> tree.expand(e));
        tree.focusNode(focusNode);
        for (String s : selectedNodeId) {
            TreeNode selectNode = new TreeNode();
            selectNode.setId(s);
            tree.checkNode(selectNode);
        }
        return Pair.of((Object)troot, openedNodeIdSets);
    }

    private void loadOpenedTreeNode(boolean isRoot, TreeNode parentNode, ITreeNode<?> currNode, Set<String> openedNodeIdSets) {
        TreeNode pNode = parentNode;
        if (isRoot) {
            parentNode.setId(currNode.getId());
            parentNode.setText(currNode.getName());
            parentNode.setIsOpened(currNode.isOpened());
            if (!currNode.isLeaf()) {
                parentNode.setChildren(new ArrayList());
            }
        } else {
            TreeNode child = new TreeNode(parentNode.getId(), currNode.getId(), currNode.getName(), !currNode.isLeaf());
            parentNode.addChild(child);
            pNode = child;
        }
        if (openedNodeIdSets.contains(currNode.getId())) {
            for (ITreeNode<?> c : currNode.getChildren()) {
                this.loadOpenedTreeNode(false, pNode, c, openedNodeIdSets);
            }
        }
    }
}

