/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.control.tree.virtualload;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.epm.far.common.common.MessageConstant;

public class SearchCursor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int cursor = -1;
    private String prevNodeId = "";
    private List<String> searchList = new ArrayList<String>();

    public void addSearchItem(String nodeId) {
        this.searchList.add(nodeId);
    }

    public boolean hasNextSearchRecord() {
        return !this.searchList.isEmpty() && this.searchList.size() - 1 > this.cursor;
    }

    public boolean hasPrevSearchRecord() {
        return this.cursor > 0;
    }

    public String next() {
        if (this.hasNextSearchRecord()) {
            this.recordCurrentNode();
            return this.searchList.get(++this.cursor);
        }
        throw new KDBizException(MessageConstant.getSELECT_LAST());
    }

    public String prev() {
        if (this.hasPrevSearchRecord()) {
            this.recordCurrentNode();
            return this.searchList.get(--this.cursor);
        }
        throw new KDBizException(MessageConstant.getSELECT_FIRST());
    }

    private void recordCurrentNode() {
        if (this.cursor >= 0) {
            this.prevNodeId = this.searchList.get(this.cursor);
        }
    }

    public String getPrevNodeId() {
        return this.prevNodeId;
    }

    public void reset() {
        this.cursor = -1;
        this.searchList.clear();
    }
}

