/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.dataset.calculate.base.AbsDataSet;
import kd.epm.far.business.common.dataset.calculate.cal.MetadataCalculate;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.business.far.calculate.CalculateHelper;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.business.far.model.AnalysisData;
import kd.epm.far.business.far.model.MemberData;
import kd.epm.far.business.far.model.ParamData;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FarDataSet
extends AbsDataSet {
    private static final String isDim = "1";
    private AnalysisData data;

    public FarDataSet(Long datasetId, JSONObject jsonObject) {
        super(datasetId, false);
        this.initDataSet(jsonObject);
    }

    protected FarDataSet(Long datasetId, JSONObject jsonObject, boolean formPreview) {
        super(datasetId, formPreview);
        this.initDataSet(jsonObject);
    }

    private void initDataSet(JSONObject jsonObject) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            this.data = (AnalysisData)objectMapper.readValue(jsonObject.toJSONString(), AnalysisData.class);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u53c2\u6570\u5f02\u5e38\u3002", (String)"AnalysisDataSetCalculate1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        this.chapterId = this.data.getChapterId();
        if (Objects.nonNull(this.formulaMap)) {
            this.buildParam();
        }
    }

    private void buildParam() {
        this.varHandler();
        this.dimHandler();
    }

    private void varHandler() {
        if (this.varParams.isEmpty()) {
            return;
        }
        Long id = LongUtil.isvalidLong((Object)this.chapterId) ? this.chapterId.longValue() : this.ds.getLong("chapterId");
        this.dbHandler(id);
        this.pageVarHandler();
        this.buildModifyVarParams(this.data.getItem().getDataset().getVarParams());
    }

    private void dimHandler() {
        Boolean finalIsISC;
        if (this.dimMembers.isEmpty()) {
            return;
        }
        Boolean isISC = Boolean.FALSE;
        if (MetadataCalculate.class.isAssignableFrom(this.calculate.getClass())) {
            isISC = Boolean.TRUE;
        }
        if (!(finalIsISC = isISC).booleanValue()) {
            this.buildDefaultParams(this.dimMembers);
            this.pageDimHandler();
            this.buildModifyDimParams(this.data.getItem().getDataset().getDimParams());
        }
    }

    private void buildDefaultParams(Map<String, Set<String>> dimMembers) {
        Long modelId = this.ds.getLong("discmodel.id");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        ModelInfo model = modelStrategyEx.getModel().getModelInfo();
        String modeltype = model.getModelType();
        DisModelTypeEnum enumByType = DisModelTypeEnum.getEnumByType(modeltype);
        IModel strategy = ModelStrategy.getStrategy(enumByType);
        String defaultDataSet = strategy.getDefaultDataSetByModelIdAndDataSetId(modelId, this.datasetId);
        for (String key : dimMembers.keySet()) {
            dimMembers.put(key, Sets.newHashSet((Object[])new String[]{DimDefaultValueHelper.getDefaultValue(key, modelId, enumByType, defaultDataSet).getDefaultValue()}));
        }
    }

    private void buildModifyVarParams(List<ParamData> paramDataList) {
        if (CollectionUtils.isEmpty(paramDataList)) {
            return;
        }
        for (ParamData param : paramDataList) {
            if (Objects.nonNull(param.getIsDim()) && !Objects.equals(param.getIsDim(), "0") || !this.varParams.containsKey(param.getNumber()) || !StringUtils.isNotEmpty((String)param.getModifyvalue())) continue;
            this.varParams.put(param.getNumber(), param.getModifyvalue());
        }
    }

    private void buildModifyDimParams(List<ParamData> paramDataList) {
        if (CollectionUtils.isEmpty(paramDataList)) {
            return;
        }
        for (ParamData param : paramDataList) {
            String shorNumberUp;
            if (Objects.isNull(param.getIsDim()) || Objects.equals(param.getIsDim(), "0") || !this.dimMembers.containsKey((shorNumberUp = param.getShortNumber().toUpperCase(Locale.ENGLISH)).toUpperCase(Locale.ENGLISH))) continue;
            if (Objects.equals(param.getIsDim(), isDim)) {
                if (!Objects.nonNull(param.getMember()) || !Objects.nonNull(param.getMember().getNumber())) continue;
                this.dimMembers.put(shorNumberUp, Sets.newHashSet((Object[])new String[]{param.getMember().getNumber()}));
                continue;
            }
            if (!Objects.equals(param.getIsDim(), "2") || !Objects.nonNull(param.getMembers()) || param.getMembers().isEmpty()) continue;
            Set memberNums = param.getMembers().stream().map(MemberData::getNumber).filter(Objects::nonNull).collect(Collectors.toSet());
            this.dimMembers.put(shorNumberUp, memberNums);
        }
    }

    private void pageVarHandler() {
        if (Objects.isNull(this.data.getQueryConfig())) {
            return;
        }
        List<ParamData> varList = this.data.getQueryConfig().getDimList().stream().filter(param -> !Objects.equals(isDim, param.getIsDim())).collect(Collectors.toList());
        this.buildPageParams(varList, this.varParams);
    }

    private void buildPageParams(List<ParamData> paramDataList, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(paramDataList)) {
            return;
        }
        for (ParamData param : paramDataList) {
            if (!params.containsKey(param.getNumber())) continue;
            if (Objects.equals(VariableTypeEnum.DIM.getCode(), param.getValuetype())) {
                if (!Objects.nonNull(param.getMember())) continue;
                params.put(param.getNumber(), param.getMember().getNumber());
                continue;
            }
            params.put(param.getNumber(), param.getDefaultvalue());
        }
    }

    private void pageDimHandler() {
        if (Objects.isNull(this.data.getQueryConfig())) {
            return;
        }
        this.buildDimPageParams(this.data.getQueryConfig().getDimList(), this.dimMembers);
    }

    private <T> void buildDimPageParams(List<ParamData> paramDataList, Map<String, Set<String>> dimMembers) {
        if (CollectionUtils.isEmpty(paramDataList)) {
            return;
        }
        for (ParamData param : paramDataList) {
            String shorNumberUp;
            if (!CalculateHelper.isDimQueryConfig(param) || !dimMembers.containsKey(shorNumberUp = param.getShortNumber().toUpperCase(Locale.ENGLISH)) || !Objects.nonNull(param.getMember())) continue;
            dimMembers.put(shorNumberUp, Sets.newHashSet((Object[])new String[]{param.getMember().getNumber()}));
        }
    }
}

