/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.calculate.base.AbsDataSet;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.far.DimDefaultValueHelper;

public class FidmDataSet
extends AbsDataSet {
    private List<DimensionInfo> dimPreivewMembers;
    private Long preivewChapterId;
    private Map<String, Object> varPreivewParams;

    public FidmDataSet(Long preivewChapterId, Long datasetId, List<DimensionInfo> dimPreivewMembers, Map<String, Object> varPreivewParams, boolean fromPreview) {
        super(datasetId, fromPreview);
        this.dimPreivewMembers = dimPreivewMembers;
        this.preivewChapterId = preivewChapterId;
        this.varPreivewParams = varPreivewParams;
        this.buildParam();
    }

    private void buildParam() {
        this.varHandler();
        this.dimHandler();
    }

    private void varHandler() {
        if (this.varParams.isEmpty()) {
            return;
        }
        this.chapterId = this.ds.getLong("chapterId");
        if (this.preivewChapterId != null && this.preivewChapterId > 0L) {
            this.chapterId = this.preivewChapterId;
        }
        this.dbHandler(this.chapterId);
        if (this.varPreivewParams != null) {
            for (Map.Entry<String, Object> varItem : this.varPreivewParams.entrySet()) {
                if (!this.varParams.containsKey(varItem.getKey()) || varItem.getValue() == null || StringUtils.isEmpty((String)varItem.getValue().toString())) continue;
                this.varParams.put(varItem.getKey(), varItem.getValue());
            }
        }
    }

    private void dimHandler() {
        if (Objects.isNull(this.dimMembers)) {
            return;
        }
        this.buildDefaultParams(this.dimMembers);
        if (Objects.isNull(this.dimPreivewMembers)) {
            return;
        }
        for (String shortNumber : this.dimMembers.keySet()) {
            DimensionInfo dimension = this.dimPreivewMembers.stream().filter(m -> m.getShortNumber().equalsIgnoreCase(shortNumber)).findFirst().orElse(null);
            if (dimension == null || dimension.getMembers() == null || dimension.getMembers().size() == 0) continue;
            Set memberNums = dimension.getMembers().stream().map(m -> m.getNumber()).filter(Objects::nonNull).collect(Collectors.toSet());
            this.dimMembers.put(shortNumber, memberNums);
        }
    }

    private void buildDefaultParams(Map<String, Set<String>> dimMembers) {
        Long modelId = this.ds.getLong("discmodel.id");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        ModelInfo model = modelStrategyEx.getModel().getModelInfo();
        String modeltype = model.getModelType();
        DisModelTypeEnum enumByType = DisModelTypeEnum.getEnumByType(modeltype);
        IModel strategy = ModelStrategy.getStrategy(enumByType);
        String defaultDataSet = strategy.getDefaultDataSetByModelIdAndDataSetId(modelId, this.datasetId);
        for (String key : dimMembers.keySet()) {
            dimMembers.put(key, Sets.newHashSet((Object[])new String[]{DimDefaultValueHelper.getDefaultValue(key, modelId, enumByType, defaultDataSet).getDefaultValue()}));
        }
    }
}

